/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.mdt.ide.launch.ui;

import com.nxp.s32ds.ext.rcp.runtime.Log;
import com.nxp.s32ds.mdt.ide.core.MdtIdeCore;
import com.nxp.s32ds.mdt.ide.internal.launch.ui.Messages;
import com.nxp.s32ds.mdt.ide.launch.core.MdtIdeLaunchCore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.ILaunchShortcut2;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public abstract class MdtLaunchShortcut
implements ILaunchShortcut2 {
    public void launch(ISelection selection, String mode) {
        if (selection instanceof IStructuredSelection) {
            this.searchAndLaunch(((IStructuredSelection)selection).toArray(), mode, this.getSelectionEmptyMessage());
        }
    }

    public void launch(IEditorPart editor, String mode) {
        ISelection selection = editor.getEditorSite().getSelectionProvider().getSelection();
        if (selection instanceof IStructuredSelection) {
            this.searchAndLaunch(((IStructuredSelection)selection).toArray(), mode, this.getEditorEmptyMessage());
        }
    }

    public ILaunchConfiguration[] getLaunchConfigurations(ISelection selection) {
        return null;
    }

    public ILaunchConfiguration[] getLaunchConfigurations(IEditorPart editorpart) {
        return null;
    }

    public IResource getLaunchableResource(ISelection selection) {
        Object element;
        IStructuredSelection ss;
        if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1 && (element = ss.getFirstElement()) instanceof IAdaptable) {
            return this.getLaunchableResource((IAdaptable)element);
        }
        return null;
    }

    public IResource getLaunchableResource(IEditorPart editorpart) {
        return this.getLaunchableResource((IAdaptable)editorpart.getEditorInput());
    }

    protected IResource getLaunchableResource(IAdaptable adaptable) {
        return MdtIdeCore.extractSemanticWorkspaceResource((IAdaptable)adaptable);
    }

    protected void searchAndLaunch(Object[] scope, String mode, String emptyMessage) {
        List semanticElements = MdtIdeLaunchCore.extractSemanticRoots((Object[])scope);
        EObject semanticModel = null;
        if (semanticElements.size() == 0) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.MdtLaunchShortcut_launch_error_title, (String)emptyMessage);
        } else {
            semanticModel = semanticElements.size() > 1 ? this.chooseSemanticType(this.getShell(), semanticElements, mode) : (EObject)semanticElements.get(0);
        }
        if (semanticModel != null) {
            this.launch(semanticModel, mode);
        }
    }

    protected void launch(EObject semanticModel, String mode) {
        List<ILaunchConfiguration> configs = this.getCandidates(semanticModel, this.getConfigurationType());
        if (configs != null) {
            ILaunchConfiguration config = null;
            int count = configs.size();
            if (count == 1) {
                config = configs.get(0);
            } else if (count > 1 && (config = this.chooseConfiguration(configs, mode)) == null) {
                return;
            }
            if (config == null) {
                try {
                    NullProgressMonitor monitor = new NullProgressMonitor();
                    IContainer location = this.resolveLocation(semanticModel, (IProgressMonitor)monitor);
                    config = this.createConfiguration(location, semanticModel);
                }
                catch (CoreException e) {
                    IStatus status = e.getStatus();
                    Log.log((IStatus)status, (String)"com.nxp.s32ds.mdt.ide.launch.ui");
                    MessageDialog.openError((Shell)this.getShell(), (String)Messages.MdtLaunchShortcut_launch_error_title, (String)status.getMessage());
                    return;
                }
            }
            if (config != null) {
                DebugUITools.launch((ILaunchConfiguration)config, (String)mode);
            }
        }
    }

    protected ILaunchConfigurationType getConfigurationType() {
        ILaunchManager lm = DebugPlugin.getDefault().getLaunchManager();
        String configurationTypeId = this.getConfigurationTypeId();
        return lm.getLaunchConfigurationType(configurationTypeId);
    }

    protected abstract String getConfigurationTypeId();

    protected abstract String getEditorEmptyMessage();

    protected abstract String getSelectionEmptyMessage();

    protected abstract String getSemanticTypeSelectionTitle(String var1);

    protected abstract String getSemanticTypeSelectionMessage(String var1);

    protected ILabelProvider getSemanticTypeSelectionRenderer() {
        ComposedAdapterFactory.Descriptor.Registry registry = ComposedAdapterFactory.Descriptor.Registry.INSTANCE;
        ComposedAdapterFactory composedAdapterFactory = new ComposedAdapterFactory(registry);
        AdapterFactoryLabelProvider labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)composedAdapterFactory);
        return labelProvider;
    }

    protected Shell getShell() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    protected List<ILaunchConfiguration> getCandidates(EObject semanticModel, ILaunchConfigurationType configType) {
        List<ILaunchConfiguration> candidateConfigs = Collections.emptyList();
        try {
            ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfiguration[] configs = launchManager.getLaunchConfigurations(configType);
            candidateConfigs = new ArrayList<ILaunchConfiguration>(configs.length);
            int i = 0;
            while (i < configs.length) {
                ILaunchConfiguration config = configs[i];
                if (this.isCandidate(config, semanticModel)) {
                    candidateConfigs.add(config);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            Log.log((IStatus)e.getStatus(), (String)"com.nxp.s32ds.mdt.ide.launch.ui");
        }
        return candidateConfigs;
    }

    protected abstract boolean isCandidate(ILaunchConfiguration var1, EObject var2);

    protected ILaunchConfiguration chooseConfiguration(List<ILaunchConfiguration> configList, String mode) {
        IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setElements(configList.toArray());
        dialog.setTitle(this.getSemanticTypeSelectionTitle(mode));
        dialog.setMessage(Messages.MdtLaunchShortcut_configuration_select_message);
        dialog.setMultipleSelection(false);
        int result = dialog.open();
        labelProvider.dispose();
        if (result == 0) {
            return (ILaunchConfiguration)dialog.getFirstResult();
        }
        return null;
    }

    protected EObject chooseSemanticType(Shell shell, List<EObject> semanticTypes, String mode) {
        String title = this.getSemanticTypeSelectionTitle(mode);
        String message = this.getSemanticTypeSelectionMessage(mode);
        ILabelProvider renderer = this.getSemanticTypeSelectionRenderer();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, renderer);
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.setElements(semanticTypes.toArray());
        dialog.setMultipleSelection(false);
        if (dialog.open() != 0) {
            return null;
        }
        return (EObject)dialog.getFirstResult();
    }

    protected IContainer resolveLocation(EObject semanticModel, IProgressMonitor monitor) throws CoreException {
        IFolder location = null;
        IFile workspaceFile = MdtIdeCore.toWorkspaceFile((EObject)semanticModel);
        if (workspaceFile != null) {
            location = MdtIdeLaunchCore.createEmitConfigurationsFolder((IProject)workspaceFile.getProject(), (IProgressMonitor)monitor);
        }
        return location;
    }

    protected abstract ILaunchConfiguration createConfiguration(IContainer var1, EObject var2) throws CoreException;
}

