/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.gte.sptprogram.design;

import com.nxp.s32ds.gte.gas.GasFactory;
import com.nxp.s32ds.gte.gas.GasIncludeDirective;
import com.nxp.s32ds.gte.gas.GasProgram;
import com.nxp.s32ds.gte.gas.GasStatement;
import com.nxp.s32ds.gte.sptgen.SptGen;
import com.nxp.s32ds.gte.sptgen.SptGenFactory;
import com.nxp.s32ds.gte.sptprogram.design.SptProgramDescriptor;
import com.nxp.s32ds.vgt.ide.core.VgtDescriptor;
import com.nxp.s32ds.vgt.ide.ui.VgtRepresenter;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public abstract class SptProgramRepresenter
implements VgtRepresenter {
    public VgtDescriptor createGraphDescriptor() {
        return this.createSptProgramDescriptor();
    }

    public SptProgramDescriptor createSptProgramDescriptor() {
        SptProgramDescriptor descriptor = new SptProgramDescriptor();
        descriptor.setStringValueInitial(SptProgramDescriptor.TARGET_FOLDER_NAME, "spt_gen");
        return descriptor;
    }

    public EObject createGeneratorModel(VgtDescriptor descriptor, EObject semanticModel) {
        SptGen sptGen = SptGenFactory.eINSTANCE.createSptGen();
        String targetProjectName = descriptor.getStringValue(SptProgramDescriptor.TARGET_PROJECT_NAME);
        sptGen.setProjectDirectory(targetProjectName);
        String targetFolderName = descriptor.getStringValue(SptProgramDescriptor.TARGET_FOLDER_NAME);
        sptGen.setSourceFolder(targetFolderName);
        return sptGen;
    }

    public String getSemanticFileName(VgtDescriptor descriptor) {
        String modelName = descriptor.getSemanticModelName();
        return String.valueOf(modelName) + '.' + this.getSemanticFileExtension();
    }

    public String getGeneratorFileExtension() {
        return "sptgen";
    }

    public String getGeneratorFileName(VgtDescriptor descriptor) {
        String modelName = descriptor.getSemanticModelName();
        return String.valueOf(modelName) + '.' + this.getGeneratorFileExtension();
    }

    public ILaunchConfigurationWorkingCopy createLaunchConfiguration(VgtDescriptor descriptor, EObject semanticModel, IProgressMonitor monitor) throws CoreException {
        return null;
    }

    public String getRepresentationFileName(VgtDescriptor descriptor) {
        String modelName = descriptor.getSemanticModelName();
        return String.valueOf(modelName) + '.' + "aird";
    }

    protected void fillMemoryIncludes(GasProgram program) {
        List<String> includes = Arrays.asList("tram.inc", "oram.inc", "wr.inc");
        this.fillIncludes(program, includes);
    }

    protected void fillIncludes(GasProgram program, List<String> includes) {
        EList list = program.getStatements();
        if (!includes.isEmpty()) {
            int i = 0;
            while (i < includes.size()) {
                GasIncludeDirective includeDir = GasFactory.eINSTANCE.createGasIncludeDirective();
                String fileName = includes.get(i);
                includeDir.setFileName(fileName);
                includeDir.setLabel(fileName);
                if (i > 0) {
                    includeDir.setPredecessor((GasStatement)list.get(i - 1));
                }
                list.add((Object)includeDir);
                ++i;
            }
        }
    }
}

