/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.internal.p2.engine.spi;

import com.nxp.s32ds.ext.rcp.internal.p2.engine.spi.Messages;
import com.nxp.s32ds.ext.rcp.internal.p2.engine.spi.UnnativeTouchpoint;
import com.nxp.s32ds.ext.rcp.internal.p2.engine.spi.Unzip;
import com.nxp.s32ds.ext.rcp.internal.p2.engine.spi.Util;
import com.nxp.s32ds.ext.rcp.p2.engine.LockedFilesTracker;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.engine.Profile;
import org.eclipse.equinox.internal.p2.touchpoint.natives.IBackupStore;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.spi.ProvisioningAction;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.util.NLS;

public class InstallAction
extends ProvisioningAction {
    public static final String ACTION_COPY = "copy";
    public static final String ACTION_CLEANUPCOPY = "cleanupcopy";

    public IStatus execute(Map<String, Object> parameters) {
        LockedFilesTracker lft = new LockedFilesTracker();
        IStatus retCode = Status.CANCEL_STATUS;
        WeakHashMap<String, Object> localParameters = new WeakHashMap<String, Object>();
        localParameters.putAll(parameters);
        IBackupStore store = UnnativeTouchpoint.getBackupStore((IProfile)parameters.get("profile"));
        if (store != null) {
            localParameters.put("backup", store);
        }
        String downloadFolder = String.valueOf(Util.getTempFolder()) + "s32ds_" + System.currentTimeMillis();
        lft.setUnzipFolder(downloadFolder);
        retCode = Unzip.unzip(localParameters, false, downloadFolder);
        if (retCode != Status.OK_STATUS) {
            return retCode;
        }
        retCode = InstallAction.copy(localParameters, downloadFolder, lft);
        if (localParameters.get("mergeBase") != null && localParameters.get("mergeExtra") != null) {
            retCode = InstallAction.mergeFiles(parameters);
        }
        this.deleteFolder(new File(downloadFolder));
        return retCode;
    }

    public static IStatus mergeFiles(Map<String, Object> parameters) {
        File baseMerge = new File((String)parameters.get("mergeBase"));
        File extraMerge = new File((String)parameters.get("mergeExtra"));
        IBackupStore store = (IBackupStore)parameters.get("backup");
        if (store != null) {
            try {
                store.backupCopy(baseMerge);
            }
            catch (IOException e) {
                Util.logError(e.getMessage());
            }
        }
        if (baseMerge.exists() && extraMerge.exists()) {
            if (Util.getExtension(baseMerge).equals("xml") && Util.getExtension(extraMerge).equals("xml")) {
                Util.mergeXMLFiles(baseMerge, extraMerge);
            } else {
                try {
                    Util.apendStream(new FileInputStream(extraMerge), true, new FileOutputStream(baseMerge), true);
                }
                catch (Exception e) {
                    return new Status(4, "com.nxp.s32ds.ext.rcp.p2.engine", 0, NLS.bind((String)Messages.merge_failed, (Object)baseMerge.getPath()), (Throwable)e);
                }
            }
        }
        return Status.OK_STATUS;
    }

    private static IStatus copy(Map<String, Object> parameters, String sourceDir, LockedFilesTracker lft) {
        String target = (String)parameters.get("target");
        if (target == null) {
            return new Status(4, "com.nxp.s32ds.ext.rcp.p2.engine", 0, NLS.bind((String)Messages.param_not_set, (Object)"target", (Object)ACTION_COPY), null);
        }
        IBackupStore backupStore = (IBackupStore)parameters.get("backup");
        if (sourceDir == null) {
            return new Status(4, "com.nxp.s32ds.ext.rcp.p2.engine", 0, NLS.bind((String)Messages.param_not_set, (Object)"source", (Object)ACTION_COPY), null);
        }
        String overwrite = (String)parameters.get("overwrite");
        Profile profile = (Profile)parameters.get("profile");
        IInstallableUnit iu = (IInstallableUnit)parameters.get("iu");
        String originalSource = sourceDir;
        String source = sourceDir;
        if (source.equals("@artifact")) {
            String artifactLocation = (String)parameters.get("artifact.location");
            if (artifactLocation == null) {
                IArtifactKey artifactKey = (IArtifactKey)parameters.get("artifact");
                return Util.createErrorMessage(NLS.bind((String)Messages.artifact_not_available, (Object)artifactKey));
            }
            source = artifactLocation;
        }
        Location location = Platform.getConfigurationLocation();
        Location eclipse = Platform.getInstallLocation();
        if (location != null && eclipse != null) {
            try {
                IPath path = InstallAction.getLocationIPath(location);
                IPath eclipsePath = InstallAction.getLocationIPath(eclipse);
                if (!eclipsePath.isPrefixOf(path)) {
                    IPath newTarget = path.removeLastSegments(1);
                    newTarget = newTarget.addTrailingSeparator();
                    Util.logWarning(String.format("%s is the new (USER) target parameter.%n", newTarget.toString()));
                    target = newTarget.toString();
                }
            }
            catch (URISyntaxException e) {
                Util.logWarning(e.getMessage());
                e.printStackTrace();
            }
        } else {
            Util.logError(String.format("FAIL to compute/validate/re-create target parameter.%n", new Object[0]));
            return Status.CANCEL_STATUS;
        }
        File sourceFile = new File(source);
        File targetFile = new File(target);
        File[] copiedFiles = null;
        try {
            copiedFiles = InstallAction.mergeCopy(sourceFile, targetFile, Boolean.valueOf(overwrite), backupStore, lft);
            String lockedFilesStorage = LockedFilesTracker.getLockedFilesStorage(parameters);
            boolean result = lft.copyLockedFiles(originalSource, lockedFilesStorage);
            if (result) {
                lft.createLockedFilesMapFile(lockedFilesStorage);
            }
        }
        catch (IOException e) {
            return Util.createErrorMessage(e.getMessage());
        }
        StringBuffer copiedFileNameBuffer = new StringBuffer();
        File[] fileArray = copiedFiles;
        int n = copiedFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File copiedFile = fileArray[n2];
            copiedFileNameBuffer.append(copiedFile.getAbsolutePath()).append("|");
            ++n2;
        }
        profile.setInstallableUnitProperty(iu, "copied|" + originalSource + "|" + target, copiedFileNameBuffer.toString());
        return Status.OK_STATUS;
    }

    private static File[] mergeCopy(File source, File target, boolean overwrite, IBackupStore backupStore, LockedFilesTracker lft) throws IOException {
        ArrayList<File> copiedFiles = new ArrayList<File>();
        InstallAction.xcopy(copiedFiles, source, target, overwrite, backupStore, lft);
        return copiedFiles.toArray(new File[copiedFiles.size()]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void xcopy(List<File> copiedFiles, File source, File target, boolean overwrite, IBackupStore backupStore, LockedFilesTracker lft) throws IOException {
        if (!source.exists()) {
            throw new IOException("Source: " + source + "does not exists");
        }
        if (source.isDirectory()) {
            if (target.exists() && target.isFile()) {
                if (!overwrite) {
                    throw new IOException("Target: " + target + " already exists");
                }
                if (backupStore != null) {
                    backupStore.backup(target);
                } else {
                    target.delete();
                }
            }
            if (!target.exists()) {
                target.mkdirs();
            }
            copiedFiles.add(target);
            File[] children = source.listFiles();
            if (children == null) {
                throw new IOException("Error while retrieving children of directory: " + source);
            }
            File[] fileArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File element = fileArray[n2];
                InstallAction.xcopy(copiedFiles, element, new File(target, element.getName()), overwrite, backupStore, lft);
                ++n2;
            }
            return;
        }
        if (target.exists() && !overwrite) {
            throw new IOException("Target: " + target + " already exists");
        }
        if (!target.getParentFile().exists() && !target.getParentFile().mkdirs()) {
            throw new IOException("Target: Path " + target.getParent() + " could not be created");
        }
        try {
            Throwable throwable = null;
            Object var7_15 = null;
            try {
                FileInputStream fis = new FileInputStream(source);
                try {
                    try (FileOutputStream fos = new FileOutputStream(target);){
                        Util.copyStream(fis, true, fos, true);
                        copiedFiles.add(target);
                    }
                    if (fis == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (fis == null) throw throwable;
                    fis.close();
                    throw throwable;
                }
                fis.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            lft.markLocked(source.getAbsolutePath().substring(lft.getUnzipFolder().length() + 1), target.getAbsolutePath());
            Util.logWarning(String.format("%s was detected as locked.%n", source.getAbsolutePath()));
        }
    }

    public IStatus undo(Map<String, Object> parameters) {
        InstallAction.cleanupcopy(parameters, true, null);
        return Status.OK_STATUS;
    }

    public static IStatus cleanupcopy(Map<String, Object> parameters, boolean restoreable, String targetDir) {
        String target;
        String source;
        String string = source = Util.getTempFolder() == "" ? (String)parameters.get("source") : Util.getTempFolder();
        if (source == null) {
            return Util.createErrorMessage(NLS.bind((String)Messages.param_not_set, (Object)"source", (Object)ACTION_CLEANUPCOPY));
        }
        String string2 = target = targetDir == null ? (String)parameters.get("target") : targetDir;
        if (target == null) {
            return Util.createErrorMessage(NLS.bind((String)Messages.param_not_set, (Object)"target", (Object)ACTION_CLEANUPCOPY));
        }
        IBackupStore backupStore = (IBackupStore)parameters.get("backup");
        if (backupStore == null) {
            backupStore = UnnativeTouchpoint.getBackupStore((IProfile)parameters.get("profile"));
        }
        IInstallableUnit iu = (IInstallableUnit)parameters.get("iu");
        IProfile profile = (IProfile)parameters.get("profile");
        String copied = profile.getInstallableUnitProperty(iu, "copied|" + source + "|" + target);
        if (copied == null) {
            return Status.OK_STATUS;
        }
        StringTokenizer tokenizer = new StringTokenizer(copied, "|");
        ArrayList<File> directories = new ArrayList<File>();
        while (tokenizer.hasMoreTokens()) {
            String fileName = tokenizer.nextToken();
            File file = new File(fileName);
            if (!file.exists()) continue;
            if (file.isDirectory()) {
                directories.add(0, file);
                continue;
            }
            if (restoreable) {
                try {
                    backupStore.backup(file);
                    continue;
                }
                catch (IOException iOException) {
                    return Util.createErrorMessage(NLS.bind((String)Messages.backup_file_failed, (Object)file));
                }
            }
            file.delete();
        }
        for (File file : directories) {
            File directory = file;
            File[] children = directory.listFiles();
            if (children == null) {
                return Util.createErrorMessage(NLS.bind((String)Messages.Error_list_children_0, (Object)directory));
            }
            if (children.length != 0) continue;
            if (restoreable) {
                try {
                    backupStore.backup(directory);
                    continue;
                }
                catch (IOException iOException) {
                    return Util.createErrorMessage(NLS.bind((String)Messages.backup_file_failed, (Object)directory));
                }
            }
            directory.delete();
        }
        return Status.OK_STATUS;
    }

    public void deleteFolder(File directory) {
        if (directory.isDirectory()) {
            File[] children;
            File[] fileArray = children = directory.listFiles();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File element = fileArray[n2];
                this.deleteFolder(new File(directory, element.getName()));
                ++n2;
            }
            if (!directory.delete()) {
                Util.logWarning(String.format("Cannot delete %s%n", directory));
            }
        } else if (!directory.delete()) {
            Util.logWarning(String.format("Cannot delete %s%n", directory));
        }
    }

    private static IPath getLocationIPath(Location loc) throws URISyntaxException {
        URI locationURI = null;
        IPath path = null;
        try {
            locationURI = loc.getURL().toURI();
        }
        catch (URISyntaxException uRISyntaxException) {
            String filePath = loc.getURL().getFile();
            File tempFile = new File(filePath);
            locationURI = tempFile.toURI();
        }
        if (locationURI != null) {
            path = URIUtil.toPath((URI)locationURI);
            return path;
        }
        Util.logWarning(String.format("Cannot obtain the proper locationURI value in getLocationIPath function. %n", new Object[0]));
        path = new Path(loc.getURL().getPath());
        if (path != null) {
            Util.logWarning(String.format("Use this [%s] path instead.%n", path.toString()));
        }
        return path;
    }
}

