/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.internal.p2.engine.spi;

import com.nxp.s32ds.ext.rcp.internal.p2.engine.spi.Messages;
import com.nxp.s32ds.ext.rcp.internal.p2.engine.spi.Util;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.touchpoint.natives.ClosedBackupStoreException;
import org.eclipse.equinox.internal.p2.touchpoint.natives.IBackupStore;
import org.eclipse.equinox.internal.p2.touchpoint.natives.LazyBackupStore;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.spi.Touchpoint;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.repository.artifact.IFileArtifactRepository;
import org.eclipse.osgi.util.NLS;

public class UnnativeTouchpoint
extends Touchpoint {
    public static final String PARM_BACKUP = "backup";
    public static final String PARM_ARTIFACT = "artifact";
    public static final String PARM_ARTIFACT_LOCATION = "artifact.location";
    public static final String PARM_MERGE_FILES_BASE = "mergeBase";
    public static final String PARM_MERGE_FILES_EXTRA = "mergeExtra";
    public static final String PARM_MERGE_EXTRA_ARGUMENT = "mergeExtraArgument";
    public static final String PARM_EXECUTE_COMMAND = "executeCommand";
    public static final String PARM_EXECUTE_WORKING_DIR = "executeWD";
    public static final String PARM_EXECUTE_ENVP = "executeENVP";
    public static final String PARM_EXECUTE_TYPE = "executeType";
    public static final String PARM_EXECUTE_INTERPRETER = "commandInterpreter";
    private static Map<IProfile, IBackupStore> backups = new WeakHashMap<IProfile, IBackupStore>();

    public IStatus initializeOperand(IProfile profile, Map<String, Object> parameters) {
        IProvisioningAgent agent = (IProvisioningAgent)parameters.get("agent");
        IArtifactKey artifactKey = (IArtifactKey)parameters.get(PARM_ARTIFACT);
        if (!parameters.containsKey(PARM_ARTIFACT_LOCATION) && artifactKey != null) {
            try {
                IFileArtifactRepository downloadCache = Util.getDownloadCacheRepo(agent);
                File fileLocation = downloadCache.getArtifactFile(artifactKey);
                if (fileLocation != null && fileLocation.exists()) {
                    parameters.put(PARM_ARTIFACT_LOCATION, fileLocation.getAbsolutePath());
                }
            }
            catch (ProvisionException e) {
                return e.getStatus();
            }
        }
        return Status.OK_STATUS;
    }

    public IStatus initializePhase(IProgressMonitor monitor, IProfile profile, String phaseId, Map<String, Object> touchpointParameters) {
        touchpointParameters.put(PARM_BACKUP, UnnativeTouchpoint.getBackupStore(profile));
        return null;
    }

    public String qualifyAction(String actionId) {
        return "com.nxp.s32ds.ext.rcp.p2.ui." + actionId;
    }

    public IStatus prepare(IProfile profile) {
        return super.prepare(profile);
    }

    public IStatus commit(IProfile profile) {
        IBackupStore store = UnnativeTouchpoint.getBackupStore(profile);
        store.discard();
        return Status.OK_STATUS;
    }

    public static String escape(String toEscape) {
        StringBuffer buffer = new StringBuffer();
        int length = toEscape.length();
        int i = 0;
        while (i < length) {
            char ch = toEscape.charAt(i);
            switch (ch) {
                case '\"': 
                case '%': 
                case '*': 
                case '/': 
                case ':': 
                case '<': 
                case '>': 
                case '?': 
                case '\\': 
                case '|': {
                    buffer.append("%" + ch + ";");
                    break;
                }
                default: {
                    buffer.append(ch);
                }
            }
            ++i;
        }
        return buffer.toString();
    }

    public IStatus rollback(IProfile profile) {
        IStatus returnStatus = Status.OK_STATUS;
        IBackupStore store = UnnativeTouchpoint.getBackupStore(profile);
        try {
            store.restore();
        }
        catch (IOException e) {
            returnStatus = new Status(4, "com.nxp.s32ds.ext.rcp.p2.engine", NLS.bind((String)Messages.failed_backup_restore, (Object)store.getBackupName()), (Throwable)e);
        }
        catch (ClosedBackupStoreException e) {
            returnStatus = new Status(4, "com.nxp.s32ds.ext.rcp.p2.engine", NLS.bind((String)Messages.failed_backup_restore, (Object)store.getBackupName()), (Throwable)e);
        }
        UnnativeTouchpoint.clearProfileState(profile);
        return returnStatus;
    }

    private static synchronized void clearProfileState(IProfile profile) {
        backups.remove(profile);
    }

    public static synchronized IBackupStore getBackupStore(IProfile profile) {
        IBackupStore store = backups.get(profile);
        if (store == null) {
            store = new LazyBackupStore(UnnativeTouchpoint.escape(profile.getProfileId()));
            backups.put(profile, store);
        }
        return store;
    }
}

