/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cross.spt.explorer.internal;

import com.nxp.s32ds.cross.spt.explorer.internal.ISPTInstructionsHolder;
import com.nxp.s32ds.cross.spt.explorer.internal.SPTInstructionsHolder;
import com.nxp.s32ds.cross.spt.explorer.internal.instructions.ISPTDirective;
import com.nxp.s32ds.cross.spt.explorer.internal.instructions.SPTDirective;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class SPTInstructionsRoot {
    public static final String ROOT_NAME = "SPT Instructions";
    private Set<ISPTInstructionsHolder> holders = new TreeSet<ISPTInstructionsHolder>();
    private String sptVersion;

    public SPTInstructionsRoot() {
        this.addDirectives();
    }

    void addHolder(ISPTInstructionsHolder holder) {
        this.holders.add(holder);
    }

    public boolean hasHolders() {
        return this.holders.size() > 1;
    }

    Set<ISPTInstructionsHolder> getHolders() {
        return this.holders;
    }

    public Set<ISPTInstructionsHolder> getActivatedHolders() {
        List activeHolders = this.holders.stream().filter(h -> h.matchVersion(this.sptVersion)).collect(Collectors.toList());
        return activeHolders.size() > 1 ? new TreeSet<ISPTInstructionsHolder>(activeHolders) : new TreeSet();
    }

    public void setSptVersion(String sptVersion) {
        this.sptVersion = sptVersion;
    }

    private void addDirectives() {
        SPTInstructionsHolder dirsHolder = new SPTInstructionsHolder(ISPTInstructionsHolder.Type.DIRECTIVES);
        dirsHolder.addInstruction(new SPTDirective(ISPTDirective.Directive.EXTERN));
        dirsHolder.addInstruction(new SPTDirective(ISPTDirective.Directive.INCLUDE));
        dirsHolder.addInstruction(new SPTDirective(ISPTDirective.Directive.GLOBAL));
        dirsHolder.addInstruction(new SPTDirective(ISPTDirective.Directive.LABEL));
        dirsHolder.addInstruction(new SPTDirective(ISPTDirective.Directive.SECTION));
        this.holders.add(dirsHolder);
    }
}

