/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.validation.utils;

import com.nxp.s32ds.ext.ide.validation.utils.ChangeSearchRequestor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.search.core.text.TextSearchEngine;
import org.eclipse.search.core.text.TextSearchRequestor;
import org.eclipse.search.core.text.TextSearchScope;
import org.eclipse.search.ui.text.FileTextSearchScope;
import org.eclipse.text.edits.ReplaceEdit;

public class ResourceTextSearchEngine {
    private static final String REVERT_SEARCH = "(?s)\\A((?!%s).)*\\Z";

    static List<IFile> findResourceOutOfTextChanges(IResource project, String[] fileNamePatterns, String search, String replace, IProgressMonitor pm) {
        ArrayList<IFile> result = new ArrayList<IFile>();
        FileTextSearchScope scope = FileTextSearchScope.newSearchScope((IResource[])new IResource[]{project}, (String[])fileNamePatterns, (boolean)false);
        String searchRequestNotMaching = String.format(REVERT_SEARCH, search);
        Pattern pattern = Pattern.compile(searchRequestNotMaching, 8);
        ChangeSearchRequestor searchRequestor = new ChangeSearchRequestor(replace);
        TextSearchEngine engine = TextSearchEngine.create();
        if (engine != null && engine.search((TextSearchScope)scope, (TextSearchRequestor)searchRequestor, pattern, pm).isOK()) {
            Set<IFile> keySet = searchRequestor.getFileChanges().keySet();
            result.addAll(keySet);
        }
        return result;
    }

    static Map<IFile, List<ReplaceEdit>> findResourceTextChanges(IResource project, String[] fileNamePatterns, String search, String replace, IProgressMonitor pm) {
        Map<IFile, List<ReplaceEdit>> result = new HashMap<IFile, List<ReplaceEdit>>();
        IResource[] roots = new IResource[]{project};
        FileTextSearchScope scope = FileTextSearchScope.newSearchScope((IResource[])roots, (String[])fileNamePatterns, (boolean)false);
        Pattern pattern = Pattern.compile(search, 8);
        ChangeSearchRequestor searchRequestor = new ChangeSearchRequestor(replace);
        TextSearchEngine engine = TextSearchEngine.create();
        if (engine != null && engine.search((TextSearchScope)scope, (TextSearchRequestor)searchRequestor, pattern, pm).isOK()) {
            result = searchRequestor.getFileChanges();
        }
        return result;
    }
}

