/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.examples.ui;

import com.nxp.s32ds.ext.ide.examples.core.ExampleProjectFacade;
import com.nxp.s32ds.ext.ide.examples.core.ProjectSet;
import com.nxp.s32ds.ext.ide.examples.ui.ExampleSelectionComposite;
import com.nxp.s32ds.ext.ide.examples.ui.Messages;
import com.nxp.s32ds.ext.ide.examples.ui.internal.ExIdtUiExamplesActivator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public abstract class ExampleSelectionPage
extends WizardPage {
    private static final String HELP_CONTEXT_ID = ".import_example_project_context";
    private final ExampleProjectFacade projectFacade;
    private ExampleSelectionComposite composite;
    private ProjectSet project = null;
    private String name = "";

    protected ExampleSelectionPage(ExampleProjectFacade projectFacade) {
        super("Select project");
        this.projectFacade = projectFacade;
    }

    public void createControl(Composite parent) {
        this.setTitle(Messages.Wizard_page_title);
        this.composite = new ExampleSelectionComposite(parent, this.projectFacade){

            @Override
            protected void projectSelected(ProjectSet project) {
                ExampleSelectionPage.this.project = project;
                this.updateStatus();
            }

            private void updateStatus() {
                IStatus status = ExampleSelectionPage.this.validate();
                ExampleSelectionPage.this.setPageComplete(status.isOK());
                ExampleSelectionPage.this.setErrorMessage(status.isOK() || status.getSeverity() == 8 ? null : status.getMessage());
            }

            @Override
            protected void nameChanged(String name) {
                ExampleSelectionPage.this.name = name;
                this.updateStatus();
            }
        };
        this.setControl((Control)this.composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.composite, String.valueOf(ExIdtUiExamplesActivator.getPluginId()) + HELP_CONTEXT_ID);
    }

    public void dispose() {
        this.composite.dispose();
        this.getControl().dispose();
        super.dispose();
    }

    public ProjectSet getProjects() {
        return this.project;
    }

    public String getName() {
        return this.name;
    }

    protected abstract IStatus validate();
}

