/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.cdt.core.makefilegenerator;

import com.nxp.s32ds.ext.cdt.core.makefilegenerator.IMakefileGeneratorContributor;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class MakefileGeneratorContributorRegistry {
    private static MakefileGeneratorContributorRegistry sInstance = null;
    Vector<Contributor> fContributors = new Vector();
    Vector<Contributor> fContributorsByConfiguration = new Vector();
    Vector<Contributor> fContributorsByProjectType = new Vector();

    public static MakefileGeneratorContributorRegistry getDefault() {
        if (sInstance == null) {
            sInstance = new MakefileGeneratorContributorRegistry();
        }
        return sInstance;
    }

    protected MakefileGeneratorContributorRegistry() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("com.nxp.s32ds.ext.cdt.makefilegenerator.MakefileGeneratorContributor");
        IExtension[] extensions = point.getExtensions();
        if (extensions != null) {
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    if (elements[j].getName().equals("contributor")) {
                        Contributor contrib = new Contributor(elements[j]);
                        if (contrib.getID() != null) {
                            this.fContributors.add(contrib);
                        }
                        if (contrib.getConfigurationID() != null) {
                            this.fContributorsByConfiguration.add(contrib);
                        }
                        if (contrib.getProjectTypeID() != null) {
                            this.fContributorsByProjectType.add(contrib);
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public IMakefileGeneratorContributor[] getContributors(String toolID) {
        Vector<IMakefileGeneratorContributor> cons = new Vector<IMakefileGeneratorContributor>();
        for (Contributor contribs : this.fContributors) {
            if (!contribs.getID().equals(toolID)) continue;
            cons.add(contribs.getExecutable());
        }
        return cons.toArray(new IMakefileGeneratorContributor[cons.size()]);
    }

    public IMakefileGeneratorContributor[] getContributorsForConfiguration(String id) {
        Vector<IMakefileGeneratorContributor> cons = new Vector<IMakefileGeneratorContributor>();
        for (Contributor contribs : this.fContributorsByConfiguration) {
            if (!contribs.getConfigurationID().equals(id)) continue;
            cons.add(contribs.getExecutable());
        }
        return cons.toArray(new IMakefileGeneratorContributor[cons.size()]);
    }

    public IMakefileGeneratorContributor[] getContributorsForProjectType(String id) {
        Vector<IMakefileGeneratorContributor> cons = new Vector<IMakefileGeneratorContributor>();
        for (Contributor contribs : this.fContributorsByProjectType) {
            if (!contribs.getProjectTypeID().equals(id)) continue;
            cons.add(contribs.getExecutable());
        }
        return cons.toArray(new IMakefileGeneratorContributor[cons.size()]);
    }

    private static class Contributor {
        String toolID;
        String configID;
        String projectTypeID;
        IConfigurationElement configurationElement;
        IMakefileGeneratorContributor executable = null;

        public Contributor(IConfigurationElement configurationElement) {
            this.toolID = configurationElement.getAttribute("tool");
            this.configID = configurationElement.getAttribute("configuration");
            this.projectTypeID = configurationElement.getAttribute("projectType");
            this.configurationElement = configurationElement;
        }

        public IMakefileGeneratorContributor getExecutable() {
            if (this.executable == null) {
                try {
                    this.executable = (IMakefileGeneratorContributor)this.configurationElement.createExecutableExtension("class");
                }
                catch (CoreException coreException) {}
            }
            return this.executable;
        }

        public String getID() {
            return this.toolID;
        }

        public String getConfigurationID() {
            return this.configID;
        }

        public String getProjectTypeID() {
            return this.projectTypeID;
        }
    }
}

