/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.MPC574xx_0_8_2.pexconf;

import com.freescale.s32ds.cross.sdk.MPC574xx_0_8_2.pexconf.Activator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.settings.model.CSourceEntry;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICSourceEntry;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

class PExConfigAdjuster {
    private static final String[] sourceFolders = new String[]{"SDK", "Generated_Code", "Sources"};
    private static final String[] includeFolders = new String[]{"Generated_Code", "Sources"};
    private static final Map<String, String> toolchainsIncludeOptions = new HashMap<String, String>();
    private IProject project;

    PExConfigAdjuster(IProject project) {
        toolchainsIncludeOptions.put("com.freescale.s32ds.cross.gnu.e200.tool.c.compiler", "gnu.c.compiler.option.include.paths");
        toolchainsIncludeOptions.put("com.freescale.s32ds.cross.gnu.e200.tool.cpp.compiler", "gnu.cpp.compiler.option.include.paths");
        toolchainsIncludeOptions.put("com.freescale.s32ds.cross.gnu.e200.tool.assembler", "gnu.both.asm.option.include.paths");
        toolchainsIncludeOptions.put("ghs.managedmake.ppc.executable.toolchain.cx_compiler", "ghs.managedmake.ppc.executable.toolchain.cx_compiler.project.include_directories");
        toolchainsIncludeOptions.put("ghs.managedmake.ppc.executable.toolchain.cc_compiler", "ghs.managedmake.ppc.executable.toolchain.cc_compiler.project.include_directories");
        this.project = project;
    }

    void adjustPExConfiguration() {
        try {
            this.createSourceEntries();
            this.adjustOptions();
            this.cleanupFolders();
        }
        catch (Exception e) {
            Activator.log(e);
        }
    }

    private void adjustOptions() throws BuildException {
        IConfiguration[] configs;
        IConfiguration[] iConfigurationArray = configs = ManagedBuildManager.getBuildInfo((IResource)this.project).getManagedProject().getConfigurations();
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            ITool[] tools;
            IConfiguration config = iConfigurationArray[n2];
            ITool[] iToolArray = tools = config.getTools();
            int n3 = tools.length;
            int n4 = 0;
            while (n4 < n3) {
                ITool tool = iToolArray[n4];
                String toolBaseId = tool.getBaseId();
                IOption option = null;
                String optionSuperClassId = toolchainsIncludeOptions.get(toolBaseId);
                if (optionSuperClassId != null) {
                    option = tool.getOptionBySuperClassId(optionSuperClassId);
                    String[] stringArray = includeFolders;
                    int n5 = includeFolders.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        String includeFolder = stringArray[n6];
                        this.addOptionValue(option, includeFolder);
                        ++n6;
                    }
                }
                if (toolBaseId.indexOf(".linker") != -1 && toolBaseId.indexOf("diab") != -1 && (option = tool.getOptionBySuperClassId("com.windriver.cdt.diab.option.linker.other")) != null) {
                    this.addOptionValue(0, option, "-Xpreprocess-lecl");
                }
                ++n4;
            }
            ++n2;
        }
    }

    private void createSourceEntries() throws CoreException {
        HashSet<CSourceEntry> additionalSourceEntrires = new HashSet<CSourceEntry>();
        String[] stringArray = sourceFolders;
        int n = sourceFolders.length;
        int n2 = 0;
        while (n2 < n) {
            String sourceFolder = stringArray[n2];
            additionalSourceEntrires.add(new CSourceEntry(this.project.getFolder(sourceFolder), null, 0));
            ++n2;
        }
        ICProjectDescription description = CCorePlugin.getDefault().getProjectDescription(this.project);
        ICConfigurationDescription[] iCConfigurationDescriptionArray = description.getConfigurations();
        int n3 = iCConfigurationDescriptionArray.length;
        n = 0;
        while (n < n3) {
            ICConfigurationDescription config = iCConfigurationDescriptionArray[n];
            HashSet<ICSourceEntry> sourceEntries = new HashSet<ICSourceEntry>(Arrays.asList(config.getSourceEntries()));
            sourceEntries.addAll(additionalSourceEntrires);
            config.setSourceEntries(sourceEntries.toArray(new ICSourceEntry[sourceEntries.size()]));
            ++n;
        }
        CCorePlugin.getDefault().setProjectDescription(this.project, description, false, (IProgressMonitor)new NullProgressMonitor());
    }

    private void addOptionValue(IOption opt, String value) throws BuildException {
        if (opt == null) {
            return;
        }
        ArrayList<String> curValueList = new ArrayList<String>(Arrays.asList(opt.getBasicStringListValue()));
        curValueList.add("\"${ProjDirPath}/" + value + "\"");
        opt.setValue(curValueList);
    }

    private void addOptionValue(int pos, IOption opt, String value) throws BuildException {
        if (opt == null || pos < 0) {
            return;
        }
        if (opt.getBasicValueType() == 3) {
            ArrayList<String> curValueList = new ArrayList<String>(Arrays.asList(opt.getBasicStringListValue()));
            if (!curValueList.contains(value)) {
                curValueList.add(pos, value);
            }
            opt.setValue(curValueList);
        }
    }

    private void cleanupFolders() throws CoreException {
        IFolder f4;
        IFolder f3 = this.project.getFolder("src");
        if (f3.exists() && !f3.isLinked()) {
            f3.delete(true, (IProgressMonitor)new NullProgressMonitor());
        }
        if ((f4 = this.project.getFolder("include")).exists() && !f4.isLinked()) {
            IResource[] iResourceArray = f4.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource fx = iResourceArray[n2];
                fx.delete(true, (IProgressMonitor)new NullProgressMonitor());
                ++n2;
            }
        }
    }
}

