/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.vgt.ide.ui.wizards;

import com.nxp.s32ds.vgt.ide.core.VgtDescriptor;
import com.nxp.s32ds.vgt.ide.internal.ui.UiMessages;
import com.nxp.s32ds.vgt.ide.internal.ui.VgtIdeUiActivator;
import com.nxp.s32ds.vgt.ide.ui.VgtIdeUi;
import com.nxp.s32ds.vgt.ide.ui.VgtRepresenter;
import com.nxp.s32ds.vgt.ide.ui.operations.VgtProjectCreationOperation;
import com.nxp.s32ds.vgt.ide.ui.wizards.VgtProjectListener;
import com.nxp.s32ds.vgt.ide.ui.wizards.VgtProjectWizardPage;
import com.nxp.s32ds.vgt.ide.ui.wizards.VgtTargetProjectListener;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public abstract class VgtProjectWizardBase
extends BasicNewProjectResourceWizard
implements VgtProjectListener,
VgtTargetProjectListener {
    private VgtProjectWizardPage projectPage;
    private String initialProjectName;
    private URI projectLocation;
    private IProject createdProject;
    private final VgtRepresenter representer;
    private final VgtDescriptor descriptor;

    public VgtProjectWizardBase(String singleRepresentationId) {
        if (singleRepresentationId == null) {
            throw new IllegalArgumentException("singleRepresentationId is null!");
        }
        List<VgtRepresenter> representers = VgtIdeUi.getRepresenters();
        VgtRepresenter candidate = null;
        for (VgtRepresenter r : representers) {
            String id = r.getId();
            if (id != singleRepresentationId) continue;
            candidate = r;
            break;
        }
        if (candidate == null) {
            throw new IllegalArgumentException("Representer with id = " + singleRepresentationId + " not found!");
        }
        this.representer = candidate;
        this.descriptor = this.representer.createGraphDescriptor();
    }

    public VgtProjectWizardBase(VgtRepresenter representer) {
        this.representer = representer;
        this.descriptor = representer.createGraphDescriptor();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        super.init(workbench, selection);
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.projectPage = this.createProjectCreationPage();
        this.projectPage.addGraphToolsProjectListener(this);
        this.projectPage.addGraphToolsTargetProjectListener(this);
        this.projectPage.setInitialProjectName(this.initialProjectName);
        this.initWizard((Wizard)this, (WizardPage)this.projectPage);
        this.addPage((IWizardPage)this.projectPage);
    }

    protected VgtProjectWizardPage createProjectCreationPage() {
        return new VgtProjectWizardPage("VgtProjectWizardPage");
    }

    protected abstract void initWizard(Wizard var1, WizardPage var2);

    public void dispose() {
        this.projectPage.removeGraphToolsProjectListener(this);
        super.dispose();
    }

    public boolean performFinish() {
        boolean finished = true;
        this.updatePerspective();
        IProject projectHandle = this.projectPage.getProjectHandle();
        IWorkingSet[] workingSets = this.projectPage.getSelectedWorkingSets();
        VgtProjectCreationOperation graphToolsProjectCreationOperation = new VgtProjectCreationOperation(this.representer, this.descriptor, projectHandle, null, this.projectLocation, workingSets);
        try {
            this.getContainer().run(true, false, (IRunnableWithProgress)graphToolsProjectCreationOperation);
            this.createdProject = projectHandle;
        }
        catch (InvocationTargetException e) {
            VgtIdeUiActivator.log(UiMessages.GraphToolsProjectWizard_e_project_creation_failed, e.getTargetException());
            finished = false;
        }
        catch (InterruptedException e) {
            VgtIdeUiActivator.log(UiMessages.GraphToolsProjectWizard_e_project_creation_interrupted, e);
            finished = false;
        }
        try {
            this.getContainer().run(false, false, monitor -> {
                try {
                    monitor.beginTask(UiMessages.GraphToolsProjectWizard_task_open_diagram, 2);
                    this.selectAndReveal((IResource)this.createdProject);
                    monitor.worked(1);
                    VgtIdeUi.openFirstRepresentation(this.createdProject, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1));
                }
                finally {
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            VgtIdeUiActivator.log(UiMessages.GraphToolsProjectWizard_e_graph_opening_failed, e.getTargetException());
            finished = false;
        }
        catch (InterruptedException e) {
            VgtIdeUiActivator.log(UiMessages.GraphToolsProjectWizard_e_graph_opening_interrupted, e);
            finished = false;
        }
        return finished;
    }

    @Override
    public void projectChanged(String projectName, IPath locationPath, URI locationURI) {
        this.projectLocation = Platform.getLocation().equals((Object)locationPath) ? null : locationURI;
        this.descriptor.hostProjectChanged(projectName);
    }

    @Override
    public void useDefaultLocationChanged(boolean value) {
        this.descriptor.setUseDefaultLocation(value);
    }

    @Override
    public void targetProjectChanged(String targetProjectName) {
        this.descriptor.setTargetProjectName(targetProjectName);
    }

    public IProject getNewProject() {
        return this.createdProject;
    }

    public void setInitialProjectName(String value) {
        this.initialProjectName = value;
    }
}

