/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.resources;

import com.nxp.s32ds.ext.ide.internal.resources.ResourcesMessages;
import com.nxp.s32ds.ext.ide.resources.ResourceNameValidator;
import com.nxp.s32ds.ext.rcp.databinding.validation.CIdentifierValidator;
import java.io.File;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class ProjectNameValidator
implements IValidator {
    private static ProjectNameValidator INSTANCE;

    private ProjectNameValidator() {
    }

    public static ProjectNameValidator getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ProjectNameValidator();
        }
        return INSTANCE;
    }

    public IStatus validate(Object projectName) {
        IStatus iStatus = ResourceNameValidator.project().validate(projectName);
        if (iStatus.isOK() && (iStatus = CIdentifierValidator.INSTANCE.validate(projectName)).isOK()) {
            iStatus = this.checkUniqueProjectInWorkspace(projectName);
        }
        return iStatus;
    }

    private IStatus checkUniqueProjectInWorkspace(Object projectName) {
        if (projectName instanceof String) {
            String name = (String)projectName;
            IWorkspace wsp = ResourcesPlugin.getWorkspace();
            IStatus status = wsp.validateName(name, 4);
            if (!status.isOK()) {
                return status;
            }
            if (wsp.getRoot().getProject(name).exists()) {
                return new Status(4, "com.nxp.s32ds.ext.ide.resources", ResourcesMessages.ProjectNameValidator_e_name_not_equal);
            }
            IProject[] iProjectArray = wsp.getRoot().getProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject p = iProjectArray[n2];
                if (name.equalsIgnoreCase(p.getName())) {
                    String message = NLS.bind((String)ResourcesMessages.ProjectNameValidator_e_name_is_similar, (Object)p.getName());
                    return new Status(4, "com.nxp.s32ds.ext.ide.resources", message);
                }
                ++n2;
            }
            File file = new File(wsp.getRoot().getLocationURI());
            File[] fileArray = file.listFiles(lfile -> name.equalsIgnoreCase(file.getName()));
            if (fileArray.length != 0) {
                File fileFromList = fileArray[0];
                String binding = fileFromList.isDirectory() ? ResourcesMessages.ProjectNameValidator_directory : ResourcesMessages.ProjectNameValidator_file;
                String message = NLS.bind((String)ResourcesMessages.ProjectNameValidator_e_name_already_exists, (Object[])new String[]{binding, file.getName()});
                return new Status(4, "com.nxp.s32ds.ext.ide.resources", message);
            }
            return Status.OK_STATUS;
        }
        return new Status(4, "com.nxp.s32ds.ext.ide.resources", ResourcesMessages.ResourceNameValidator_e_name_invalid);
    }
}

