/*
 * Decompiled with CFR 0.152.
 */
package com.pemicro.debug.gdbjtag.ppc.ui;

import java.util.ArrayList;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class DeviceTree
implements ITreeContentProvider {
    Node rootNode;

    public void initializeRootNode(ArrayList<String> deviceList) {
        this.rootNode = new Node();
        for (String device : deviceList) {
            String[] vendorFamilyDevice = device.split("_");
            Node family = this.searchNodes(vendorFamilyDevice[0], this.rootNode);
            Node vendor = this.searchNodes(vendorFamilyDevice[1], family);
            this.searchNodes(vendorFamilyDevice[2], vendor);
        }
    }

    public static String constructVendorFamilyDevice(Node leaf) {
        String result;
        try {
            result = String.valueOf(leaf.parent.parent.label) + '_';
            result = String.valueOf(result) + leaf.parent.label + '_';
            result = String.valueOf(result) + leaf.label;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
        return result;
    }

    private Node searchNodes(String key, Node parent) {
        for (Node currentKey : parent.children) {
            if (!currentKey.label.equals(key)) continue;
            return currentKey;
        }
        Node temp = new Node();
        temp.label = key;
        temp.parent = parent;
        parent.children.add(temp);
        return temp;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getElements(Object inputElement) {
        ArrayList<Node> elements = inputElement == null ? this.rootNode.children : ((Node)inputElement).children;
        Object[] result = elements.toArray(new Node[elements.size()]);
        return result;
    }

    public Object[] getChildren(Object parentElement) {
        return this.getElements(parentElement);
    }

    public Object getParent(Object element) {
        return ((Node)element).parent;
    }

    public boolean hasChildren(Object element) {
        return DeviceTree.isParent(element);
    }

    public static boolean isParent(Object element) {
        return ((Node)element).children.size() > 0;
    }

    public static class Node {
        String label;
        Node parent;
        ArrayList<Node> children = new ArrayList();

        Node() {
        }
    }
}

