/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.gte.sptprogram.design.service;

import com.nxp.s32ds.ext.emf.common.util.DiagnosticAttachment;
import com.nxp.s32ds.gte.gas.GasDirective;
import com.nxp.s32ds.gte.gas.GasExternDirective;
import com.nxp.s32ds.gte.gas.GasGlobalDirective;
import com.nxp.s32ds.gte.gas.GasIncludeDirective;
import com.nxp.s32ds.gte.gas.GasLabel;
import com.nxp.s32ds.gte.gas.GasSectionDirective;
import com.nxp.s32ds.gte.gas.GasStatement;
import com.nxp.s32ds.gte.gas.GasStatementContainer;
import com.nxp.s32ds.gte.sptprogram.SptEnumOperand;
import com.nxp.s32ds.gte.sptprogram.SptInstruction;
import com.nxp.s32ds.gte.sptprogram.SptLoopInstruction;
import com.nxp.s32ds.gte.sptprogram.SptOperand;
import com.nxp.s32ds.gte.sptprogram.SptStopInstruction;
import com.nxp.s32ds.gte.sptprogram.SptSyncInstruction;
import com.nxp.s32ds.gte.sptprogram.SptWaitInstruction;
import com.nxp.s32ds.gte.sptprogram.design.service.ServiceMessages;
import com.nxp.s32ds.vgt.ide.core.VgtDesignService;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.sirius.diagram.DEdge;

public class SptProgramDiagramServices
extends VgtDesignService {
    public String createStatementLabel(GasStatement statement) {
        String name = statement.getName();
        int count = SptProgramDiagramServices.getStatementCount(statement);
        String pattern = this.getLabelPattern(statement);
        String format = MessageFormat.format(pattern, name, count);
        return format;
    }

    public String createLabelSymbolValue(GasStatement statement) {
        int count = SptProgramDiagramServices.getStatementCount(statement);
        String format = "LABEL" + Integer.toString(count);
        return format;
    }

    public static int getStatementCount(GasStatement statement) {
        EObject eContainer = statement.eContainer();
        int count = 0;
        EClass eClass = statement.eClass();
        EList eContents = eContainer.eContents();
        for (EObject eObject : eContents) {
            if (!eObject.eClass().equals(eClass)) continue;
            ++count;
        }
        return count;
    }

    private String getLabelPattern(GasStatement statement) {
        if (statement instanceof SptInstruction) {
            return ServiceMessages.SptProgramDiagramServices_instruction_label_pattern;
        }
        if (statement instanceof GasDirective) {
            return ServiceMessages.SptProgramDiagramServices_directive_label_pattern;
        }
        return ServiceMessages.SptProgramDiagramServices_default_label_pattern;
    }

    public List<SptOperand> getOperands(SptInstruction instruction) {
        return instruction.getOperands();
    }

    public List<EObject> getExternDirectiveCandidates(GasStatementContainer container) {
        return this.resolveSemanticCandidates(container, GasExternDirective.class);
    }

    public List<EObject> getGlobalDirectiveCandidates(GasStatementContainer container) {
        return this.resolveSemanticCandidates(container, GasGlobalDirective.class);
    }

    public List<EObject> getIncludeDirectiveCandidates(GasStatementContainer container) {
        return this.resolveSemanticCandidates(container, GasIncludeDirective.class);
    }

    public List<EObject> getLabelStatementCandidates(GasStatementContainer container) {
        return this.resolveSemanticCandidates(container, GasLabel.class);
    }

    public List<EObject> getLoopCandidates(GasStatementContainer container) {
        return this.resolveSemanticCandidates(container, SptLoopInstruction.class);
    }

    public List<EObject> getSectionDirectiveCandidates(GasStatementContainer container) {
        return this.resolveSemanticCandidates(container, GasSectionDirective.class);
    }

    public List<EObject> getStopCandidates(GasStatementContainer container) {
        return this.resolveSemanticCandidates(container, SptStopInstruction.class);
    }

    public List<EObject> getSyncCandidates(GasStatementContainer container) {
        return this.resolveSemanticCandidates(container, SptSyncInstruction.class);
    }

    public List<EObject> getWaitCandidates(GasStatementContainer container) {
        return this.resolveSemanticCandidates(container, SptWaitInstruction.class);
    }

    public String getOperandLabel(SptOperand operand) {
        String name = operand.getName();
        String value = operand.getValue();
        if (operand instanceof SptEnumOperand) {
            value = value.replace("dot_", ".");
        }
        String pattern = ServiceMessages.SptProgramDiagramServices_operand_label_pattern;
        String format = MessageFormat.format(pattern, name, value);
        return format;
    }

    public Boolean hasError(EObject eObj) {
        if (eObj instanceof GasStatement || eObj instanceof GasStatementContainer) {
            Diagnostic diagnostic = Diagnostician.INSTANCE.validate(eObj);
            DiagnosticAttachment.attach((EObject)eObj, (Diagnostic)diagnostic);
            if (diagnostic.getSeverity() == 4) {
                return true;
            }
            return false;
        }
        return false;
    }

    public List<EObject> ignoreCandidates(GasStatementContainer container) {
        return ECollections.emptyEList();
    }

    public boolean isEnumOperand(SptOperand operand) {
        return operand.isEnum();
    }

    public void reconnectSuccessor(EObject element, EObject target, DEdge edgeAfterReconnect) {
        EObject oldSource = this.getEdgeSourceSemantic(element, edgeAfterReconnect);
        EObject newSource = this.getEdgeTargetSemantic(element, edgeAfterReconnect);
        EObject newTarget = this.getEdgeSourceSemantic(target, edgeAfterReconnect);
        if (target instanceof SptInstruction) {
            SptInstruction instruction = (SptInstruction)target;
            if (newTarget instanceof GasStatement) {
                GasStatement newPredecessor = (GasStatement)newTarget;
                newPredecessor.setSuccessor((GasStatement)instruction);
                return;
            }
        } else if (element instanceof GasStatement) {
            GasStatement instruction = (GasStatement)element;
            instruction.setSuccessor(null);
            if (oldSource instanceof GasStatement && newSource instanceof GasStatement) {
                GasStatement newPredecessor = (GasStatement)oldSource;
                GasStatement newSuccessor = (GasStatement)newSource;
                newPredecessor.setSuccessor(newSuccessor);
            }
        }
    }

    protected List<EObject> resolveSemanticCandidates(GasStatementContainer container, Class<?> target) {
        BasicEList candidates = new BasicEList();
        if (container == null) {
            return candidates;
        }
        EList statements = container.getStatements();
        if (target == null) {
            candidates.addAll((Collection)statements);
        } else {
            for (GasStatement statement : statements) {
                if (!target.isAssignableFrom(statement.getClass())) continue;
                candidates.add((Object)statement);
            }
        }
        return candidates;
    }

    public List<SptOperand> getKeyOperands(SptInstruction instruction) {
        Pattern keyPattern = Pattern.compile(ServiceMessages.SptProgramDiagramServices_keyOperand_pattern);
        BasicEList output = new BasicEList();
        for (SptOperand operand : instruction.getOperands()) {
            Matcher matcher = keyPattern.matcher(operand.getName());
            if (!matcher.matches()) continue;
            output.add((Object)operand);
        }
        return output;
    }

    public List<String> getKeyOperandsName(SptInstruction instruction) {
        Pattern keyPattern = Pattern.compile(ServiceMessages.SptProgramDiagramServices_keyOperand_pattern);
        BasicEList output = new BasicEList();
        for (SptOperand operand : instruction.getOperands()) {
            Matcher matcher = keyPattern.matcher(operand.getName());
            if (!matcher.matches()) continue;
            output.add((Object)this.getOperandLabel(operand));
        }
        return output;
    }

    public String getTooltip(SptInstruction instruction) {
        String tooltip = String.valueOf(instruction.getName()) + " ";
        for (SptOperand operand : instruction.getOperands()) {
            String value = operand.getValue();
            if (operand instanceof SptEnumOperand) {
                value = value.replace("dot_", ".");
            }
            tooltip = String.valueOf(tooltip) + value + (operand.isNeedComma() ? "," : " ");
        }
        if (tooltip.endsWith(",")) {
            tooltip = tooltip.substring(0, tooltip.length() - 1);
        }
        return tooltip;
    }

    public String getInstructionName(SptInstruction instruction) {
        return String.valueOf(instruction.getName()) + " (" + instruction.getLabel() + ")";
    }

    public EObject brokeRemovingOperand(EObject operand) {
        return null;
    }
}

