/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.mdt.ide.validation;

import com.nxp.s32ds.mdt.ide.validation.internal.ValidationMessages;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.osgi.util.NLS;

public class UniqueValueValidator
implements IValidator {
    private static final String BUNDLE_SYMBOLIC_NAME = "com.nxp.s32ds.mdt.ide.validation";
    private final String attribute;
    private final String errorMessage;
    private final EObject eObject;

    public UniqueValueValidator(EObject eObject, String attribute, String errorMessage) {
        this.eObject = eObject;
        this.attribute = attribute;
        this.errorMessage = errorMessage;
    }

    public IStatus validate(Object value) {
        String message = "";
        if (value instanceof EList) {
            EList list = (EList)value;
            if (this.doValidate((EList<EObject>)list)) {
                return Status.OK_STATUS;
            }
            return new Status(4, BUNDLE_SYMBOLIC_NAME, this.errorMessage);
        }
        message = NLS.bind((String)ValidationMessages.DuplicateValidator_e_property_invalid, (Object)this.attribute);
        return new Status(4, BUNDLE_SYMBOLIC_NAME, message);
    }

    private boolean doValidate(EList<EObject> list) {
        if (!list.isEmpty()) {
            String eObjectName = "";
            Object eObjectAttributeValue = this.getAttributeValue(this.eObject);
            if (eObjectAttributeValue != null && eObjectAttributeValue instanceof String) {
                eObjectName = (String)eObjectAttributeValue;
            }
            int i = 0;
            while (i < list.size()) {
                Object elementName = this.getAttributeValue((EObject)list.get(i));
                if (elementName != null && elementName instanceof String && eObjectName.equals(elementName)) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private Object getAttributeValue(EObject eObject) {
        EStructuralFeature eStructuralFeature = eObject.eClass().getEStructuralFeature(this.attribute);
        if (eStructuralFeature instanceof EAttribute) {
            return eObject.eGet(eStructuralFeature);
        }
        return null;
    }
}

