/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.cdt.suppliers;

import com.nxp.s32ds.ext.cdt.suppliers.PersistentPreferences;
import com.nxp.s32ds.ext.cdt.suppliers.ToolchainDefinition;
import com.nxp.s32ds.ext.ide.utils.OSFamily;
import com.nxp.s32ds.ext.ide.utils.PreferencesUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import org.eclipse.cdt.utils.WindowsRegistry;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;

public class DefaultPreferences {
    private static final String REG_SUBKEY = "SOFTWARE\\GNU ARM Eclipse\\Build Tools";
    private static final String REG32_SUBKEY = "SOFTWARE\\Wow6432Node\\GNU ARM Eclipse\\Build Tools";
    private static final String REG_NAME = "InstallFolder";
    private static IEclipsePreferences fgPreferences;
    public static final String DEFAULT_NAME = "default.name";
    public static final String DEFAULT_PATH = "default.path";
    public static final String TOOLCHAIN = "toolchains.prefs";
    private static Properties fgToolchainProperties;

    private static IEclipsePreferences getPreferences() {
        if (fgPreferences == null) {
            fgPreferences = DefaultScope.INSTANCE.getNode("com.nxp.s32ds.ext.cdt.core");
        }
        return fgPreferences;
    }

    public static String getString(String key, String defaulValue) {
        String value = DefaultPreferences.getPreferences().get(key, defaulValue);
        if (value != null) {
            value = value.trim();
        }
        return value;
    }

    public static boolean getBoolean(String key, boolean defaultValue) {
        return DefaultPreferences.getPreferences().getBoolean(key, defaultValue);
    }

    private static void putString(String key, String value) {
        DefaultPreferences.getPreferences().put(key, value);
    }

    public static String getToolchainName() {
        String value = DefaultPreferences.getString("toolchain.name", null);
        if (value != null && !value.isEmpty()) {
            return value;
        }
        value = "";
        try {
            Properties prop = DefaultPreferences.getToolchainProperties();
            value = prop.getProperty(DEFAULT_NAME, "").trim();
        }
        catch (IOException iOException) {}
        return value;
    }

    public static void putToolchainName(String name) {
        String key = "toolchain.name";
        System.out.println("Default " + key + "=" + name);
        DefaultPreferences.putString(key, name);
    }

    public static String getToolchainPath(String toolchainName) {
        String value = DefaultPreferences.getString(PersistentPreferences.getToolchainKey(toolchainName), null);
        if (value != null && !value.isEmpty()) {
            return value;
        }
        value = "";
        try {
            Properties prop = DefaultPreferences.getToolchainProperties();
            int hash = Math.abs(toolchainName.trim().hashCode());
            value = prop.getProperty("default.path." + String.valueOf(hash), "").trim();
        }
        catch (IOException iOException) {}
        return value;
    }

    public static void putToolchainPath(String toolchainName, String value) {
        String key = PersistentPreferences.getToolchainKey(toolchainName);
        System.out.println("Default " + key + "=" + value);
        DefaultPreferences.putString(key, value);
    }

    public static String getToolchainSearchPath(String toolchainName) {
        String value = DefaultPreferences.getString(PersistentPreferences.getToolchainSearchKey(toolchainName), "");
        return value;
    }

    public static void putToolchainSearchPath(String toolchainName, String value) {
        String key = PersistentPreferences.getToolchainSearchKey(toolchainName);
        System.out.println("Default " + key + "=" + value);
        DefaultPreferences.putString(key, value);
    }

    public static String getToolchainSearchPathOs(String toolchainName) {
        String value = DefaultPreferences.getString(PersistentPreferences.getToolchainSearchOsKey(toolchainName), "");
        return value;
    }

    public static String getBuildToolsPath() {
        return DefaultPreferences.getString("buildTools.path", "");
    }

    public static void putBuildToolsPath(String value) {
        String key = "buildTools.path";
        System.out.println("Default " + key + "=" + value);
        DefaultPreferences.putString(key, value);
    }

    public static String discoverBuildToolsPath() {
        WindowsRegistry registry;
        String value = null;
        if (OSFamily.WINDOWS.isCurrent() && (registry = WindowsRegistry.getRegistry()) != null) {
            value = registry.getLocalMachineValue(REG_SUBKEY, REG_NAME);
            if (value == null) {
                value = registry.getLocalMachineValue(REG32_SUBKEY, REG_NAME);
            }
            if (value != null && !value.endsWith("\\bin")) {
                value = String.valueOf(value) + "\\bin";
            }
        }
        if (value != null) {
            File file = new File(value = value.trim());
            if (!file.isDirectory()) {
                value = "";
            }
        } else {
            value = "";
        }
        System.out.println("DefaultPreferences.discoverBuildToolsPath()=\"" + value + "\"");
        return value;
    }

    private static String getLastToolchain(String folder, final String executableName) {
        ArrayList<String> list = new ArrayList<String>();
        File local = new File(folder);
        if (!local.isDirectory()) {
            return null;
        }
        File[] files = local.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                IPath path = new Path(dir.getAbsolutePath()).append(name).append("bin").append(executableName);
                return path.toFile().isFile();
            }
        });
        if (files == null || files.length == 0) {
            return null;
        }
        int i = 0;
        while (i < files.length) {
            list.add(files[i].getName());
            ++i;
        }
        Collections.sort(list);
        String last = (String)list.get(list.size() - 1);
        IPath path = new Path(folder).append(last).append("bin");
        return path.toString();
    }

    public static String discoverToolchainPath(String toolchainName, String searchPath) {
        int ix;
        if (searchPath == null || searchPath.isEmpty()) {
            return null;
        }
        String resolvedPath = searchPath;
        if (resolvedPath.indexOf("${user.home}") >= 0) {
            resolvedPath = resolvedPath.replaceAll("\\$\\{user.home\\}", System.getProperty("user.home"));
        }
        if (resolvedPath.indexOf("${") >= 0) {
            IStringVariableManager variableManager = VariablesPlugin.getDefault().getStringVariableManager();
            try {
                resolvedPath = variableManager.performStringSubstitution(resolvedPath, false);
            }
            catch (CoreException coreException) {
                resolvedPath = null;
            }
        }
        if (resolvedPath == null || resolvedPath.isEmpty()) {
            return null;
        }
        String[] paths = resolvedPath.split(PreferencesUtils.getPathSeparator());
        if (paths.length == 0) {
            return null;
        }
        try {
            ix = ToolchainDefinition.findToolchainByName(toolchainName);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            ix = ToolchainDefinition.getDefault();
        }
        String executableName = ToolchainDefinition.getToolchain(ix).getFullCmdC();
        if (OSFamily.WINDOWS.isCurrent()) {
            executableName = String.valueOf(executableName) + ".exe";
        }
        int i = 0;
        while (i < paths.length) {
            String value = DefaultPreferences.getLastToolchain(paths[i], executableName);
            if (value != null && !value.isEmpty()) {
                return value;
            }
            ++i;
        }
        return null;
    }

    private static Properties getToolchainProperties() throws IOException {
        if (fgToolchainProperties == null) {
            URL url = Platform.getInstallLocation().getURL();
            Path path = new Path(url.getPath());
            File file = path.append("configuration").append("com.nxp.s32ds.ext.cdt.core").append(TOOLCHAIN).toFile();
            FileInputStream is = new FileInputStream(file);
            Properties prop = new Properties();
            prop.load(is);
            fgToolchainProperties = prop;
        }
        return fgToolchainProperties;
    }
}

