/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.license.cli.cmd;

import com.nxp.s32ds.ext.rcp.license.cli.ISettings;
import com.nxp.s32ds.ext.rcp.license.cli.cmd.AbstractCommand;
import com.nxp.s32ds.ext.rcp.license.cli.cmd.UIUtils;
import com.nxp.s32ds.ext.rcp.license.cll.CLLActivationType;
import com.nxp.s32ds.ext.rcp.license.cll.CLLFeatureDetail;
import com.nxp.s32ds.ext.rcp.license.cll.CLLReason;
import com.nxp.s32ds.ext.rcp.license.cll.ICLL;
import java.io.File;
import javax.swing.JOptionPane;

public class ReturnFeature
extends AbstractCommand {
    private static final String PARAM_FEATURE_NAME = "feature";
    private static final String PARAM_FEATURE_VERSION = "version";
    private static final String PARAM_PROD = "prod";
    private static final String PARAM_REQ = "req";
    public static final String PARAM_UI = "uiOnError";

    public ReturnFeature(ISettings settings, ICLL cll) {
        super(cll, settings);
        this.getParams().put(PARAM_PROD, "Product name");
        this.getParams().put(PARAM_FEATURE_NAME, "Feature name");
        this.getParams().put(PARAM_FEATURE_VERSION, "Feature version");
        this.getParams().put(PARAM_REQ, "Specify output xml file name for offline strategy");
        this.getParams().put(PARAM_UI, "Use graphic UI if error on online strategy (set to \"false\" to disable)");
    }

    @Override
    public String getName() {
        return "freturn";
    }

    @Override
    public String getOneLineDesc() {
        return "Return license. If req is set, use offline strategy.";
    }

    @Override
    public boolean canExecute() {
        return this.getProblemDescription() == null;
    }

    @Override
    public String getProblemDescription() {
        String rootProblems = super.getProblemDescription();
        if (rootProblems != null) {
            return rootProblems;
        }
        String[] stringArray = new String[]{PARAM_FEATURE_NAME, PARAM_FEATURE_VERSION, PARAM_PROD};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            if (this.getSettings().getParam(key) == null) {
                return String.format("-%s is not set", key);
            }
            ++n2;
        }
        return null;
    }

    @Override
    public int execute() {
        CLLReason result;
        String actID;
        block9: {
            String requestXml;
            block8: {
                try {
                    super.initLicenseLocation();
                    super.setupProxy();
                    if (this.isTestFNO()) {
                        if (this.getSettings().isDebugModeOn()) {
                            System.out.println("use test FNO");
                        }
                        this.getCll().setFNOUrlForTesting(true);
                    }
                    requestXml = this.getSettings().getParam(PARAM_REQ);
                    actID = this.findActId();
                    if (actID != null) break block8;
                    System.err.println(String.format("Feature %s %s in product %s is missing.", this.getSettings().getParam(PARAM_FEATURE_NAME), this.getSettings().getParam(PARAM_FEATURE_VERSION), this.getSettings().getParam(PARAM_PROD)));
                    return 1;
                }
                catch (Exception e) {
                    System.err.println(e.getMessage());
                    return 1;
                }
            }
            if (this.getActivationType() == CLLActivationType.CLL_ACTIVATION_TYPE_OFFLINE_FNO) {
                return this.generateXmlRequest(requestXml, actID);
            }
            result = this.getCll().returnLicense(actID, false, null);
            if (result != null) break block9;
            return 0;
        }
        if (!"false".equals(this.getSettings().getParam(PARAM_UI))) {
            return this.runOfflineUIScenario(result.getErrorString(), actID);
        }
        System.err.println(result);
        return 1;
    }

    private int runOfflineUIScenario(String error, String actId) {
        if (!UIUtils.showConfirmDialog("Deactivation error", "Online license deactivation failed:\n" + error + "\n\nDo you want to run offline deactivation?")) {
            System.out.println("Exit by user request (refuse to deactivate in offline mode)");
            return 1;
        }
        return this.deactivateOffline(actId);
    }

    private int deactivateOffline(String actID) {
        File request = null;
        do {
            if ((request = UIUtils.chooseFile("Dectivation request", "Save", new File("deactivate.xml"))) != null) continue;
            System.out.println("Exit by user request (no file selected)");
            return 1;
        } while (request.exists() && JOptionPane.showConfirmDialog(null, "File already exists, are you sure you want to overwrite it?", "Warning", 0) != 0);
        String reqFileName = request.getAbsolutePath();
        CLLReason requestResult = this.getCll().returnLicense(actID, true, reqFileName);
        if (requestResult != null) {
            UIUtils.showMessageDialog("Error", requestResult.getErrorString());
            System.err.println(requestResult);
            return 1;
        }
        String message = "Request file saved to:\n" + reqFileName;
        UIUtils.showMessageDialog("Offline request generated", message);
        System.out.println(message);
        return 0;
    }

    private String findActId() {
        CLLReason ppReason = new CLLReason();
        CLLFeatureDetail feature = this.getCll().listFeatures(this.getSettings().getParam(PARAM_PROD), this.getSettings().getParam(PARAM_FEATURE_NAME), this.getSettings().getParam(PARAM_FEATURE_VERSION), ppReason);
        if (feature != null) {
            return feature.getActivationID();
        }
        return null;
    }

    private int generateXmlRequest(String requestXml, String actID) {
        String reqFileName = new File(requestXml).getAbsolutePath();
        CLLReason result = this.getCll().returnLicense(actID, true, reqFileName);
        if (result == null) {
            return 0;
        }
        System.err.println(result);
        return 1;
    }

    private CLLActivationType getActivationType() {
        if (this.getSettings().getParam(PARAM_REQ) != null) {
            return CLLActivationType.CLL_ACTIVATION_TYPE_OFFLINE_FNO;
        }
        return CLLActivationType.CLL_ACTIVATION_TYPE_FNO;
    }
}

