/*
 * Decompiled with CFR 0.152.
 */
package com.pemicro.forms;

import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class InputQuery
implements Runnable {
    private Text inputText;
    private Button okButton;
    private Button cancelButton;
    private Label captionLabel;
    private Shell shell;
    private Shell parentShell;
    private String input;
    private boolean newInputSelected = false;
    private String header;
    private String caption;
    private String value;

    public void run() {
        Display disp = PlatformUI.getWorkbench().getDisplay();
        this.newInputSelected = false;
        this.input = "";
        this.parentShell = PlatformUI.getWorkbench().getDisplay().getShells()[0];
        this.shell = new Shell(this.parentShell, 67680);
        this.createContents(this.header, this.caption, this.value);
        this.shell.open();
        this.shell.layout();
        this.shell.setActive();
        while (!this.shell.isDisposed()) {
            if (disp.readAndDispatch()) continue;
            disp.sleep();
        }
    }

    public void close() {
        if (!this.shell.isDisposed()) {
            this.shell.dispose();
        }
    }

    protected void createContents(String header, String caption, String value) {
        Rectangle bounds = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getBounds();
        this.shell.setImage(PlatformUI.getWorkbench().getDisplay().getShells()[0].getImage());
        this.captionLabel = new Label((Composite)this.shell, 64);
        this.inputText = new Text((Composite)this.shell, 2048);
        this.okButton = new Button((Composite)this.shell, 0);
        this.cancelButton = new Button((Composite)this.shell, 0);
        final String orignalValue = value;
        int shellWidth = 222;
        int shellHeight = 135;
        int shellX = bounds.x + (bounds.width - shellWidth) / 2;
        int shellY = bounds.y + (bounds.height - shellHeight) / 2;
        int captionLabelX = 10;
        int captionLabelY = 10;
        int captionLabelWidth = shellWidth - 10;
        int captionLabelHeight = 15 * (int)Math.ceil((double)caption.length() / Math.ceil((float)shellWidth / 8.0f));
        int inputTextX = 10;
        int inputTextY = captionLabelY + captionLabelHeight + 10;
        int inputTextWidth = shellWidth - 20;
        int inputTextHeight = 25;
        int buttonX = 10;
        int buttonY = inputTextY + inputTextHeight + 10;
        int buttonWidth = 90;
        int buttonHeight = 25;
        int buttonNumber = 1;
        if (shellHeight < 40 + captionLabelHeight + inputTextHeight + buttonHeight + 25) {
            shellHeight = 40 + captionLabelHeight + inputTextHeight + buttonHeight + 30;
        }
        this.shell.setBounds(shellX, shellY, shellWidth, shellHeight);
        this.shell.setText(header);
        this.captionLabel.setBounds(captionLabelX, captionLabelY, captionLabelWidth, captionLabelHeight);
        this.captionLabel.setText(caption);
        this.inputText.setBounds(inputTextX, inputTextY, inputTextWidth, inputTextHeight);
        this.inputText.setText(value);
        this.inputText.setFocus();
        this.inputText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 27) {
                    InputQuery.this.setInput(orignalValue);
                    InputQuery.this.setNewInputSelected(false);
                    InputQuery.this.close();
                }
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    InputQuery.this.setInput(InputQuery.this.inputText.getText());
                    InputQuery.this.setNewInputSelected(true);
                    InputQuery.this.close();
                }
            }
        });
        this.okButton.setBounds(buttonNumber * buttonX + (buttonNumber - 1) * buttonWidth, buttonY, buttonWidth, buttonHeight);
        this.cancelButton.setBounds(++buttonNumber * buttonX + (buttonNumber - 1) * buttonWidth, buttonY, buttonWidth, buttonHeight);
        ++buttonNumber;
        this.okButton.setText("OK");
        this.okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputQuery.this.setInput(InputQuery.this.inputText.getText());
                InputQuery.this.setNewInputSelected(true);
                InputQuery.this.close();
            }
        });
        this.okButton.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 27) {
                    InputQuery.this.setInput(orignalValue);
                    InputQuery.this.setNewInputSelected(false);
                    InputQuery.this.close();
                }
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    InputQuery.this.setInput(InputQuery.this.inputText.getText());
                    InputQuery.this.setNewInputSelected(true);
                    InputQuery.this.close();
                }
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputQuery.this.setInput(orignalValue);
                InputQuery.this.setNewInputSelected(false);
                InputQuery.this.close();
            }
        });
        this.cancelButton.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 27) {
                    InputQuery.this.setInput(orignalValue);
                    InputQuery.this.setNewInputSelected(false);
                    InputQuery.this.close();
                }
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    InputQuery.this.setInput(InputQuery.this.inputText.getText());
                    InputQuery.this.setNewInputSelected(true);
                    InputQuery.this.close();
                }
            }
        });
    }

    public void setItems(String header, String caption, String value) {
        this.header = header;
        this.caption = caption;
        this.value = value;
    }

    public String getInput() {
        return this.input;
    }

    public void setInput(String input) {
        this.input = input;
    }

    public boolean isNewInputSelected() {
        return this.newInputSelected;
    }

    public void setNewInputSelected(boolean newInputSelected) {
        this.newInputSelected = newInputSelected;
    }
}

