/*
 * Decompiled with CFR 0.152.
 */
package com.pemicro.forms.chip;

import com.pemicro.debugView.debugView;
import com.pemicro.forms.chip.ChipWindow;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.part.ViewPart;

public class ChipView
extends ViewPart {
    public static final String ID = "com.pemicro.core.chipView";
    final Color BACKGROUND_COLOR = new Color((Device)ChipWindow.display, 40, 69, 61);
    final Color TEXT_COLOR = new Color((Device)ChipWindow.display, 220, 220, 220);
    private static ScrolledForm form = null;
    private static Shell shell = null;
    static Label statusText;
    private FormToolkit toolkit;
    private static boolean chipWindowEnabled;
    private static boolean chipViewVisible;

    static {
        chipWindowEnabled = true;
        chipViewVisible = false;
    }

    public void createPartControl(Composite parent) {
        debugView.print("creating chip view");
        this.toolkit = new FormToolkit(parent.getDisplay());
        ChipView.setForm(this.toolkit.createScrolledForm(parent));
        ChipView.setShell(parent.getShell());
        form.setBackground(this.BACKGROUND_COLOR);
        statusText = new Label(form.getBody(), 64);
        statusText.setFont(new Font((Device)ChipWindow.display, "Calibri", 14, 0));
        statusText.setText("");
        statusText.setSize(0, 0);
        statusText.setForeground(this.TEXT_COLOR);
        statusText.setBackground(this.BACKGROUND_COLOR);
        form.getBody().setBackground(this.BACKGROUND_COLOR);
        if (!chipWindowEnabled) {
            statusText.setText("Please start/restart your simulation or P&&E in-circuit debug session with the Chip Window view visible in order to display the microcontroller. In simulation, a virtual microcontroller will be displayed. During an in-circuit debug session, the state of the pins will be read and displayed continuously from the target microcontroller.");
            statusText.setSize(statusText.computeSize(400, -1));
        }
        ChipView.setChipViewVisible(true);
    }

    public void setFocus() {
        form.setFocus();
    }

    public void dispose() {
        this.toolkit.dispose();
        ChipView.setForm(null);
        ChipView.setShell(null);
        ChipView.setChipViewVisible(false);
        super.dispose();
    }

    public static boolean isChipViewVisible() {
        return chipViewVisible;
    }

    private static void setChipViewVisible(boolean chipViewVisible) {
        ChipView.chipViewVisible = chipViewVisible;
    }

    public static void setChipWindowEnabled(boolean chipWindowEnabled) {
        ChipView.chipWindowEnabled = chipWindowEnabled;
    }

    public static void setStatusText(String text) {
        statusText.setText(text);
        statusText.pack();
    }

    public static ScrolledForm getForm() {
        return form;
    }

    private static void setForm(ScrolledForm newForm) {
        form = newForm;
    }

    public static Shell getShell() {
        return shell;
    }

    private static void setShell(Shell newShell) {
        shell = newShell;
    }
}

