/*
 * Decompiled with CFR 0.152.
 */
package com.pemicro.forms.chip;

import com.pemicro.forms.chip.ChipCommand;
import com.pemicro.forms.chip.ChipResponse;
import com.pemicro.forms.chip.ChipStyle;
import com.pemicro.forms.chip.ChipView;
import com.pemicro.forms.chip.SignalWindow;
import com.pemicro.forms.chip.data.ChipData;
import com.pemicro.forms.chip.widget.Chip;
import com.pemicro.forms.chip.widget.ControlWindow;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class ChipWindow
implements Runnable {
    public static Semaphore semaphore = new Semaphore(1, true);
    Chip chip;
    SignalWindow signalWindow;
    private ControlWindow controlWindow;
    private ConcurrentLinkedQueue<ChipCommand> chipCommandQueue = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<ChipData> chipDataQueue = new ConcurrentLinkedQueue();
    private boolean threadRunning = false;
    private ScrolledForm form;
    static final Display display = Display.getDefault();

    public void offerChipQueue(ChipCommand cwCmd, ChipData cwData) {
        this.chipCommandQueue.offer(cwCmd);
        this.chipDataQueue.offer(cwData);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        this.threadRunning = true;
        try {
            while (this.chipCommandQueue.size() != 0) {
                block32: {
                    try {
                        try {
                            semaphore.acquire();
                            ChipCommand chipCommand = (ChipCommand)this.chipCommandQueue.remove();
                            ChipData chipData = (ChipData)this.chipDataQueue.remove();
                            semaphore.release();
                            block3 : switch (chipCommand.getCommand()) {
                                case 1: {
                                    this.clear();
                                    break;
                                }
                                case 2: {
                                    int pinNum;
                                    this.createChipContents(chipData);
                                    int pinIdx = 0;
                                    while (pinIdx < chipCommand.getPinCommands().length) {
                                        pinNum = chipData.getPinData()[pinIdx].getNumber() - 1;
                                        this.chip.getPin(pinNum).setPinData(chipData.getPinData()[pinIdx]);
                                        this.chip.getPin(pinNum).updateDirection();
                                        this.chip.getPin(pinNum).updateValue();
                                        this.chip.getPin(pinNum).updateName();
                                        ++pinIdx;
                                    }
                                    break;
                                }
                                case 3: 
                                case 6: 
                                case 7: 
                                case 8: 
                                case 9: {
                                    int pinNum;
                                    int pinIdx = 0;
                                    while (true) {
                                        if (pinIdx >= chipCommand.getPinCommands().length) {
                                            if (chipCommand.getCommand() == 8) {
                                                this.controlWindow.show();
                                            }
                                            if (chipCommand.getCommand() == 9) {
                                                this.controlWindow.hide();
                                            }
                                            this.controlWindow.setLocation(ChipStyle.centerX((Control)this.controlWindow.getCanvas(), (Control)this.chip.getCanvas()), ChipStyle.getYOffset((Control)this.controlWindow.getCanvas(), (Control)this.chip.getCanvas(), 0));
                                            break block3;
                                        }
                                        pinNum = chipData.getPinData()[pinIdx].getNumber() - 1;
                                        this.chip.getPin(pinNum).setPinData(chipData.getPinData()[pinIdx]);
                                        this.controlWindow.setDigitalValue(chipData.getPinData()[pinIdx].getDigitalValue());
                                        this.controlWindow.setDirection(chipData.getPinData()[pinIdx].getDirection());
                                        switch (chipCommand.getPinCommands()[pinIdx]) {
                                            case 0: {
                                                this.chip.getPin(pinNum).updateDirection();
                                                this.chip.getPin(pinNum).updateValue();
                                                this.chip.getPin(pinNum).updateName();
                                                break;
                                            }
                                            case 1: {
                                                this.chip.getPin(pinNum).updateDirection();
                                                break;
                                            }
                                            case 2: {
                                                this.chip.getPin(pinNum).updateValue();
                                                break;
                                            }
                                            case 3: {
                                                break;
                                            }
                                            case 4: {
                                                this.chip.getPin(pinNum).updateName();
                                                break;
                                            }
                                        }
                                        ++pinIdx;
                                    }
                                }
                                case 4: {
                                    break;
                                }
                                case 5: {
                                    int pinNum;
                                    this.createChipContents(chipData);
                                    int pinIdx = 0;
                                    while (true) {
                                        if (pinIdx >= chipCommand.getPinCommands().length) {
                                            this.controlWindow.setLocation(ChipStyle.centerX((Control)this.controlWindow.getCanvas(), (Control)this.chip.getCanvas()), ChipStyle.getYOffset((Control)this.controlWindow.getCanvas(), (Control)this.chip.getCanvas(), 0));
                                            break block3;
                                        }
                                        pinNum = chipData.getPinData()[pinIdx].getNumber() - 1;
                                        this.chip.getPin(pinNum).setPinData(chipData.getPinData()[pinNum]);
                                        this.chip.getPin(pinNum).updateValue();
                                        this.chip.getPin(pinNum).updateDirection();
                                        this.chip.getPin(pinNum).updateName();
                                        ++pinIdx;
                                    }
                                }
                            }
                            if (this.chip == null || this.chip.isDisposed()) break block32;
                            if (!this.chip.getInfo1().equals(chipData.getDeviceName())) {
                                this.chip.setDeviceName(chipData.getDeviceName());
                            }
                            if (!this.chip.getInfo2().equals(chipData.getFreq())) {
                                this.chip.setFreq(chipData.getFreq());
                            }
                            if (chipData.getChipType() == 1 && !this.chip.getInfo3().equals(chipData.getCycles())) {
                                this.chip.setCycles(chipData.getCycles());
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            if (semaphore.availablePermits() != 0) continue;
                            semaphore.release();
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        if (semaphore.availablePermits() == 0) {
                            semaphore.release();
                        }
                        throw throwable;
                    }
                }
                if (semaphore.availablePermits() != 0) continue;
                semaphore.release();
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        this.threadRunning = false;
    }

    public void close() {
        this.chip.setOpened(false);
    }

    protected void createChipContents(ChipData chipData) {
        this.clear();
        this.createChip(chipData);
        this.createControl(chipData);
        this.chip.setOpened(true);
    }

    protected void createChip(ChipData chipData) {
        this.chip = new Chip(this.form.getBody(), chipData);
        this.chip.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (ChipWindow.this.controlWindow.getPinSelection() != Integer.MAX_VALUE) {
                    ChipWindow.this.deselect(ChipWindow.this.controlWindow.getPinSelection());
                }
            }
        });
        int i = 0;
        while (i < chipData.getNumOfPins()) {
            final int pinIdx = i++;
            this.chip.getPin(pinIdx).getName().addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDoubleClick(MouseEvent event) {
                    ChipResponse.processDoubleClick(ChipWindow.this.chip.getPin(pinIdx).getPinData(), 0);
                }

                public void mouseDown(MouseEvent event) {
                    if (ChipWindow.this.chip.getPin(pinIdx).getPinData().isControllable()) {
                        ChipWindow.this.processSingleClick(pinIdx);
                    } else if (ChipWindow.this.controlWindow.getPinSelection() != Integer.MAX_VALUE) {
                        ChipWindow.this.deselect(ChipWindow.this.controlWindow.getPinSelection());
                    }
                }
            });
            this.chip.getPin(pinIdx).getDirection().addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDoubleClick(MouseEvent event) {
                    ChipResponse.processDoubleClick(ChipWindow.this.chip.getPin(pinIdx).getPinData(), 1);
                }

                public void mouseDown(MouseEvent event) {
                    if (ChipWindow.this.chip.getPin(pinIdx).getPinData().isControllable()) {
                        ChipWindow.this.processSingleClick(pinIdx);
                    } else if (ChipWindow.this.controlWindow.getPinSelection() != Integer.MAX_VALUE) {
                        ChipWindow.this.deselect(ChipWindow.this.controlWindow.getPinSelection());
                    }
                }
            });
            this.chip.getPin(pinIdx).getValue().addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDoubleClick(MouseEvent event) {
                    ChipResponse.processDoubleClick(ChipWindow.this.chip.getPin(pinIdx).getPinData(), 2);
                }

                public void mouseDown(MouseEvent event) {
                    if (ChipWindow.this.chip.getPin(pinIdx).getPinData().isControllable()) {
                        ChipWindow.this.processSingleClick(pinIdx);
                    } else if (ChipWindow.this.controlWindow.getPinSelection() != Integer.MAX_VALUE) {
                        ChipWindow.this.deselect(ChipWindow.this.controlWindow.getPinSelection());
                    }
                }
            });
        }
    }

    protected void createControl(ChipData chipData) {
        this.controlWindow = new ControlWindow(this.form.getBody(), chipData);
        int i = 1;
        while (i <= chipData.getNumOfPins()) {
            if (this.chip.getPin(i - 1).getPinData().isControllable()) {
                this.controlWindow.getPinNumCombo().add(Integer.toString(i));
            }
            ++i;
        }
        this.controlWindow.getPinNumCombo().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                if (ChipWindow.this.controlWindow.getPinNumber() != Integer.valueOf(ChipWindow.this.controlWindow.getPinNumCombo().getText()).intValue()) {
                    int pinNumber = Integer.valueOf(ChipWindow.this.controlWindow.getPinNumCombo().getText());
                    ChipWindow.this.controlWindow.setPinNumber(pinNumber);
                    ChipResponse.setPinNumber(Integer.valueOf(ChipWindow.this.controlWindow.getPinNumCombo().getText()));
                    int pinIdx = pinNumber - 1;
                    ChipWindow.this.deselect(ChipWindow.this.controlWindow.getPinSelection());
                    ChipWindow.this.select(pinIdx);
                }
            }
        });
        this.controlWindow.getDataTypeCombo().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                if (ChipWindow.this.controlWindow.getDataType() != ChipWindow.this.controlWindow.getDataTypeCombo().getSelectionIndex()) {
                    int dataType = ChipWindow.this.controlWindow.getDataTypeCombo().getSelectionIndex();
                    ChipWindow.this.controlWindow.setDataType(dataType);
                    ChipResponse.setControlChanged(true);
                    ChipResponse.setDataType(ChipWindow.this.controlWindow.getDataTypeCombo().getSelectionIndex());
                }
                ChipWindow.this.controlWindow.setAnalogCurrentValue(ChipWindow.this.chip.getPin(ChipWindow.this.controlWindow.getPinSelection()).getPinData().getAnalogValue());
            }
        });
        this.controlWindow.getPinValueHighButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                ChipResponse.setPinValueChanged(true);
                ChipResponse.setControlChanged(true);
                ChipResponse.setDigitalValue(1);
                ChipWindow.this.controlWindow.setDigitalValue(1);
            }
        });
        this.controlWindow.getPinValueLowButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                ChipResponse.setPinValueChanged(true);
                ChipResponse.setControlChanged(true);
                ChipResponse.setDigitalValue(0);
                ChipWindow.this.controlWindow.setDigitalValue(0);
            }
        });
        this.controlWindow.getPinDirectionInButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                ChipWindow.this.controlWindow.setDirection(0);
                ChipResponse.setControlChanged(true);
                ChipResponse.setPinDirection(0);
                ChipResponse.setPinDirectionChanged(true);
            }
        });
        this.controlWindow.getPinDirectionOutButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                ChipResponse.setControlChanged(true);
                ChipResponse.setPinDirection(16);
                ChipResponse.setPinDirectionChanged(true);
                ChipWindow.this.controlWindow.setDirection(16);
            }
        });
        this.controlWindow.getAnalogValueScale().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                ChipWindow.this.controlWindow.setAnalogCurrentValue(ChipWindow.this.controlWindow.getAnalogValueScale().getSelection());
                ChipWindow.this.controlWindow.setAnalogMaxValue(ChipWindow.this.controlWindow.getAnalogValueScale().getMaximum());
                ChipWindow.this.controlWindow.setAnalogMaxValue(ChipWindow.this.controlWindow.getAnalogValueScale().getMinimum());
                ChipWindow.this.controlWindow.getAnalogCurrentValueLabel().setText(String.format("%.2f V", Float.valueOf((float)ChipWindow.this.controlWindow.getAnalogValueScale().getSelection() / 100.0f)));
                ChipWindow.this.controlWindow.getAnalogCurrentValueLabel().pack();
                ChipResponse.setControlChanged(true);
                ChipResponse.setPinValueChanged(true);
                ChipResponse.setAnalogValue(ChipWindow.this.controlWindow.getAnalogValueScale().getSelection());
                ChipResponse.setAnalogMax(ChipWindow.this.controlWindow.getAnalogValueScale().getMaximum());
                ChipResponse.setAnalogMin(ChipWindow.this.controlWindow.getAnalogValueScale().getMinimum());
            }
        });
        this.controlWindow.setLocation(ChipStyle.centerX((Control)this.controlWindow.getCanvas(), (Control)this.chip.getCanvas()), ChipStyle.getYOffset((Control)this.controlWindow.getCanvas(), (Control)this.chip.getCanvas(), 0));
    }

    private void deselect(int idx) {
        this.controlWindow.setPinSelection(Integer.MAX_VALUE);
        this.controlWindow.hide();
        this.chip.getPin(idx).getDirection().setBackground(ChipStyle.BACKGROUND_COLOR);
    }

    private void select(int idx) {
        this.controlWindow.setPinSelection(idx);
        this.controlWindow.show();
        this.chip.getPin(idx).getDirection().setBackground(ChipStyle.CHIP_WINDOW_PIN_SELECTION_COLOR);
        this.controlWindow.setPinNumber(idx + 1);
        ChipResponse.setPinNumber(idx + 1);
        this.controlWindow.setPinID(this.chip.getPin(idx).getPinData().getID());
        ChipResponse.setPinID(this.chip.getPin(idx).getPinData().getID());
        this.controlWindow.setFocus();
        this.controlWindow.setPinName(this.chip.getPin(idx).getPinData().getModuleName());
        ChipResponse.setModuleName(this.chip.getPin(idx).getPinData().getModuleName());
        this.controlWindow.setDataType(this.chip.getPin(idx).getPinData().getDataType());
        ChipResponse.setDataType(this.chip.getPin(idx).getPinData().getDataType());
        this.controlWindow.setDigitalValue(this.chip.getPin(idx).getPinData().getDigitalValue());
        this.controlWindow.setDirection(this.chip.getPin(idx).getPinData().getDirection());
        this.controlWindow.setAnalogMinValue(this.chip.getPin(idx).getPinData().getAnalogMin());
        this.controlWindow.setAnalogMaxValue(this.chip.getPin(idx).getPinData().getAnalogMax());
        this.controlWindow.setAnalogCurrentValue(this.chip.getPin(idx).getPinData().getAnalogValue());
    }

    private void clear() {
        ChipView.setStatusText("");
        if (this.chip != null) {
            this.chip.dispose();
        }
        if (this.controlWindow != null) {
            this.controlWindow.dispose();
        }
    }

    private void processSingleClick(int pinIdx) {
        if (this.controlWindow.getPinSelection() != Integer.MAX_VALUE) {
            this.deselect(this.controlWindow.getPinSelection());
        }
        this.select(pinIdx);
    }

    public ScrolledForm getForm() {
        return this.form;
    }

    public void setForm(ScrolledForm form) {
        this.form = form;
    }

    public boolean threadIsRunning() {
        return this.threadRunning;
    }

    public Chip getChip() {
        return this.chip;
    }
}

