/*
 * Decompiled with CFR 0.152.
 */
package com.pemicro.forms.chip;

import com.pemicro.forms.chip.ChipCommand;
import com.pemicro.forms.chip.Signal;
import com.pemicro.forms.chip.SignalView;
import com.pemicro.forms.chip.data.ChipData;
import com.pemicro.forms.chip.data.PinData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignalWindow
implements Runnable {
    private boolean threadRunning = false;
    private ConcurrentLinkedQueue<ChipCommand> chipCommandQueue = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<ChipData> chipDataQueue = new ConcurrentLinkedQueue();
    public static Semaphore semaphore = new Semaphore(1, true);
    public static Semaphore controlSemaphore = new Semaphore(1, true);
    private ChipData chipDatabase = new ChipData();
    private Map<Integer, Signal> signalList = new HashMap<Integer, Signal>();
    private Map<Integer, Signal> displayedSignalList = new HashMap<Integer, Signal>();
    private static SignalWindow content;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        this.threadRunning = true;
        try {
            while (this.chipCommandQueue.size() != 0) {
                try {
                    try {
                        semaphore.acquire();
                        ChipCommand command = (ChipCommand)this.chipCommandQueue.remove();
                        ChipData chipData = (ChipData)this.chipDataQueue.remove();
                        if (command.getNumOfPinsToRedraw() == chipData.getNumOfPins()) {
                            this.chipDatabase = chipData;
                        }
                        semaphore.release();
                        switch (command.getCommand()) {
                            case 1: {
                                this.clear();
                                break;
                            }
                            case 2: {
                                PinData pdata;
                                int number;
                                this.clear();
                                this.chipDatabase = chipData;
                                int pinIdx = 0;
                                while (pinIdx < command.getPinCommands().length) {
                                    number = chipData.getPinData()[pinIdx].getNumber();
                                    this.chipDatabase.setPinData(number, chipData.getPinData(number));
                                    pdata = chipData.getPinData()[pinIdx];
                                    this.addSignal(new Signal(pdata));
                                    ++pinIdx;
                                }
                                break;
                            }
                            case 3: 
                            case 6: 
                            case 7: 
                            case 8: 
                            case 9: {
                                int number;
                                int pinIdx = 0;
                                while (pinIdx < command.getPinCommands().length) {
                                    number = chipData.getPinData()[pinIdx].getNumber();
                                    chipData.getPinData(number).setDisplayed(this.chipDatabase.getPinData(number).isDisplayed());
                                    this.chipDatabase.setPinData(number, chipData.getPinData(number));
                                    this.updateSignal(chipData.getPinData(number));
                                    ++pinIdx;
                                }
                                break;
                            }
                            case 5: {
                                PinData pdata;
                                int number;
                                int pinIdx = 0;
                                while (pinIdx < command.getPinCommands().length) {
                                    number = chipData.getPinData()[pinIdx].getNumber();
                                    this.chipDatabase.setPinData(number, chipData.getPinData(number));
                                    pdata = chipData.getPinData()[pinIdx];
                                    this.addSignal(new Signal(pdata));
                                    ++pinIdx;
                                }
                                break;
                            }
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        if (semaphore.availablePermits() != 0) continue;
                        semaphore.release();
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    if (semaphore.availablePermits() == 0) {
                        semaphore.release();
                    }
                    throw throwable;
                }
                if (semaphore.availablePermits() != 0) continue;
                semaphore.release();
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        this.threadRunning = false;
    }

    public void clear() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        this.signalList.clear();
        this.displayedSignalList.clear();
        IWorkbenchPage page = window.getActivePage();
        SignalView view = (SignalView)page.findView("com.pemicro.core.signalView");
        view.getViewer().refresh();
    }

    public Signal getSignal(int id) {
        return this.signalList.get(id);
    }

    public Signal getSignal(String pinName, String signalName) {
        Signal signal2 = null;
        for (Signal signal2 : this.signalList.values()) {
            if (!signal2.getSignalName().equals(signalName) || !signal2.getPinName().equals(pinName)) continue;
            return signal2;
        }
        return signal2;
    }

    public void addSignal(Signal signal) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        this.signalList.put(signal.getPinData().getID(), signal);
        if (signal.getPinData().isDisplayed()) {
            this.displayedSignalList.put(signal.getPinData().getID(), signal);
        } else {
            this.displayedSignalList.remove(signal.getPinData().getID());
        }
        IWorkbenchPage page = window.getActivePage();
        SignalView view = (SignalView)page.findView("com.pemicro.core.signalView");
        view.getViewer().refresh();
    }

    public void updateSignal(PinData pdata) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        this.signalList.get(pdata.getID()).setPinData(pdata);
        if (pdata.isDisplayed()) {
            this.displayedSignalList.put(pdata.getID(), this.signalList.get(pdata.getID()));
        } else {
            this.displayedSignalList.remove(pdata.getID());
        }
        IWorkbenchPage page = window.getActivePage();
        SignalView view = (SignalView)page.findView("com.pemicro.core.signalView");
        view.getViewer().refresh();
    }

    public void offerChipQueue(ChipCommand cwCmd, ChipData cwData) {
        this.chipCommandQueue.offer(cwCmd);
        this.chipDataQueue.offer(cwData);
    }

    public boolean threadIsRunning() {
        return this.threadRunning;
    }

    private SignalWindow() {
    }

    public static synchronized SignalWindow getInstance() {
        if (content != null) {
            return content;
        }
        content = new SignalWindow();
        return content;
    }

    public Map<Integer, Signal> getSignalMap() {
        return this.signalList;
    }

    public Map<Integer, Signal> getDisplayedSignalMap() {
        return this.displayedSignalList;
    }

    public List<Signal> getSignalList() {
        return new ArrayList<Signal>(this.signalList.values());
    }
}

