/*
 * Decompiled with CFR 0.152.
 */
package com.pemicro.forms.connection;

import com.pemicro.debugView.CoreDebug;
import com.pemicro.forms.IPEKeys;
import com.pemicro.forms.connection.Interface;
import java.net.URI;
import java.util.Arrays;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ConnectionAssistant
implements Runnable {
    private short api;
    public BdmSpeedGroup bdmSpeedGroup;
    Interface[] interfaces;
    protected Listener openURL = new Listener(){

        public void handleEvent(Event event) {
            String url = event.text;
            Object[] browsers = new String[]{"google-chrome", "firefox", "opera", "epiphany", "konqueror", "conkeror", "midori", "kazehakase", "mozilla"};
            try {
                Class<?> d = Class.forName("java.awt.Desktop");
                d.getDeclaredMethod("browse", URI.class).invoke(d.getDeclaredMethod("getDesktop", new Class[0]).invoke(null, new Object[0]), URI.create(url));
            }
            catch (Exception exception) {
                try {
                    if (IPEKeys.OS_NAME.startsWith("Mac OS")) {
                        Class.forName("com.apple.eio.FileManager").getDeclaredMethod("openURL", String.class).invoke(null, url);
                    } else if (IPEKeys.OS_NAME.startsWith("Windows")) {
                        Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
                    } else {
                        String browser = null;
                        Object[] objectArray = browsers;
                        int n = browsers.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String b = objectArray[n2];
                            if (browser == null && Runtime.getRuntime().exec(new String[]{"which", b}).getInputStream().read() != -1) {
                                Runtime.getRuntime().exec(new String[]{browser = b, url});
                            }
                            ++n2;
                        }
                        if (browser == null) {
                            throw new Exception(Arrays.toString(browsers));
                        }
                    }
                }
                catch (Exception e) {
                    MessageBox mb = new MessageBox(new Shell());
                    mb.setMessage("Error attempting to launch web browser\n" + e.toString());
                    mb.open();
                }
            }
        }
    };
    Display disp;
    Shell shell;
    Shell parentShell;
    private CyclonePowerGroup cyclonePowerGroup;
    private static final int SHELL_WIDTH = 475;
    private static final int SHELL_HEIGHT = 230;
    private Canvas connectionCanvas;
    private Label inDialogLabel;
    private Combo comboInterface;
    private Combo comboDevice;
    private Button retryButton;
    private Button abortButton;
    private Button refreshButton;
    private boolean refreshed = false;
    private short result = 0;
    private short interfaceIndex = 0;
    private short deviceIndex = 0;
    private String header;
    private String arch;
    private String caption;
    private short defaultInterface;
    private short defaultDevice;
    private short defaultBdmFrequency;
    private boolean doProvidePower;
    private boolean doPowerOffOnExit;
    private String powerVoltage = "0";
    private String powerDownDelay = "0";
    private String powerUpDelay = "0";
    private boolean doDelayAfterReset;
    private String delayAfterReset = "0";
    private String shiftFrequency = "0000";

    public void run() {
        this.refreshed = false;
        this.disp = PlatformUI.getWorkbench().getDisplay();
        this.parentShell = PlatformUI.getWorkbench().getDisplay().getShells()[0];
        if (this.shell == null || this.shell.isDisposed()) {
            this.shell = new Shell(this.parentShell, 67680);
            this.shell.addListener(21, new Listener(){

                public void handleEvent(Event event) {
                    ConnectionAssistant.this.result = (short)3;
                    event.doit = true;
                }
            });
            this.createContents();
            this.shell.open();
            this.shell.layout();
        } else {
            this.updateContents();
            this.refreshButton.setEnabled(true);
        }
        this.shell.setActive();
        while (!this.shell.isDisposed() && !this.refreshed) {
            if (this.disp.readAndDispatch()) continue;
            this.disp.sleep();
        }
    }

    public void close() {
        if (!this.shell.isDisposed()) {
            this.shell.dispose();
        }
    }

    protected void updateContents() {
        this.shell.setImage(PlatformUI.getWorkbench().getDisplay().getShells()[0].getImage());
        this.shell.setText(this.header);
        this.inDialogLabel.setText(this.caption);
        this.comboInterface.removeAll();
        Interface[] interfaceArray = this.interfaces;
        int n = this.interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Interface inter = interfaceArray[n2];
            this.comboInterface.add(inter.getName());
            ++n2;
        }
        this.comboInterface.select((int)this.defaultInterface);
        this.comboDevice.setItems(this.interfaces[this.defaultInterface].getDevices());
        this.comboDevice.select((int)this.defaultDevice);
        if (this.api >= 2) {
            if (this.arch.toLowerCase().contains("s08") || this.arch.toLowerCase().contains("cfv1") || this.arch.toLowerCase().contains("s12")) {
                String selectionString = this.comboInterface.getText();
                if (selectionString.toLowerCase().contains("cyclone") || selectionString.toLowerCase().contains("tacelink")) {
                    this.cyclonePowerGroup.enable(true);
                } else {
                    this.cyclonePowerGroup.enable(false);
                }
                this.cyclonePowerGroup.setDoPowerOffOnExit(this.doPowerOffOnExit);
                this.cyclonePowerGroup.setDoProvidePower(this.doProvidePower);
                this.cyclonePowerGroup.setPowerDownDelay(this.powerDownDelay);
                this.cyclonePowerGroup.setPowerUpDelay(this.powerUpDelay);
                this.cyclonePowerGroup.setPowerVoltage(this.powerVoltage);
            } else {
                this.bdmSpeedGroup.setBdmFrequencies(this.interfaces[this.defaultInterface].getBdmShiftFrequencies());
                this.bdmSpeedGroup.setBdmFrequencySelection(this.defaultBdmFrequency);
                this.bdmSpeedGroup.setDoDolayAfterReset(this.doDelayAfterReset);
                this.bdmSpeedGroup.setDelayAfterReset(this.delayAfterReset);
            }
        }
    }

    protected void createContents() {
        GridLayout shellLayout = new GridLayout(1, false);
        GridLayout layout = new GridLayout(3, false);
        this.connectionCanvas = new Canvas((Composite)this.shell, 0);
        this.connectionCanvas.setLayout((Layout)layout);
        Rectangle bounds = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getBounds();
        this.shell.setImage(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getImage());
        this.shell.setSize(475, 230);
        this.shell.setText(this.header);
        int shellX = bounds.x + (bounds.width - this.shell.getSize().x) / 2;
        int shellY = bounds.y + (bounds.height - this.shell.getSize().y) / 2;
        Rectangle shellBounds = new Rectangle(shellX, shellY, this.shell.getSize().x, this.shell.getSize().y);
        this.shell.setBounds(shellBounds);
        this.shell.setLayout((Layout)shellLayout);
        GridData data = new GridData();
        data.horizontalSpan = 3;
        data.widthHint = 465;
        this.inDialogLabel = new Label((Composite)this.connectionCanvas, 64);
        this.inDialogLabel.setText(this.caption);
        this.inDialogLabel.setSize(this.inDialogLabel.computeSize(435, -1));
        this.inDialogLabel.setLayoutData((Object)data);
        data = new GridData();
        data.widthHint = 300;
        data.heightHint = 25;
        data.horizontalSpan = 3;
        this.comboInterface = new Combo((Composite)this.connectionCanvas, 8);
        this.comboInterface.setLocation(ConnectionAssistant.setYOffsetFrom(this.inDialogLabel, 5));
        this.comboInterface.removeAll();
        Interface[] interfaceArray = this.interfaces;
        int n = this.interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Interface inter = interfaceArray[n2];
            this.comboInterface.add(inter.getName());
            ++n2;
        }
        this.comboInterface.select((int)this.defaultInterface);
        this.comboInterface.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                ConnectionAssistant.this.comboDevice.setItems(ConnectionAssistant.this.interfaces[ConnectionAssistant.this.comboInterface.getSelectionIndex()].getDevices());
                ConnectionAssistant.this.comboDevice.select((int)ConnectionAssistant.this.defaultDevice);
                String selectionString = ConnectionAssistant.this.comboInterface.getText();
                if (ConnectionAssistant.this.api >= 2) {
                    if (ConnectionAssistant.this.arch.toLowerCase().contains("s08") || ConnectionAssistant.this.arch.toLowerCase().contains("cfv1") || ConnectionAssistant.this.arch.toLowerCase().contains("s12")) {
                        if (selectionString.toLowerCase().contains("cyclone") || selectionString.toLowerCase().contains("tacelink")) {
                            ConnectionAssistant.this.cyclonePowerGroup.enable(true);
                        } else {
                            ConnectionAssistant.this.cyclonePowerGroup.enable(false);
                        }
                    } else {
                        ConnectionAssistant.this.bdmSpeedGroup.setBdmFrequencies(ConnectionAssistant.this.interfaces[ConnectionAssistant.this.comboInterface.getSelectionIndex()].getBdmShiftFrequencies());
                        ConnectionAssistant.this.bdmSpeedGroup.setBdmFrequencySelection(ConnectionAssistant.this.defaultBdmFrequency);
                    }
                }
            }
        });
        this.comboInterface.setLayoutData((Object)data);
        data = new GridData();
        data.horizontalSpan = 2;
        data.widthHint = 300;
        data.heightHint = 25;
        this.comboDevice = new Combo((Composite)this.connectionCanvas, 8);
        this.comboDevice.setLocation(ConnectionAssistant.setYOffsetFrom(this.comboInterface, 5));
        this.comboDevice.setVisibleItemCount(10);
        this.comboDevice.setItems(this.interfaces[this.defaultInterface].getDevices());
        this.comboDevice.select((int)this.defaultDevice);
        this.comboDevice.setLayoutData((Object)data);
        this.refreshButton = new Button((Composite)this.connectionCanvas, 0);
        this.refreshButton.setText("Refresh");
        this.refreshButton.setLocation(ConnectionAssistant.setXOffsetFrom(this.comboDevice, 10));
        this.refreshButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConnectionAssistant.this.refreshButton.setEnabled(false);
                ConnectionAssistant.this.result = (short)1;
                ConnectionAssistant.this.interfaceIndex = (short)ConnectionAssistant.this.comboInterface.getSelectionIndex();
                ConnectionAssistant.this.deviceIndex = (short)ConnectionAssistant.this.comboDevice.getSelectionIndex();
                ConnectionAssistant.this.refreshed = true;
            }
        });
        this.retryButton = new Button((Composite)this.connectionCanvas, 0);
        this.retryButton.setText("Retry");
        this.retryButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConnectionAssistant.this.result = (short)2;
                ConnectionAssistant.this.interfaceIndex = (short)ConnectionAssistant.this.comboInterface.getSelectionIndex();
                ConnectionAssistant.this.deviceIndex = (short)ConnectionAssistant.this.comboDevice.getSelectionIndex();
                ConnectionAssistant.this.close();
            }
        });
        this.abortButton = new Button((Composite)this.connectionCanvas, 0);
        this.abortButton.setText("Abort");
        this.abortButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConnectionAssistant.this.result = (short)3;
                ConnectionAssistant.this.close();
            }
        });
        if (this.api >= 2) {
            if (this.arch.toLowerCase().contains("s08") || this.arch.toLowerCase().contains("cfv1") || this.arch.toLowerCase().contains("s12")) {
                this.cyclonePowerGroup = new CyclonePowerGroup((Composite)this.shell);
                String selectionString = this.comboInterface.getText();
                if (selectionString.toLowerCase().contains("cyclone") || selectionString.toLowerCase().contains("tacelink")) {
                    this.cyclonePowerGroup.enable(true);
                } else {
                    this.cyclonePowerGroup.enable(false);
                }
                this.cyclonePowerGroup.setDoPowerOffOnExit(this.doPowerOffOnExit);
                this.cyclonePowerGroup.setDoProvidePower(this.doProvidePower);
                this.cyclonePowerGroup.setPowerDownDelay(this.powerDownDelay);
                this.cyclonePowerGroup.setPowerUpDelay(this.powerUpDelay);
                this.cyclonePowerGroup.setPowerVoltage(this.powerVoltage);
            } else {
                this.bdmSpeedGroup = new BdmSpeedGroup((Composite)this.shell);
                this.bdmSpeedGroup.setBdmFrequencies(this.interfaces[this.defaultInterface].getBdmShiftFrequencies());
                this.bdmSpeedGroup.setBdmFrequencySelection(this.defaultBdmFrequency);
                this.bdmSpeedGroup.setDoDolayAfterReset(this.doDelayAfterReset);
                this.bdmSpeedGroup.setDelayAfterReset(this.delayAfterReset);
            }
        }
        this.connectionCanvas.pack();
        this.shell.pack();
    }

    public short getButtonPressed() {
        return this.result;
    }

    public short getInterfaceIndex() {
        return this.interfaceIndex;
    }

    public short getDeviceIndex() {
        return this.deviceIndex;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public void setInterfaces(Interface[] interfaces) {
        this.interfaces = interfaces;
    }

    public void setDefaultInterface(short defaultInterface) {
        CoreDebug.writeDebug(1, "DEFAULT INTERFACE = " + defaultInterface);
        this.defaultInterface = defaultInterface;
    }

    public void setDefaultDevice(short defaultDevice) {
        CoreDebug.writeDebug(1, "DEFAULT DEVICE = " + defaultDevice);
        this.defaultDevice = defaultDevice;
    }

    public void setDefaultBdmFrequency(short defaultBdmFrequency) {
        CoreDebug.writeDebug(1, "DEFAULT FREQUENCY = " + defaultBdmFrequency);
        this.defaultBdmFrequency = defaultBdmFrequency;
    }

    public void setArchitecture(String arch) {
        CoreDebug.writeDebug(1, "ARCHITECTURE = " + arch);
        this.arch = arch;
    }

    public void setDoProvidePower(boolean doProvidePower) {
        this.doProvidePower = doProvidePower;
    }

    public void setDoPowerOffOnExit(boolean doPowerOffOnExit) {
        this.doPowerOffOnExit = doPowerOffOnExit;
    }

    public void setPowerVoltage(String powerVoltage) {
        this.powerVoltage = powerVoltage;
    }

    public void setPowerUpDelay(String powerUpDelay) {
        this.powerUpDelay = powerUpDelay;
    }

    public void setPowerDownDelay(String powerDownDelay) {
        this.powerDownDelay = powerDownDelay;
    }

    public void setDoDelayAfterReset(boolean doDelayAfterReset) {
        this.doDelayAfterReset = doDelayAfterReset;
    }

    public void setDelayAfterReset(String delayAfterReset) {
        this.delayAfterReset = delayAfterReset;
    }

    public CyclonePowerGroup getCyclonePowerGroup() {
        return this.cyclonePowerGroup;
    }

    public BdmSpeedGroup getBdmSpeedGroup() {
        return this.bdmSpeedGroup;
    }

    public void setShiftFrequency(String shiftFrequency) {
        this.shiftFrequency = shiftFrequency;
    }

    public String getShiftFrequency() {
        return this.shiftFrequency;
    }

    static Point setXOffsetFrom(Combo combo, int offset) {
        Point coord = new Point(combo.getBounds().x + combo.getBounds().width + offset, combo.getBounds().y);
        return coord;
    }

    static Point setYOffsetFrom(Combo combo, int offset) {
        Point coord = new Point(combo.getBounds().x, combo.getBounds().y + combo.getBounds().height + offset);
        return coord;
    }

    static Point setYOffsetFrom(Label label, int offset) {
        Point coord = new Point(label.getBounds().x, label.getBounds().y + label.getBounds().height + offset);
        return coord;
    }

    public void setApi(short api) {
        this.api = api;
    }

    public class BdmSpeedGroup {
        private Group bdmCommunicationSpeedGroup;
        private Label pciLabel;
        private Combo comboFreq;
        private Text freqText;
        private Button delayAfterResetButton;
        private Text delayAfterResetText;
        private Label decimalLabel;
        private int bdmFreqSelection;
        private boolean doDelayAfterReset;
        private String delayAfterReset;
        protected int pciFreq = 2;
        protected int usbMlFreq = 0;
        protected int cycloneUsbFreq = 3;
        protected int cycloneEthernetFreq = 3;
        protected int cycloneSerialFreq = 3;
        private String buffer;

        public BdmSpeedGroup(Composite comp) {
            GridData data;
            this.bdmCommunicationSpeedGroup = new Group(comp, 0);
            this.bdmCommunicationSpeedGroup.setText("BDM Communication Speed");
            this.bdmCommunicationSpeedGroup.setLayout((Layout)new GridLayout(3, false));
            this.pciLabel = new Label((Composite)this.bdmCommunicationSpeedGroup, 0);
            this.pciLabel.setText("BDM Debug Shift Freq : BDM_SPEED = ");
            if (ConnectionAssistant.this.api < 3) {
                data = new GridData();
                data.horizontalSpan = 2;
                this.comboFreq = new Combo((Composite)this.bdmCommunicationSpeedGroup, 8);
                this.comboFreq.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        BdmSpeedGroup.this.bdmFreqSelection = BdmSpeedGroup.this.comboFreq.getSelectionIndex();
                    }
                });
                this.comboFreq.setLayoutData((Object)data);
            } else {
                data = new GridData();
                data.widthHint = 80;
                this.freqText = new Text((Composite)this.bdmCommunicationSpeedGroup, 133120);
                this.freqText.setLayoutData((Object)data);
                this.freqText.addVerifyListener(new VerifyListener(){

                    public void verifyText(VerifyEvent event) {
                        char[] chrArray;
                        char[] cArray = chrArray = event.text.toCharArray();
                        int n = chrArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            char chr = cArray[n2];
                            if ((chr < '0' || chr > '9') && event.character != '\b' && event.character != '\u007f') {
                                event.doit = false;
                            }
                            ++n2;
                        }
                    }
                });
                this.freqText.addFocusListener(new FocusListener(){

                    public void focusLost(FocusEvent e) {
                        try {
                            Integer.parseInt(BdmSpeedGroup.this.freqText.getText());
                            ConnectionAssistant.this.shiftFrequency = BdmSpeedGroup.this.freqText.getText();
                        }
                        catch (NumberFormatException numberFormatException) {
                            BdmSpeedGroup.this.freqText.setText(BdmSpeedGroup.this.buffer);
                        }
                    }

                    public void focusGained(FocusEvent e) {
                        BdmSpeedGroup.this.buffer = BdmSpeedGroup.this.freqText.getText();
                    }
                });
                Canvas freqCanvas = new Canvas((Composite)this.bdmCommunicationSpeedGroup, 0);
                freqCanvas.setLayout((Layout)new GridLayout(2, false));
                Label hzLabel = new Label((Composite)freqCanvas, 0);
                hzLabel.setText("Hz");
                Link freqLink = new Link((Composite)freqCanvas, 0);
                freqLink.setText("<a href=\"http://www.pemicro.com/hardware/cfv234.html\">[Frequency Guide]</a>");
                freqLink.addListener(13, ConnectionAssistant.this.openURL);
            }
            this.delayAfterResetButton = new Button((Composite)this.bdmCommunicationSpeedGroup, 32);
            this.delayAfterResetButton.setText("Delay after Reset and before communicating to target for");
            this.delayAfterResetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    BdmSpeedGroup.this.doDelayAfterReset = BdmSpeedGroup.this.delayAfterResetButton.getSelection();
                }
            });
            data = new GridData();
            data.widthHint = 80;
            this.delayAfterResetText = new Text((Composite)this.bdmCommunicationSpeedGroup, 133120);
            this.delayAfterResetText.setLayoutData((Object)data);
            this.delayAfterResetText.setText("0");
            this.delayAfterResetText.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    BdmSpeedGroup.this.delayAfterReset = BdmSpeedGroup.this.delayAfterResetText.getText();
                }
            });
            this.decimalLabel = new Label((Composite)this.bdmCommunicationSpeedGroup, 0);
            this.decimalLabel.setText("milliseconds (decimal)");
        }

        protected void setBdmFrequencies(String[] bdmFrequencies) {
            this.comboFreq.setItems(bdmFrequencies);
        }

        public void setBdmFrequencySelection(int bdmFrequencySelection) {
            this.bdmFreqSelection = bdmFrequencySelection;
            this.comboFreq.select(bdmFrequencySelection);
        }

        public void setDoDolayAfterReset(boolean doDelayAfterReset) {
            this.doDelayAfterReset = doDelayAfterReset;
            this.delayAfterResetButton.setSelection(doDelayAfterReset);
        }

        public void setDelayAfterReset(String delayAfterReset) {
            this.delayAfterReset = delayAfterReset;
            this.delayAfterResetText.setText(delayAfterReset);
        }

        public int getBdmFreqSelection() {
            return this.bdmFreqSelection;
        }

        public boolean getDoDelayAfterReset() {
            return this.doDelayAfterReset;
        }

        public String getDelayAfterReset() {
            return this.delayAfterReset;
        }
    }

    public class CyclonePowerGroup {
        public Text powerUpDelayText;
        public Text powerDownDelayText;
        public Button providePowerToButton;
        public Button powerOffTargetButton;
        public Combo powerCombo;
        public Group cycloneProPowerGroup;
        public Label regulatorOutputVoltageLabel;
        public Label powerDownDelayLabel;
        public Label powerUpDelayLabel;
        public Label msLabel1;
        public Label msLabel2;
        private boolean doProvidePower;
        private boolean doPowerOffOnExit;
        private String powerVoltage;
        private String powerDownDelay;
        private String powerUpDelay;

        public CyclonePowerGroup(Composite comp) {
            this.cycloneProPowerGroup = new Group(comp, 0);
            this.cycloneProPowerGroup.setText("Cyclone Pro Power Control (Voltage --> Power-Out Jack)");
            this.cycloneProPowerGroup.setLayout((Layout)new GridLayout(5, false));
            this.providePowerToButton = new Button((Composite)this.cycloneProPowerGroup, 32);
            this.providePowerToButton.setText("Provide power to target");
            this.providePowerToButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CyclonePowerGroup.this.doProvidePower = CyclonePowerGroup.this.providePowerToButton.getSelection();
                }
            });
            this.regulatorOutputVoltageLabel = new Label((Composite)this.cycloneProPowerGroup, 0);
            this.regulatorOutputVoltageLabel.setText("Regulator Output Voltage");
            GridData data = new GridData();
            data.horizontalIndent = 5;
            this.powerDownDelayLabel = new Label((Composite)this.cycloneProPowerGroup, 0);
            this.powerDownDelayLabel.setText("Power Down Delay");
            this.powerDownDelayLabel.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 30;
            this.powerDownDelayText = new Text((Composite)this.cycloneProPowerGroup, 133120);
            this.powerDownDelayText.setTextLimit(4);
            this.powerDownDelayText.setLayoutData((Object)data);
            this.powerDownDelayText.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    CyclonePowerGroup.this.powerDownDelay = CyclonePowerGroup.this.powerDownDelayText.getText();
                }
            });
            this.msLabel1 = new Label((Composite)this.cycloneProPowerGroup, 0);
            this.msLabel1.setText("mS");
            this.powerOffTargetButton = new Button((Composite)this.cycloneProPowerGroup, 32);
            this.powerOffTargetButton.setText("Power off target upon software exit");
            this.powerOffTargetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CyclonePowerGroup.this.doPowerOffOnExit = CyclonePowerGroup.this.powerOffTargetButton.getSelection();
                }
            });
            this.powerCombo = new Combo((Composite)this.cycloneProPowerGroup, 8);
            this.powerCombo.setItems(new String[]{"2V", "3V", "5V"});
            this.powerCombo.setText("5V");
            this.powerCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (CyclonePowerGroup.this.powerCombo.getText().equals("2V")) {
                        CyclonePowerGroup.this.powerVoltage = "0";
                    }
                    if (CyclonePowerGroup.this.powerCombo.getText().equals("3V")) {
                        CyclonePowerGroup.this.powerVoltage = "128";
                    }
                    if (CyclonePowerGroup.this.powerCombo.getText().equals("5V")) {
                        CyclonePowerGroup.this.powerVoltage = "255";
                    }
                }
            });
            data = new GridData();
            data.horizontalIndent = 5;
            this.powerUpDelayLabel = new Label((Composite)this.cycloneProPowerGroup, 0);
            this.powerUpDelayLabel.setText("Power Up Delay");
            this.powerUpDelayLabel.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 30;
            this.powerUpDelayText = new Text((Composite)this.cycloneProPowerGroup, 133120);
            this.powerUpDelayText.setTextLimit(4);
            this.powerUpDelayText.setLayoutData((Object)data);
            this.powerUpDelayText.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    CyclonePowerGroup.this.powerUpDelay = CyclonePowerGroup.this.powerUpDelayText.getText();
                }
            });
            this.msLabel2 = new Label((Composite)this.cycloneProPowerGroup, 0);
            this.msLabel2.setText("mS");
        }

        public void enable(boolean enabled) {
            this.powerUpDelayText.setEnabled(enabled);
            this.powerDownDelayText.setEnabled(enabled);
            this.providePowerToButton.setSelection(enabled);
            this.providePowerToButton.setEnabled(enabled);
            this.powerOffTargetButton.setSelection(enabled);
            this.powerOffTargetButton.setEnabled(enabled);
            this.powerCombo.setEnabled(enabled);
            this.regulatorOutputVoltageLabel.setEnabled(enabled);
            this.powerDownDelayLabel.setEnabled(enabled);
            this.powerUpDelayLabel.setEnabled(enabled);
            this.msLabel1.setEnabled(enabled);
            this.msLabel2.setEnabled(enabled);
        }

        public void setDoProvidePower(boolean doProvidePower) {
            this.doProvidePower = doProvidePower;
            this.providePowerToButton.setSelection(doProvidePower);
        }

        public boolean getDoProvidePower() {
            return this.doProvidePower;
        }

        public void setDoPowerOffOnExit(boolean doPowerOffOnExit) {
            this.doPowerOffOnExit = doPowerOffOnExit;
            this.powerOffTargetButton.setSelection(doPowerOffOnExit);
        }

        public boolean getDoPowerOffOnExit() {
            return this.doPowerOffOnExit;
        }

        public void setPowerVoltage(String powerVoltage) {
            this.powerVoltage = powerVoltage;
            if (powerVoltage.equals("0")) {
                this.powerCombo.setText("2V");
            }
            if (powerVoltage.equals("128")) {
                this.powerCombo.setText("3V");
            }
            if (powerVoltage.equals("255")) {
                this.powerCombo.setText("5V");
            }
        }

        public String getPowerVoltage() {
            return this.powerVoltage;
        }

        public void setPowerUpDelay(String powerUpDelay) {
            this.powerUpDelay = powerUpDelay;
            this.powerUpDelayText.setText(powerUpDelay);
        }

        public String getPowerUpDelay() {
            return this.powerUpDelay;
        }

        public void setPowerDownDelay(String powerDownDelay) {
            this.powerDownDelay = powerDownDelay;
            this.powerDownDelayText.setText(powerDownDelay);
        }

        public String getPowerDownDelay() {
            return this.powerDownDelay;
        }
    }
}

