/*
 * Decompiled with CFR 0.152.
 */
package com.pemicro.debug.gdbjtag.ppc.ui;

import com.pemicro.debug.gdbjtag.ppc.Activator;
import com.pemicro.debug.gdbjtag.ppc.Utils;
import com.pemicro.debug.gdbjtag.ppc.ui.Messages;
import com.pemicro.debug.gdbjtag.ppc.ui.TabDebugger;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.ini4j.Config;
import org.ini4j.InvalidFileFormatException;
import org.ini4j.Wini;

public class AdvancedProgrammingDialog
extends Dialog {
    private static final int TEXT_FIELD_WIDTH_HINT = 60;
    TabDebugger parentDialog;
    Combo algorithmSelectCombo;
    Button alternativeAlgorithmButton;
    Button algorithmBrowseButton;
    Label selectedAlgorithm;
    Button macScriptButton;
    Button macScriptBrowseButton;
    Button macScriptVariablesButton;
    Text macScriptText;
    private static boolean MacPathExists = false;
    private static boolean use_init_script = false;
    ConfigurationClass storedConfig;
    MemoryRange[] preserveRangeArray;

    public AdvancedProgrammingDialog(TabDebugger parent, Shell parentShell) {
        super(parentShell);
        this.parentDialog = parent;
        this.storedConfig = new ConfigurationClass();
        this.preserveRangeArray = new MemoryRange[3];
        int i = 0;
        while (i < 3) {
            this.preserveRangeArray[i] = new MemoryRange();
            ++i;
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        this.getShell().setText(Messages.getString("AdvancedSettings.WindowTitle"));
        GridLayout layout = new GridLayout(1, false);
        container.setLayout((Layout)layout);
        GridData data = new GridData(768);
        container.setLayoutData((Object)data);
        Composite stackedGroups = new Composite(container, 0);
        layout = new GridLayout();
        stackedGroups.setLayout((Layout)layout);
        data = new GridData(770);
        stackedGroups.setLayoutData((Object)data);
        Group group = new Group(stackedGroups, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        data = new GridData(768);
        group.setLayoutData((Object)data);
        group.setText(Messages.getString("AdvancedSettings.FlashAlgorithmSelectionTitle"));
        Label label = new Label((Composite)group, 16448);
        data = new GridData();
        data.widthHint = 300;
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        label.setText(Messages.getString("AdvancedSettings.FlashAlgorithmPrompt"));
        this.algorithmSelectCombo = new Combo((Composite)group, 12);
        data = new GridData();
        data.horizontalSpan = 2;
        data.widthHint = 300;
        this.algorithmSelectCombo.setLayoutData((Object)data);
        this.alternativeAlgorithmButton = new Button((Composite)group, 32);
        this.alternativeAlgorithmButton.setText(Messages.getString("AdvancedSettings.FlashAlgorithmUseAlternative"));
        this.alternativeAlgorithmButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = ((Button)e.getSource()).getSelection();
                AdvancedProgrammingDialog.this.algorithmBrowseButton.setEnabled(enabled);
                AdvancedProgrammingDialog.this.selectedAlgorithm.setVisible(enabled);
            }
        });
        this.algorithmBrowseButton = new Button((Composite)group, 0);
        this.algorithmBrowseButton.setText(Messages.getString("AdvancedSettings.FlashAlgorithmBrowseButton"));
        this.algorithmBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(AdvancedProgrammingDialog.this.getShell(), 0);
                dialog.setText(Messages.getString("AdvancedSettings.AlgorithmBrowseTitle"));
                String str = AdvancedProgrammingDialog.this.storedConfig.alternativeAlgorithmPath;
                int lastSeparatorIndex = str.lastIndexOf(File.separator);
                if (lastSeparatorIndex != -1) {
                    dialog.setFilterPath(str.substring(0, lastSeparatorIndex));
                }
                String[] algorithmFilter = new String[]{"*.pcp"};
                dialog.setFilterExtensions(algorithmFilter);
                str = dialog.open();
                if (str != null) {
                    AdvancedProgrammingDialog.this.storedConfig.alternativeAlgorithmPath = str;
                    File file = new File(AdvancedProgrammingDialog.this.storedConfig.alternativeAlgorithmPath);
                    AdvancedProgrammingDialog.this.selectedAlgorithm.setText(file.getName());
                }
            }
        });
        this.selectedAlgorithm = new Label((Composite)group, 16384);
        data = new GridData();
        data.horizontalSpan = 2;
        data.widthHint = 300;
        this.selectedAlgorithm.setLayoutData((Object)data);
        group = new Group(stackedGroups, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        data = new GridData(768);
        group.setLayoutData((Object)data);
        group.setText(Messages.getString("AdvancedSettings.InitializationScriptTitle"));
        label = new Label((Composite)group, 16448);
        data = new GridData();
        data.widthHint = 300;
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        label.setText(Messages.getString("AdvancedSettings.InitializationScriptPrompt"));
        this.macScriptButton = new Button((Composite)group, 16416);
        data = new GridData();
        data.horizontalSpan = 2;
        this.macScriptButton.setLayoutData((Object)data);
        this.macScriptButton.setText(Messages.getString("AdvancedSettings.InitializationScriptEnable"));
        this.macScriptButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = ((Button)e.getSource()).getSelection();
                AdvancedProgrammingDialog.this.initializationScriptSelected(enabled);
            }
        });
        this.macScriptText = new Text((Composite)group, 2052);
        data = new GridData(768);
        data.horizontalSpan = 2;
        this.macScriptText.setLayoutData((Object)data);
        this.macScriptBrowseButton = new Button((Composite)group, 0);
        this.macScriptBrowseButton.setText(Messages.getString("AdvancedSettings.InitializationScriptBrowseButton"));
        this.macScriptBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(AdvancedProgrammingDialog.this.getShell(), 0);
                dialog.setText(Messages.getString("AdvancedSettings.InitializationScriptBrowseButton_Title"));
                String path = AdvancedProgrammingDialog.this.storedConfig.macScriptPath;
                int lastSeparatorIndex = path.lastIndexOf(File.separator);
                if (lastSeparatorIndex != -1) {
                    dialog.setFilterPath(path.substring(0, lastSeparatorIndex));
                }
                if ((path = dialog.open()) != null) {
                    AdvancedProgrammingDialog.this.storedConfig.macScriptPath = path;
                    AdvancedProgrammingDialog.this.macScriptText.setText(path);
                }
            }
        });
        this.macScriptVariablesButton = new Button((Composite)group, 0);
        this.macScriptVariablesButton.setText(Messages.getString("DebuggerTab.ClientVariablesButton"));
        this.macScriptVariablesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AdvancedProgrammingDialog.this.MacScriptVariablesButtonSelected(AdvancedProgrammingDialog.this.macScriptText);
            }
        });
        group = new Group(stackedGroups, 0);
        layout = new GridLayout();
        group.setLayout((Layout)layout);
        data = new GridData(768);
        group.setLayoutData((Object)data);
        group.setText(Messages.getString("AdvancedSettings.PreserveRangeTitle"));
        label = new Label((Composite)group, 16448);
        data = new GridData();
        data.widthHint = 205;
        label.setLayoutData((Object)data);
        label.setText(Messages.getString("AdvancedSettings.PreserveRangePrompt"));
        int i = 0;
        while (i < 3) {
            this.preserveRangeArray[i].createDialogArea((Composite)group, i);
            ++i;
        }
        this.updateDialog();
        return container;
    }

    private void MacScriptVariablesButtonSelected(Text text) {
        StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(this.getShell());
        if (dialog.open() == 0) {
            text.insert(dialog.getVariableExpression());
        }
    }

    private void updateDialog() {
        boolean localServerEnabled = this.parentDialog.localLaunchButton.getSelection();
        String algName = this.getFlashAlg(this.parentDialog.deviceString);
        this.algorithmSelectCombo.add(algName);
        this.algorithmSelectCombo.select(this.storedConfig.algorithmIndex);
        this.alternativeAlgorithmButton.setSelection(this.storedConfig.useAlternativeAlgorithm);
        File file = new File(this.storedConfig.alternativeAlgorithmPath);
        this.selectedAlgorithm.setText(file.getName());
        this.algorithmSelectCombo.setEnabled(localServerEnabled);
        this.alternativeAlgorithmButton.setEnabled(localServerEnabled);
        boolean enabled = localServerEnabled && this.storedConfig.useAlternativeAlgorithm;
        this.algorithmBrowseButton.setEnabled(enabled);
        this.selectedAlgorithm.setVisible(enabled);
        boolean run_script = this.storedConfig.macScriptEnabled;
        this.macScriptButton.setSelection(run_script);
        this.macScriptButton.setEnabled(localServerEnabled);
        this.macScriptText.setText(this.storedConfig.macScriptPath);
        this.initializationScriptSelected(run_script && localServerEnabled);
        MemoryRange[] memoryRangeArray = this.preserveRangeArray;
        int n = this.preserveRangeArray.length;
        int n2 = 0;
        while (n2 < n) {
            MemoryRange memRange = memoryRangeArray[n2];
            memRange.preserveRangeButton.setSelection(memRange.config.preserveRange);
            memRange.fromText.setText(Long.toHexString(memRange.config.fromValue));
            memRange.toText.setText(Long.toHexString(memRange.config.toValue));
            memRange.setEnabled(memRange.config.preserveRange);
            ++n2;
        }
    }

    private void initializationScriptSelected(boolean enabled) {
        this.macScriptText.setEnabled(enabled);
        this.macScriptBrowseButton.setEnabled(enabled);
        this.macScriptVariablesButton.setEnabled(enabled);
    }

    private String getFlashAlg(String deviceName) {
        String addFileFullPath = String.valueOf(Utils.getGdbServerPath()) + "gdi" + File.separator + "P&E" + File.separator + "pedebug_ppcnexus_" + deviceName.toLowerCase() + ".add";
        Wini addIni = new Wini();
        Config config = new Config();
        addIni.setConfig(config);
        try {
            addIni.load(new File(addFileFullPath));
        }
        catch (InvalidFileFormatException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String algName = addIni.get((Object)deviceName, (Object)"FLASHALG");
        return algName;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected void okPressed() {
        this.storedConfig.update();
        super.okPressed();
    }

    public static void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("com.pemicro.debug.gdbjtag.ppc.algorithmIndex", 0);
        configuration.setAttribute("com.pemicro.debug.gdbjtag.ppc.useAlternativeAlgorithm", false);
        configuration.setAttribute("com.pemicro.debug.gdbjtag.ppc.macScript", "");
        configuration.setAttribute("com.pemicro.debug.gdbjtag.ppc.macScriptEnable", false);
        int i = 0;
        while (i < 3) {
            configuration.setAttribute("com.pemicro.debug.gdbjtag.ppc.preserveMemory" + i, false);
            configuration.setAttribute("com.pemicro.debug.gdbjtag.ppc.preserveMemoryFrom" + i, "0");
            configuration.setAttribute("com.pemicro.debug.gdbjtag.ppc.preserveMemoryTo" + i, "3");
            ++i;
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.storedConfig.algorithmIndex = configuration.getAttribute("com.pemicro.debug.gdbjtag.ppc.algorithmIndex", 0);
            this.storedConfig.useAlternativeAlgorithm = configuration.getAttribute("com.pemicro.debug.gdbjtag.ppc.useAlternativeAlgorithm", false);
            this.storedConfig.alternativeAlgorithmPath = configuration.getAttribute("com.pemicro.debug.gdbjtag.ppc.alternativeAlgorithmPath", "");
            this.storedConfig.macScriptEnabled = configuration.getAttribute("com.pemicro.debug.gdbjtag.ppc.macScriptEnable", false);
            this.storedConfig.macScriptPath = configuration.getAttribute("com.pemicro.debug.gdbjtag.ppc.macScript", "");
            int i = 0;
            while (i < 3) {
                this.preserveRangeArray[i].config.preserveRange = configuration.getAttribute("com.pemicro.debug.gdbjtag.ppc.preserveMemory" + i, false);
                String param = configuration.getAttribute("com.pemicro.debug.gdbjtag.ppc.preserveMemoryFrom" + i, "0");
                this.preserveRangeArray[i].config.fromValue = Long.parseLong(param, 16);
                param = configuration.getAttribute("com.pemicro.debug.gdbjtag.ppc.preserveMemoryTo" + i, "3");
                this.preserveRangeArray[i].config.toValue = Long.parseLong(param, 16);
                ++i;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("com.pemicro.debug.gdbjtag.ppc.algorithmIndex", this.storedConfig.algorithmIndex);
        configuration.setAttribute("com.pemicro.debug.gdbjtag.ppc.useAlternativeAlgorithm", this.storedConfig.useAlternativeAlgorithm);
        configuration.setAttribute("com.pemicro.debug.gdbjtag.ppc.alternativeAlgorithmPath", this.storedConfig.alternativeAlgorithmPath);
        configuration.setAttribute("com.pemicro.debug.gdbjtag.ppc.macScriptEnable", this.storedConfig.macScriptEnabled);
        configuration.setAttribute("com.pemicro.debug.gdbjtag.ppc.macScript", this.storedConfig.macScriptPath);
        int i = 0;
        while (i < 3) {
            configuration.setAttribute("com.pemicro.debug.gdbjtag.ppc.preserveMemory" + i, this.preserveRangeArray[i].config.preserveRange);
            configuration.setAttribute("com.pemicro.debug.gdbjtag.ppc.preserveMemoryFrom" + i, Long.toHexString(this.preserveRangeArray[i].config.fromValue));
            configuration.setAttribute("com.pemicro.debug.gdbjtag.ppc.preserveMemoryTo" + i, Long.toHexString(this.preserveRangeArray[i].config.toValue));
            ++i;
        }
    }

    public static List<String> getGdbServerCommandLineArray(List<String> commands, Wini commandIni, ILaunchConfiguration configuration) {
        block6: {
            String sectionString = "STARTUP";
            try {
                sectionString = "PEDEBUG";
                int index = configuration.getAttribute("com.pemicro.debug.gdbjtag.ppc.algorithmIndex", 0);
                commandIni.put(sectionString, "CURRENT_ALGORITHM_INDEX", (Object)String.valueOf(index));
                boolean tempBool = configuration.getAttribute("com.pemicro.debug.gdbjtag.ppc.useAlternativeAlgorithm", false);
                if (tempBool) {
                    commandIni.put(sectionString, "ALTERNATIVE_ALGORITHM_CHECKBOX", (Object)"1");
                    String param = configuration.getAttribute("com.pemicro.debug.gdbjtag.ppc.alternativeAlgorithmPath", "");
                    commandIni.put(sectionString, "ALTERNATIVE_ALGORITHM_PATH", (Object)param);
                }
                if (!(use_init_script = configuration.getAttribute("com.pemicro.debug.gdbjtag.ppc.macScriptEnable", false))) break block6;
                commandIni.put("SCRIPTFILE", "NUM_EXTRA_USER_SCRIPTFILES", (Object)1);
                String init_script_path = configuration.getAttribute("com.pemicro.debug.gdbjtag.ppc.macScript", "");
                MacPathExists = false;
                try {
                    init_script_path = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(init_script_path, false).trim();
                    File tempFile = new File(init_script_path);
                    if (tempFile.exists() && !tempFile.isDirectory()) {
                        MacPathExists = true;
                    }
                }
                catch (CoreException e) {
                    Activator.log(e);
                    MacPathExists = false;
                }
                commandIni.put("SCRIPTFILE", "EXTRA_USER_SCRIPTFILE1", (Object)init_script_path);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return commands;
    }

    public static boolean getMacPathExist() {
        return MacPathExists;
    }

    public static boolean getInitScriptPath() {
        return use_init_script;
    }

    class ConfigurationClass {
        int algorithmIndex;
        boolean useAlternativeAlgorithm;
        String alternativeAlgorithmPath;
        boolean macScriptEnabled;
        String macScriptPath;

        ConfigurationClass() {
        }

        public void update() {
            String param = "";
            this.algorithmIndex = AdvancedProgrammingDialog.this.algorithmSelectCombo.getSelectionIndex();
            this.useAlternativeAlgorithm = AdvancedProgrammingDialog.this.alternativeAlgorithmButton.getSelection();
            this.macScriptEnabled = AdvancedProgrammingDialog.this.macScriptButton.getSelection();
            this.macScriptPath = AdvancedProgrammingDialog.this.macScriptText.getText();
            MemoryRange[] memoryRangeArray = AdvancedProgrammingDialog.this.preserveRangeArray;
            int n = AdvancedProgrammingDialog.this.preserveRangeArray.length;
            int n2 = 0;
            while (n2 < n) {
                MemoryRange memRange = memoryRangeArray[n2];
                memRange.config.preserveRange = memRange.preserveRangeButton.getSelection();
                param = memRange.fromText.getText();
                param = param.isEmpty() ? "0" : param;
                memRange.config.fromValue = Long.parseLong(param, 16);
                param = memRange.toText.getText();
                param = param.isEmpty() ? "3" : param;
                memRange.config.toValue = Long.parseLong(param, 16);
                ++n2;
            }
        }
    }

    public class MemoryRange {
        public static final int NUM_PRESERVE_RANGES = 3;
        Button preserveRangeButton;
        Text fromText;
        Text toText;
        ConfigurationClass config = new ConfigurationClass();

        MemoryRange() {
        }

        public void createDialogArea(Composite parent, int index) {
            Composite composite = new Composite(parent, 0);
            GridLayout gridLayout = new GridLayout(4, false);
            composite.setLayout((Layout)gridLayout);
            GridData data = new GridData(768);
            composite.setLayoutData((Object)data);
            this.preserveRangeButton = new Button(composite, 16416);
            data = new GridData();
            data.horizontalSpan = 4;
            this.preserveRangeButton.setLayoutData((Object)data);
            this.preserveRangeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    boolean enabled = ((Button)e.getSource()).getSelection();
                    MemoryRange.this.setEnabled(enabled);
                }
            });
            String preserveRangeText = String.format(Messages.getString("AdvancedSettings.PreserveRangeFormatString"), index);
            this.preserveRangeButton.setText(preserveRangeText);
            Label label = new Label(composite, 16384);
            label.setText(Messages.getString("AdvancedSettings.FromString"));
            this.fromText = new Text(composite, 18436);
            data = new GridData();
            data.widthHint = 60;
            this.fromText.setLayoutData((Object)data);
            this.fromText.setTextLimit(8);
            this.fromText.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent e) {
                    e.doit = Character.isISOControl(e.character) ? true : e.text.matches("[0-9a-fA-F]");
                }
            });
            label = new Label(composite, 16384);
            label.setText(Messages.getString("AdvancedSettings.ToString"));
            this.toText = new Text(composite, 18436);
            data = new GridData();
            data.widthHint = 60;
            this.toText.setLayoutData((Object)data);
            this.toText.setTextLimit(8);
            this.toText.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent e) {
                    e.doit = Character.isISOControl(e.character) ? true : e.text.matches("[0-9a-fA-F]");
                }
            });
        }

        public void setEnabled(boolean enabled) {
            this.fromText.setEnabled(enabled);
            this.toText.setEnabled(enabled);
        }

        class ConfigurationClass {
            boolean preserveRange;
            long fromValue;
            long toValue;

            ConfigurationClass() {
            }
        }
    }

    class NumericVerifier
    implements VerifyListener {
        NumericVerifier() {
        }

        public void verifyText(VerifyEvent e) {
            e.doit = Character.isISOControl(e.character) ? true : e.text.matches("\\d");
        }
    }
}

