/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.e200.resolution;

import com.freescale.s32ds.e200.resolution.QuickFixUtil;
import com.nxp.s32ds.e200.checker.LinkerReplaceData;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.markers.WorkbenchMarkerResolution;
import org.osgi.framework.Bundle;

public class LinkerSectionsQuickFix
extends WorkbenchMarkerResolution {
    private static final String REGION = "REGION";
    private static final String LINKER_EXT = "ld";
    private static final String BUNDLE_ID = "com.nxp.s32ds.e200.checker";
    private static final String ERROR_DIALOG_TITLE = "Error dialog";
    private String label;
    private IMarker selectedMarker;

    public LinkerSectionsQuickFix(String label, IMarker marker) {
        this.label = label;
        this.selectedMarker = marker;
    }

    public String getLabel() {
        return this.label;
    }

    public void run(IMarker marker) {
        if (marker.getResource() instanceof IFile) {
            IFile linkerFile = (IFile)marker.getResource();
            try {
                String linkerSectionUpdateFile;
                if (linkerFile.isReadOnly()) {
                    QuickFixUtil.saveInEditor(linkerFile);
                }
                if ((linkerSectionUpdateFile = (String)marker.getAttribute("Type linker section")) == null || linkerSectionUpdateFile.isEmpty()) {
                    return;
                }
                File pathUpdateFile = this.getUpdateLinkerFile(linkerSectionUpdateFile);
                this.processing(linkerFile, pathUpdateFile.toPath());
                linkerFile.refreshLocal(0, null);
            }
            catch (CoreException e) {
                Display disp = Display.getDefault();
                ErrorDialog.openError((Shell)disp.getActiveShell(), (String)ERROR_DIALOG_TITLE, (String)e.getMessage(), (IStatus)e.getStatus());
            }
        }
    }

    private File getUpdateLinkerFile(String linkerSectionUpdateFile) throws CoreException {
        try {
            Bundle bundle = Platform.getBundle((String)BUNDLE_ID);
            URL url = bundle.getEntry("update/" + linkerSectionUpdateFile);
            URL resolvedFileURL = FileLocator.toFileURL((URL)url);
            URI resolvedURI = new URI(resolvedFileURL.getProtocol(), resolvedFileURL.getPath(), null);
            File file = new File(resolvedURI);
            return file;
        }
        catch (Exception e) {
            Status status = new Status(4, BUNDLE_ID, e.getMessage());
            throw new CoreException((IStatus)status);
        }
    }

    public String getDescription() {
        return new String();
    }

    public Image getImage() {
        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_BACK");
    }

    public IMarker[] findOtherMarkers(IMarker[] markers) {
        ArrayList<IMarker> lstMarkers = new ArrayList<IMarker>();
        IResource selectedResource = this.selectedMarker.getResource();
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker it = iMarkerArray[n2];
            if (!it.equals((Object)this.selectedMarker)) {
                try {
                    String type;
                    IResource curResource = it.getResource();
                    if (curResource != null && curResource.equals((Object)selectedResource) && "Add linker section".equals(type = (String)it.getAttribute("Fix type"))) {
                        lstMarkers.add(it);
                    }
                }
                catch (CoreException e) {
                    ResourcesPlugin.getPlugin().getLog().log(e.getStatus());
                }
            }
            ++n2;
        }
        IMarker[] result = lstMarkers.toArray(new IMarker[lstMarkers.size()]);
        return result;
    }

    private IStatus processing(IFile linker, Path ldPath) throws CoreException {
        return this.replaceContent(Paths.get(linker.getLocationURI()), ldPath);
    }

    List<IFile> finderProjectFiles(IContainer container, List<IFile> lstFiles) throws CoreException {
        IResource[] members;
        IResource[] iResourceArray = members = container.members();
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            IFile file;
            String fileExtension;
            IResource member = iResourceArray[n2];
            if (member instanceof IContainer) {
                this.finderProjectFiles((IContainer)member, lstFiles);
            } else if (member instanceof IFile && (fileExtension = (file = (IFile)member).getFileExtension()).contains(LINKER_EXT)) {
                lstFiles.add(file);
            }
            ++n2;
        }
        return lstFiles;
    }

    private IStatus replaceContent(Path targetLDPath, Path templateLDPath) throws CoreException {
        if (!Files.exists(targetLDPath, new LinkOption[0])) {
            String msg = String.format("File from path %s does not exist ", targetLDPath);
            return new Status(4, BUNDLE_ID, msg);
        }
        if (!Files.exists(templateLDPath, new LinkOption[0])) {
            String msg = String.format("File from path %s does not exist ", templateLDPath);
            return new Status(4, BUNDLE_ID, msg);
        }
        try {
            LinkerReplaceData targetReplaceData = LinkerSectionsQuickFix.findRegionInLinkerFile(targetLDPath);
            if (targetReplaceData == null) {
                String msg = String.format("Memory region not found from in file %s ", targetLDPath);
                return new Status(4, BUNDLE_ID, msg);
            }
            List<String> fixLines = this.generateFixLines(templateLDPath, REGION, targetReplaceData);
            List<String> lstStrLines = targetReplaceData.getLines();
            lstStrLines.addAll(targetReplaceData.getLineIndex(), fixLines);
            Files.write(targetLDPath, lstStrLines, StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (IOException e) {
            Status status = new Status(4, BUNDLE_ID, e.getMessage(), (Throwable)e);
            return status;
        }
        return Status.OK_STATUS;
    }

    private List<String> generateFixLines(Path templateLDPath, String TEMPLATE, LinkerReplaceData result) throws IOException {
        List<String> lines = Files.readAllLines(templateLDPath, StandardCharsets.UTF_8);
        ArrayList<String> geneLines = new ArrayList<String>();
        for (String line : lines) {
            if (line.contains(TEMPLATE)) {
                line = line.replace(TEMPLATE, result.getRegion());
            }
            geneLines.add(line);
        }
        return geneLines;
    }

    /*
     * WARNING - void declaration
     */
    private static LinkerReplaceData findRegionInLinkerFile(Path linkerPath) throws CoreException {
        StateSeach stateSearch = StateSeach.BEGIN;
        List<Object> lines = new ArrayList();
        LinkerReplaceData replcement = null;
        try {
            lines = Files.readAllLines(linkerPath, StandardCharsets.UTF_8);
            Pattern ptExt = Pattern.compile(">\\s*(\\w+)");
            int indexLine = 0;
            boolean inComment = false;
            for (String string : lines) {
                void var7_16;
                void var7_11;
                ++indexLine;
                while (var7_11.contains("/*") && var7_11.contains("*/")) {
                    String string2 = String.valueOf(var7_11.substring(0, var7_11.indexOf("/*"))) + var7_11.substring(var7_11.indexOf("*/") + "*/".length());
                }
                if (var7_11.contains("//") && (!var7_11.contains("/*") || var7_11.indexOf("/*") >= var7_11.indexOf("//"))) {
                    String string3 = var7_11.substring(0, var7_11.indexOf("//"));
                }
                if (inComment) {
                    void var7_14;
                    if (!var7_14.contains("*/")) continue;
                    inComment = false;
                    String string4 = var7_14.substring(0, var7_14.indexOf("*/"));
                    if (string4.trim().isEmpty()) continue;
                }
                if (var7_16.contains("/*")) {
                    if (var7_16.contains("//") && var7_16.indexOf("//") < var7_16.indexOf("/*")) {
                        String string5 = var7_16.substring(0, var7_16.indexOf("//"));
                        continue;
                    }
                    inComment = true;
                    if (var7_16.trim().isEmpty()) continue;
                }
                switch (stateSearch) {
                    case BEGIN: {
                        if (!var7_16.contains("*(.init)")) break;
                        stateSearch = StateSeach.INIT_FIND;
                        break;
                    }
                    case INIT_FIND: {
                        if (!var7_16.contains(">")) break;
                        Matcher mt = ptExt.matcher((CharSequence)var7_16);
                        if (mt.find()) {
                            replcement = new LinkerReplaceData();
                            replcement.setRegion(mt.group(1));
                            replcement.setLineIndex(++indexLine);
                            replcement.setLines(lines);
                        }
                        stateSearch = StateSeach.END;
                        break;
                    }
                    case END: {
                        return replcement;
                    }
                }
            }
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, BUNDLE_ID, e.getMessage(), (Throwable)e));
        }
        return replcement;
    }

    static enum StateSeach {
        BEGIN,
        INIT_FIND,
        END;

    }
}

