<?xml version="1.0" encoding="utf-8"?>
<!-- ***************************************************************************
 * Title:     SimplePEState.xml
 * Copyright: Freescale Semiconductor, Inc. All Rights Reserved.
 * Author:    Petr Struzka
 * $Revision: 1.5 $
 * Date:      2010/07/27
 * 
 * Content:   
 *  XSLT transformation
 *     
 * Description:
 *  XSLT transformation of project into simple state XML format 
 * 
 *************************************************************************** -->
   
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:output method="xml" indent="yes"/>

<xsl:template name="parseItems">
  <xsl:param name="items"/>
  <xsl:param name="compNumb"/>
  <xsl:variable name="itemsName" select="name($items)"/>
  <xsl:element name="{$itemsName}">
    <xsl:for-each select="$items/ItemState">
      <xsl:variable name="extranode" select="/PEproject/Extra[@CompNumb=$compNumb]"/>
      <xsl:variable name="symbol" select="ItemSymbol"/>
      <!-- extras -->                    
      <xsl:variable name="extratext" select="$extranode/Item[@Symbol=$symbol]/@Text"/>
      <xsl:variable name="extravisible" select="$extranode/Item[@Symbol=$symbol]/@Visible"/>
      <xsl:if test="Value!='' or Index!='' or UsrMethodName!='' or $extratext!='' or $extravisible!=''">              
        <xsl:element name="S_{$symbol}">          
          <!-- general items attributes -->        
          <xsl:if test="Value!=''">
            <xsl:attribute name="Value"><xsl:value-of select="Value"/></xsl:attribute>
          </xsl:if>
          <xsl:if test="Index!=''">
            <xsl:attribute name="Index"><xsl:value-of select="Index"/></xsl:attribute>
          </xsl:if>
          <xsl:if test="StrgList!=''">
            <xsl:element name="StrgList">
              <xsl:for-each select="StrgList/Line">  
                <xsl:variable name="lineNum" select="position()"/>
                <xsl:element name="Line{$lineNum}"><xsl:apply-templates/></xsl:element>
              </xsl:for-each>
            </xsl:element>
          </xsl:if>    
          <!-- speciality for timing items -->
          <xsl:if test="RuntimeSetting!=''">
            <xsl:attribute name="RuntimeSetting"><xsl:value-of select="RuntimeSetting"/></xsl:attribute>
            <xsl:attribute name="ReqDevPrescHigh"><xsl:value-of select="ReqDevPrescHigh"/></xsl:attribute>
            <xsl:attribute name="ReqDevPrescLow"><xsl:value-of select="ReqDevPrescLow"/></xsl:attribute>
            <xsl:attribute name="ReqDevPrescSlow"><xsl:value-of select="ReqDevPrescSlow"/></xsl:attribute>
            <xsl:attribute name="ReqExtCompPrescHigh"><xsl:value-of select="ReqExtCompPrescHigh"/></xsl:attribute>
            <xsl:attribute name="ReqExtCompPrescLow"><xsl:value-of select="ReqExtCompPrescLow"/></xsl:attribute>
            <xsl:attribute name="ReqExtCompPrescSlow"><xsl:value-of select="ReqExtCompPrescSlow"/></xsl:attribute>
            <xsl:attribute name="ReqSrcClkPrescHigh"><xsl:value-of select="ReqSrcClkPrescHigh"/></xsl:attribute>
            <xsl:attribute name="ReqSrcClkPrescLow"><xsl:value-of select="ReqSrcClkPrescLow"/></xsl:attribute>
            <xsl:attribute name="ReqSrcClkPrescSlow"><xsl:value-of select="ReqSrcClkPrescSlow"/></xsl:attribute>
            <xsl:attribute name="InitValue"><xsl:value-of select="InitValue"/></xsl:attribute>
            <xsl:attribute name="Precision"><xsl:value-of select="Precision"/></xsl:attribute>
            <xsl:attribute name="PrecInProc"><xsl:value-of select="PrecInProc"/></xsl:attribute>
            <xsl:attribute name="UnitText"><xsl:value-of select="UnitText"/></xsl:attribute>
            <xsl:attribute name="MinCounterTicks"><xsl:value-of select="MinCounterTicks"/></xsl:attribute>
            <xsl:copy-of select="LowLimit"/>
            <xsl:copy-of select="HighLimit"/>
            <xsl:copy-of select="List"/>            
          </xsl:if>
          <!-- speciality for methods -->
          <xsl:if test="UsrMethodName!=''">
            <xsl:attribute name="UsrMethodName">
              <xsl:value-of select="UsrMethodName"/>
            </xsl:attribute>
          </xsl:if>
          <!-- extras -->                    
          <xsl:if test="$extranode/Item[@Symbol=$symbol]">
            <xsl:if test="$extratext!=''">            
              <xsl:attribute name="Text"><xsl:value-of select="$extratext"/></xsl:attribute>
            </xsl:if>
            <xsl:if test="$extravisible!=''">            
              <xsl:attribute name="Visible"><xsl:value-of select="$extravisible"/></xsl:attribute>
            </xsl:if>
          </xsl:if>
        </xsl:element>
      </xsl:if>
    </xsl:for-each>
  </xsl:element>
</xsl:template>
 
<xsl:template match="/PEproject">
  <PEproject>
    <xsl:copy-of select="Header"/>
    <xsl:copy-of select="Options"/>
    <xsl:for-each select="/PEproject/*">
      <!-- Parse all project's elements -->
      <xsl:variable name="compType" select="name()"/>
      <!-- UserFolder -->
      <xsl:if test="$compType='UserFolder'">
        <UserFolder>          
          <xsl:attribute name="NodeName"><xsl:value-of select="NodeName"/></xsl:attribute>
          <xsl:attribute name="CompNumb"><xsl:value-of select="CompNumb"/></xsl:attribute>
        </UserFolder>
      </xsl:if>         
      <!-- Configuration -->
      <xsl:if test="$compType='Configuration'">        
        <xsl:element name="{$compType}">
          <CompNumb><xsl:value-of select="CompNumb"/></CompNumb>
          <NodeName><xsl:value-of select="NodeName"/></NodeName>
          <CnfgEnabled><xsl:value-of select="CnfgEnabled"/></CnfgEnabled>
          <TargetCPU><xsl:value-of select="TargetCPU"/></TargetCPU>
          <xsl:copy-of select="ConfigurationComment"/>
          <!-- BoolList_FpgaConfig ignored -->
          <xsl:copy-of select="BoolList_BeanConfig"/>
          <!-- BoolList_TaskConfig ignored -->
          <xsl:copy-of select="BoolList_ProgConfig"/>
          <!-- Properties -->
          <Properties>
          <xsl:for-each select="ItemState">
            <xsl:if test="Value!='' or Index!='' or UsrMethodName!=''">      
              <xsl:variable name="symbol" select="ItemSymbol"/>      
              <xsl:element name="S_{$symbol}">          
                <xsl:if test="Value!=''">
                  <xsl:attribute name="Value"><xsl:value-of select="Value"/></xsl:attribute>
                </xsl:if>
                <xsl:if test="Index!=''">
                  <xsl:attribute name="Index"><xsl:value-of select="Index"/></xsl:attribute>
                </xsl:if>
                <xsl:if test="StrgList!=''">
                  <xsl:copy-of select="StrgList"/>
                </xsl:if>
              </xsl:element>
            </xsl:if>
          </xsl:for-each>
          </Properties>                                    
        </xsl:element>
      </xsl:if>          
      <!-- CPU or Bean -->
      <xsl:if test="$compType='CPU' or $compType='Bean'">        
        <xsl:element name="{$compType}">
          <BeanType><xsl:value-of select="BeanType"/></BeanType>
          <Name><xsl:value-of select="Name"/></Name>
          <CompNumb><xsl:value-of select="CompNumb"/></CompNumb>
          <CompEnabled><xsl:value-of select="CompEnabled"/></CompEnabled>
          <GenCodeMode><xsl:value-of select="GenCodeMode"/></GenCodeMode>
          <xsl:copy-of select="Comment"/>
          <BeanVersion><xsl:value-of select="BeanVersion"/></BeanVersion>
          <!-- properties -->          
          <xsl:call-template name="parseItems">
            <xsl:with-param name="items" select="Properties"/>
            <xsl:with-param name="compNumb" select="CompNumb"/>            
          </xsl:call-template> 
          <!-- methods -->
          <xsl:call-template name="parseItems">
            <xsl:with-param name="items" select="Methods"/>
            <xsl:with-param name="compNumb" select="CompNumb"/>
          </xsl:call-template>
          <!-- Events -->
          <xsl:call-template name="parseItems">
            <xsl:with-param name="items" select="Events"/>
            <xsl:with-param name="compNumb" select="CompNumb"/>
          </xsl:call-template>
          <xsl:if test="$compType='CPU'"> <!-- CPU only -->
            <!-- CPU state -->
            <Cpu_State>
              <Orientation><xsl:value-of select="Cpu_State/Orientation"/></Orientation>
              <xsl:copy-of select="Cpu_State/UsedResources"/>
              <xsl:copy-of select="Cpu_State/NewInitedRegs"/>
              <RegBase><xsl:value-of select="Cpu_State/RegBase"/></RegBase>
              <DestCompiler><xsl:value-of select="Cpu_State/DestCompiler"/></DestCompiler>
              <xsl:call-template name="parseItems">
                <xsl:with-param name="items" select="Cpu_State/CompilerProperties"/>
                <xsl:with-param name="compNumb" select="CompNumb"/>
              </xsl:call-template>
              <DestLanguage><xsl:value-of select="Cpu_State/DestLanguage"/></DestLanguage>
              <IVTtype><xsl:value-of select="Cpu_State/IVTtype"/></IVTtype>
              <HighNumberFormat><xsl:value-of select="Cpu_State/HighNumberFormat"/></HighNumberFormat>
              <AsmAddrFormat><xsl:value-of select="Cpu_State/AsmAddrFormat"/></AsmAddrFormat>
              <AsmDataFormat><xsl:value-of select="Cpu_State/AsmDataFormat"/></AsmDataFormat>
              <AsmBitsFormat><xsl:value-of select="Cpu_State/AsmBitsFormat"/></AsmBitsFormat>
              <xsl:copy-of select="Cpu_State/CPUDB_Settings"/>
            </Cpu_State>
          </xsl:if>
        </xsl:element> 
      </xsl:if>
    </xsl:for-each>
  </PEproject>
</xsl:template>

</xsl:stylesheet>
