/*******************************************************************************
 * Copyright (c) 2000, 2008 QNX Software Systems and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     QNX Software Systems - Initial API and implementation
 *     Markus Schorn (Wind River Systems)
 *     John Cortell (Freescale) - code customized for Processor Expert
 *******************************************************************************/
package com.processorexpert.derivative.npw;

import org.eclipse.cdt.core.CCProjectNature;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

import com.processorexpert.derivative.Activator;

public class NewProjectCreator {
	/**
	 * Creates a new project resource with the selected name.
	 * <p>
	 * (Copied from
	 * org.eclipse.cdt.ui.wizards.NewCProjectWizard.createNewProject)
	 * </p>
	 * <p>
	 * In normal usage, this method is invoked after the user has pressed Finish
	 * on the wizard; the enablement of the Finish button implies that all
	 * controls on the pages currently contain valid values.
	 * </p>
	 * <p>
	 * Note that this wizard caches the new project once it has been
	 * successfully created; subsequent invocations of this method will answer
	 * the same project resource without attempting to create it again.
	 * </p>
	 * 
	 * @return the created project resource, or <code>null</code> if the project
	 *         was not created
	 */
	public static IProject createProjectResource(int idx, IProject project, IProject[] newProjects,
			IPath wizardLocation, boolean addCNature, String generatorVersion, IProgressMonitor monitor) throws CoreException {

		if (newProjects != null && idx < newProjects.length
				&& newProjects[idx] != null)
			return newProjects[idx];

		// get a project descriptor
		IPath defaultPath = Platform.getLocation();
		IPath newPath = wizardLocation;
		if (defaultPath.equals(newPath))
			newPath = null;
		IWorkspace workspace = ResourcesPlugin.getWorkspace();
		IProjectDescription description = workspace
				.newProjectDescription(project.getName());
		description.setLocation(newPath);

		newProjects[idx] = CCorePlugin.getDefault().createCProject(description,
				project, monitor,
				ManagedBuilderCorePlugin.MANAGED_MAKE_PROJECT_ID);
		if (addCNature) {
			CCProjectNature.addCCNature(newProjects[idx],
					new SubProgressMonitor(monitor, 1));
		}
		ProjectScope projectScope = new ProjectScope(newProjects[idx]);
		Preferences prefs = projectScope.getNode(
				Activator.PLUGIN_ID).node(
				generatorVersion);
		if (prefs != null) {
			prefs.put(generatorVersion, 
					Activator.getDefault().getBundle().getVersion().toString());
			try {
				prefs.flush();
			} catch (BackingStoreException e) {
				e.printStackTrace();
			}
		}
		return newProjects[idx];
	}
}
