/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.debugger.internal.registry.core;

import com.nxp.s32ds.cle.runtime.debugger.internal.registry.core.DebuggerConfigurationImpl;
import com.nxp.s32ds.cle.runtime.debugger.registry.Configuration;
import com.nxp.s32ds.cle.runtime.debugger.registry.DebuggerConfigurationDescriptor;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;

public class DebuggerConfigurationDescriptorImpl
implements DebuggerConfigurationDescriptor<Configuration> {
    private final String debugger;
    private final Map<String, Configuration> deviceConfiguration = new HashMap<String, Configuration>();
    private final Map<String, Configuration> deviceCoreConfiguration = new HashMap<String, Configuration>();

    public DebuggerConfigurationDescriptorImpl(IConfigurationElement configuarationElement) {
        this.debugger = configuarationElement.getAttribute("debugger");
        IConfigurationElement[] iConfigurationElementArray = configuarationElement.getChildren("configuration");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurations = iConfigurationElementArray[n2];
            IConfigurationElement[] iConfigurationElementArray2 = configurations.getChildren();
            int n3 = iConfigurationElementArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement configuration = iConfigurationElementArray2[n4];
                if ("device".equals(configuration.getName())) {
                    this.createConfigurationByDevice(configuration);
                }
                if ("deviceCore".equals(configuration.getName())) {
                    this.createConfigurationByDeviceCore(configuration);
                }
                ++n4;
            }
            ++n2;
        }
    }

    private void createConfigurationByDevice(IConfigurationElement configuration) {
        String device = configuration.getAttribute("id");
        boolean secureDebugging = false;
        IConfigurationElement[] iConfigurationElementArray = configuration.getChildren("secureDebugging");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            String enabled = element.getAttribute("enabled");
            try {
                secureDebugging = Boolean.valueOf(enabled);
                break;
            }
            catch (NumberFormatException numberFormatException) {
                ++n2;
            }
        }
        DebuggerConfigurationImpl cfg = new DebuggerConfigurationImpl(DebuggerConfigurationDescriptorImpl.getInitializationScript(configuration), DebuggerConfigurationDescriptorImpl.getConnectionPort(configuration), secureDebugging);
        this.deviceConfiguration.put(device, cfg);
    }

    private void createConfigurationByDeviceCore(IConfigurationElement configuration) {
        String deviceCore = configuration.getAttribute("id");
        DebuggerConfigurationImpl cfg = new DebuggerConfigurationImpl(DebuggerConfigurationDescriptorImpl.getInitializationScript(configuration), DebuggerConfigurationDescriptorImpl.getConnectionPort(configuration), false);
        this.deviceCoreConfiguration.put(deviceCore, cfg);
    }

    private static String getConnectionPort(IConfigurationElement element) {
        return DebuggerConfigurationDescriptorImpl.getAttributeByElement(element, "connection", "port");
    }

    private static String getInitializationScript(IConfigurationElement element) {
        return DebuggerConfigurationDescriptorImpl.getAttributeByElement(element, "initialization", "script");
    }

    private static String getAttributeByElement(IConfigurationElement configuration, String element, String attribute) {
        IConfigurationElement[] iConfigurationElementArray = configuration.getChildren(element);
        if (iConfigurationElementArray.length != 0) {
            IConfigurationElement initConfig = iConfigurationElementArray[0];
            return initConfig.getAttribute(attribute);
        }
        return "";
    }

    public String getDebugger() {
        return this.debugger;
    }

    public Map<String, Configuration> getConfigurationByDevice() {
        return this.deviceConfiguration;
    }

    public Map<String, Configuration> getConfigurationByDeviceCore() {
        return this.deviceCoreConfiguration;
    }
}

