/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.hardware.internal.registry;

import com.nxp.s32ds.cle.runtime.hardware.registry.HardwareToolsDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.HardwareToolsRegistry;
import com.nxp.s32ds.ext.rcp.registry.BaseRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;

@Component
public class HardwareToolsRegistryImpl
extends BaseRegistry
implements HardwareToolsRegistry {
    private final Map<String, HardwareToolsDescriptor> hwtDescriptors = new HashMap<String, HardwareToolsDescriptor>();

    @Override
    public List<HardwareToolsDescriptor> getHardwareToolsDescriptors() {
        return new ArrayList<HardwareToolsDescriptor>(this.hwtDescriptors.values());
    }

    @Override
    public HardwareToolsDescriptor getHardwareToolsDescriptor(String id) {
        return this.hwtDescriptors.get(id);
    }

    @Override
    public HardwareToolsDescriptor getHardwareToolsDescriptorsByCoreId(String coreId) {
        return this.hwtDescriptors.values().stream().filter(hwt -> hwt.getCoreId() != null).filter(hwt -> hwt.getCoreId().equals(coreId)).findFirst().orElse(null);
    }

    @Override
    public HardwareToolsDescriptor getHardwareToolsDescriptorsByDeviceId(String deviceId) {
        return this.hwtDescriptors.values().stream().filter(hwt -> hwt.getDeviceId() != null).filter(hwt -> hwt.getDeviceId().equals(deviceId)).findFirst().orElse(null);
    }

    @Override
    public HardwareToolsDescriptor getHardwareToolsDescriptorsByDeviceCoreId(String deviceCoreId) {
        return this.hwtDescriptors.values().stream().filter(hwt -> hwt.getDeviceCoreId() != null).filter(hwt -> hwt.getDeviceCoreId().equals(deviceCoreId)).findFirst().orElse(null);
    }

    @Override
    public void addHardwareToolsDescriptor(HardwareToolsDescriptor descriptor) {
        this.addEntityDescriptor(descriptor, this.hwtDescriptors, HardwareToolsDescriptor.class);
    }

    @Override
    public void removeHardwareToolsDescriptor(HardwareToolsDescriptor descriptor) {
        this.removeEntityDescriptor(descriptor, this.hwtDescriptors, HardwareToolsDescriptor.class);
    }
}

