/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.ui.imports;

import com.nxp.s32ds.cle.cdt.ui.imports.ImportExecWizard;
import com.nxp.s32ds.cle.cdt.ui.internal.CdtUiActivator;
import com.nxp.s32ds.cle.cdt.ui.internal.imports.HardwareContentFilter;
import com.nxp.s32ds.cle.cdt.ui.internal.imports.ImportExecMessages;
import com.nxp.s32ds.cle.cdt.ui.internal.imports.ImportValidator;
import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceCoreDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.FamilyDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.core.FamilyDescriptors;
import com.nxp.s32ds.cle.runtime.hardware.registry.ui.tree.HardwareTree;
import com.nxp.s32ds.cle.runtime.hardware.registry.ui.tree.HardwareTrees;
import java.io.IOException;
import java.util.List;
import org.eclipse.cdt.utils.elf.Elf;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ImportExecHardwarePage
extends WizardPage {
    private final ImportExecWizard wizard;
    private static final int TYPE_WIDTH = 50;
    private static final int EXE_FIELD_WIDTH = 600;
    private static final String TITLE = ImportExecMessages.ImportExeWizard_import_exe_page_one_title;
    private static final String SELECT = ImportExecMessages.ImportExePage3_select_processor;
    private Text txtExecutablePath;
    private HardwareTree treeViewer;
    private final ImportValidator importValidator;
    private final List<FamilyDescriptor> familyDescriptors;
    private DeviceCoreDescriptor selectedDeviceCoreDescriptor;
    private String selectedDeviceRevision;

    protected ImportExecHardwarePage(String pageName, ImportExecWizard wizard) {
        super(pageName);
        this.setTitle(TITLE);
        this.setDescription(SELECT);
        this.wizard = wizard;
        this.importValidator = new ImportValidator();
        this.familyDescriptors = FamilyDescriptors.getFamilyDescriptors();
        this.selectedDeviceCoreDescriptor = null;
        this.selectedDeviceRevision = null;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite workArea = new Composite(parent, 0);
        this.setControl((Control)workArea);
        workArea.setLayout((Layout)new GridLayout(1, true));
        this.createExeField(workArea);
        this.createHardwareTree(workArea);
    }

    public String getSelectedExecutablePath() {
        return this.txtExecutablePath.getText();
    }

    private void createExeField(Composite parent) {
        Composite base = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(4, false);
        gridLayout.marginWidth = 0;
        base.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(4, 0x1000000, true, false, 2, 1);
        gridData.widthHint = 600;
        base.setLayoutData((Object)gridData);
        Label lb = new Label(base, 0);
        lb.setText(ImportExecMessages.ImportExePage3_select_executable);
        lb.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.txtExecutablePath = new Text(base, 2056);
        this.txtExecutablePath.setLayoutData((Object)new GridData(768));
        this.txtExecutablePath.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                ImportExecHardwarePage.this.updatePageState();
            }
        });
        Button btn = new Button(base, 8);
        btn.setText(ImportExecMessages.ImportExePage3_browse);
        btn.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        final Text type = new Text(base, 2056);
        type.setBackground(Display.getDefault().getSystemColor(15));
        GridDataFactory.swtDefaults().hint(50, -1).applyTo((Control)type);
        btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(ImportExecHardwarePage.this.getShell(), 0);
                ImportExecHardwarePage.this.wizard.setupFileDialog(dialog);
                String execResourcePath = dialog.open();
                if (execResourcePath != null) {
                    ImportExecHardwarePage.this.txtExecutablePath.setText(execResourcePath);
                    try {
                        type.setText(Elf.getAttributes((String)execResourcePath).getCPU());
                        type.setToolTipText("CPU type: " + type.getText());
                        ImportExecHardwarePage.this.updatePageState();
                    }
                    catch (IOException ex) {
                        CdtUiActivator.getInstance().logWarning(ex.getMessage());
                        type.setToolTipText(ex.getMessage());
                    }
                }
            }
        });
    }

    private void createHardwareTree(Composite parent) {
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        GridData gridData = new GridData(1808);
        Composite leftPanel = new Composite(parent, 0);
        leftPanel.setLayout((Layout)gridLayout);
        leftPanel.setLayoutData((Object)gridData);
        this.treeViewer = HardwareTrees.getHardwareTree((Composite)leftPanel, (ITreeContentProvider)new HardwareContentFilter(), selectionEvent -> {
            this.selectedDeviceCoreDescriptor = this.treeViewer.getDeviceCoreDescriptor();
            this.selectedDeviceRevision = this.treeViewer.getDeviceRevision();
            this.updatePageState();
        });
        this.treeViewer.setInput(this.familyDescriptors);
    }

    public void updatePageState() {
        IStatus status = this.validatePage();
        if (!status.isOK()) {
            this.setErrorMessage(status.getMessage());
        } else {
            this.setDescription("");
            this.setErrorMessage(null);
        }
        this.setPageComplete(status.isOK());
    }

    private IStatus validatePage() {
        if (this.selectedDeviceCoreDescriptor == null) {
            return CdtUiActivator.getInstance().createStatus(4, ImportExecMessages.ImportExeWizard_HardwareSpecification_Error);
        }
        return this.validateExe(this.txtExecutablePath.getText());
    }

    private IStatus validateExe(String path) {
        if (path != null && !path.isEmpty()) {
            return this.importValidator.validate(path);
        }
        return CdtUiActivator.getInstance().createStatus(4, ImportExecMessages.ImportExeWizard_ExecutableFile_Error);
    }

    public boolean isPageComplete() {
        IStatus status = this.validatePage();
        if (!status.isOK()) {
            this.setErrorMessage(status.getMessage());
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    public DeviceCoreDescriptor getDeviceCoreDescriptor() {
        return this.selectedDeviceCoreDescriptor;
    }

    public String getDeviceRevision() {
        return this.selectedDeviceRevision;
    }
}

