/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.rcp.modular.internal.core;

import com.nxp.s32ds.rcp.modular.ModularObject;
import com.nxp.s32ds.rcp.modular.ModularOperationStatus;
import com.nxp.s32ds.rcp.modular.ModularPack;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.provisional.p2.director.PlannerStatus;
import org.eclipse.equinox.p2.operations.ProfileChangeOperation;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.operations.RemediationOperation;

public class ModularOperationStatusImpl
implements ModularOperationStatus {
    private final MultiStatus status;
    private final ProfileChangeOperation operation;
    private final Set<ModularPack> modularObjects;
    private final ProvisioningSession provisioningSession;
    private final RemediationOperation remediationOperation;

    public ModularOperationStatusImpl(IStatus status, ProfileChangeOperation changeOperation, RemediationOperation remediationOperation, Set<ModularPack> modularObjects, ProvisioningSession provisioningSession) {
        this.status = new MultiStatus(status.getPlugin(), 0, "", null);
        this.status.add(status);
        this.operation = changeOperation;
        this.remediationOperation = remediationOperation;
        this.modularObjects = modularObjects;
        this.provisioningSession = provisioningSession;
    }

    public ProfileChangeOperation getExecutableOperation() {
        return this.operation;
    }

    public Map.Entry<ModularPack, String> getDetailStatus() {
        AbstractMap.SimpleEntry<ModularPack, String> entry = null;
        StringBuffer stringBuffer = new StringBuffer();
        this.statusToString((IStatus)this.status, stringBuffer);
        Optional<ModularPack> findFirst = this.modularObjects.stream().filter(ModularObject.class::isInstance).map(ModularPack.class::cast).filter(pack -> Objects.nonNull(pack.getP2featureId())).filter(pack -> stringBuffer.toString().contains(pack.getP2featureId())).findFirst();
        if (findFirst.isPresent()) {
            entry = new AbstractMap.SimpleEntry<ModularPack, String>(findFirst.get(), stringBuffer.toString());
        } else if (this.modularObjects.iterator().hasNext() && stringBuffer.length() > 0) {
            entry = new AbstractMap.SimpleEntry<ModularPack, String>(this.modularObjects.iterator().next(), stringBuffer.toString());
        }
        return entry;
    }

    public void statusToString(IStatus parent, StringBuffer stringBuffer) {
        IStatus[] iStatusArray = parent.getChildren();
        int n = iStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus status = iStatusArray[n2];
            if (status instanceof PlannerStatus) {
                PlannerStatus plannerStatus = (PlannerStatus)status;
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(" ");
                }
                stringBuffer.append(plannerStatus.getRequestStatus().getExplanations().stream().map(a -> a.toString()).collect(Collectors.joining(" ")));
            } else {
                if (status instanceof Status) {
                    Status multiStatus = (Status)status;
                    String message = multiStatus.getMessage();
                    stringBuffer.append(message);
                }
                this.statusToString(status, stringBuffer);
            }
            ++n2;
        }
    }

    public MultiStatus getStatus() {
        return this.status;
    }

    public ProvisioningSession getProvisioningSession() {
        return this.provisioningSession;
    }

    public RemediationOperation getRemediationOperation() {
        return this.remediationOperation;
    }
}

