/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.core.executables;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICOutputEntry;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.executables.Executable;
import org.eclipse.cdt.debug.core.executables.ExecutablesManager;
import org.eclipse.cdt.debug.core.executables.IProjectExecutablesProvider;
import org.eclipse.cdt.debug.core.executables.ISourceFileRemapping;
import org.eclipse.cdt.debug.core.executables.ISourceFileRemappingFactory;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.settings.model.CProjectDescriptionManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.DebugPlugin;

public class StandardExecutableProvider
implements IProjectExecutablesProvider {
    List<String> supportedNatureIds = new ArrayList<String>();

    public StandardExecutableProvider() {
        this.supportedNatureIds.add("org.eclipse.cdt.core.cnature");
        this.supportedNatureIds.add("org.eclipse.cdt.core.ccnature");
    }

    @Override
    public List<String> getProjectNatures() {
        return this.supportedNatureIds;
    }

    @Override
    public List<Executable> getExecutables(IProject project, IProgressMonitor monitor) {
        ArrayList<Executable> executables = new ArrayList<Executable>();
        ICProject cproject = CModelManager.getDefault().create(project);
        try {
            int n;
            int n2;
            Object[] objectArray;
            ICConfigurationDescription cfg;
            IBinary[] allBinaries = cproject.getBinaryContainer().getBinaries();
            if (allBinaries.length == 0) {
                return executables;
            }
            List<IBinary> binaries = null;
            ICProjectDescription projDesc = CProjectDescriptionManager.getInstance().getProjectDescription(project, false);
            if (projDesc != null && (cfg = projDesc.getActiveConfiguration()) != null) {
                binaries = new ArrayList<IBinary>(allBinaries.length);
                ICOutputEntry[] cfgOutDirs = cfg.getBuildSetting().getOutputDirectories();
                IBinary[] iBinaryArray = allBinaries;
                int n3 = allBinaries.length;
                int n4 = 0;
                while (n4 < n3) {
                    IBinary allBinary = iBinaryArray[n4];
                    objectArray = cfgOutDirs;
                    n2 = cfgOutDirs.length;
                    n = 0;
                    while (n < n2) {
                        ICOutputEntry outdir = objectArray[n];
                        if (outdir.getFullPath().isPrefixOf(allBinary.getPath())) {
                            binaries.add(allBinary);
                            break;
                        }
                        ++n;
                    }
                    ++n4;
                }
            }
            if (binaries == null) {
                binaries = Arrays.asList(allBinaries);
            }
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)binaries.size());
            for (IBinary binary : binaries) {
                if (!progress.isCanceled()) {
                    if (binary.isExecutable() || binary.isSharedLib()) {
                        IPath exePath = binary.getResource().getLocation();
                        if (exePath == null) {
                            exePath = binary.getPath();
                        }
                        ArrayList<ISourceFileRemapping> srcRemappers = new ArrayList<ISourceFileRemapping>(2);
                        ISourceFileRemappingFactory[] factories = ExecutablesManager.getExecutablesManager().getSourceFileRemappingFactories();
                        objectArray = factories;
                        n2 = factories.length;
                        n = 0;
                        while (n < n2) {
                            ICOutputEntry factory = objectArray[n];
                            ISourceFileRemapping remapper = factory.createRemapper(binary);
                            if (remapper != null) {
                                srcRemappers.add(remapper);
                            }
                            ++n;
                        }
                        executables.add(new Executable(exePath, project, binary.getResource(), srcRemappers.toArray(new ISourceFileRemapping[srcRemappers.size()])));
                    }
                    progress.worked(1);
                    continue;
                }
                break;
            }
        }
        catch (CoreException e) {
            CDebugCorePlugin.log(e);
        }
        return executables;
    }

    @Override
    public IStatus removeExecutable(Executable executable, IProgressMonitor monitor) {
        IResource exeResource = executable.getResource();
        if (exeResource != null) {
            try {
                exeResource.delete(true, monitor);
            }
            catch (CoreException e) {
                DebugPlugin.log((Throwable)e);
            }
            return Status.OK_STATUS;
        }
        return new Status(2, "org.eclipse.cdt.debug.core", "Can't remove " + executable.getName() + ": it is built by project \"" + executable.getProject().getName() + "\"");
    }
}

