/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.sdkproject;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.expert.processordb.IProcessorMasterToolInfo;
import com.nxp.swtools.expert.processordb.ISupportedDerivativesForSwTools;
import com.nxp.swtools.expert.processordb.SupportedDerivativesForSwTools;
import com.nxp.swtools.expert.processordb.sdkcomponents.SdkComponentsTable;
import com.nxp.swtools.expert.processordb.sdkcomponents.SupportedSdkComponent;
import com.nxp.swtools.provider.SWToolsPlatform;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.provider.toolchainproject.IToolchainProjectWithSdk;
import com.nxp.swtools.sdkproject.AddComponentResolution;
import com.nxp.swtools.sdkproject.Messages;
import com.nxp.swtools.validation.engine.IBaseProblem;
import com.nxp.swtools.validation.engine.IProblemOpenHandler;
import com.nxp.swtools.validation.engine.IProblemOpenProvider;
import com.nxp.swtools.validation.engine.IProblemResolveHandler;
import com.nxp.swtools.validation.engine.IProblemResolveProvider;
import com.nxp.swtools.validation.engine.IValidationProblem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Stream;
import org.eclipse.jface.dialogs.MessageDialog;

public class ToolchainProjectProblemResolveProvider
implements IProblemResolveProvider,
IProblemOpenProvider {
    public @NonNull Collection<@NonNull IProblemResolveHandler> getResolveHandlers(@NonNull IBaseProblem problem) {
        ISharedConfiguration sharedConfig;
        IToolchainProjectWithSdk toolchainPrj;
        IValidationProblem validationProblem;
        ArrayList<@NonNull IProblemResolveHandler> result = new ArrayList<IProblemResolveHandler>();
        if (problem instanceof IValidationProblem && "SWComponent".equals((validationProblem = (IValidationProblem)problem).getDependency().getResourceType()) && "enabled".equals(validationProblem.getFeature().getName()) && (toolchainPrj = (sharedConfig = SharedConfigurationFactory.getSharedConfigurationSingleton()).getToolchainProject()) != null && toolchainPrj.canAddAdditionalComponents()) {
            String compId;
            SupportedSdkComponent sdkComp;
            IProcessorMasterToolInfo processorInfo;
            SdkComponentsTable sdkCompTable;
            ISupportedDerivativesForSwTools supportedDerivs = SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools();
            String processor = toolchainPrj.getProcessor();
            if (processor == null) {
                processor = sharedConfig.getCommonConfig().getMcu();
            }
            SdkComponentsTable sdkComponentsTable = sdkCompTable = (processorInfo = supportedDerivs.getProcessorMasterToolInfo(processor, SWToolsPlatform.getSdkVersionForProcessor((String)processor))) != null ? supportedDerivs.getSdkComponentsTable(processorInfo) : null;
            if (sdkCompTable != null && (sdkComp = (SupportedSdkComponent)CollectionsUtils.findAny((Stream)sdkCompTable.findById(compId = validationProblem.getDependency().getResourceId()), c -> true)) != null) {
                result.add(new AddComponentResolution(toolchainPrj, compId, sdkComp.getName()));
            }
        }
        return result;
    }

    public @NonNull Collection<@NonNull IProblemOpenHandler> getOpenHandlers(@NonNull IBaseProblem problem) {
        IValidationProblem validationProblem;
        ArrayList<@NonNull IProblemOpenHandler> result = new ArrayList<IProblemOpenHandler>();
        if (problem instanceof IValidationProblem && !SWToolsPlatform.isRunningInMCUXpressoIde() && "SWComponent".equals((validationProblem = (IValidationProblem)problem).getDependency().getResourceType()) && "enabled".equals(validationProblem.getFeature().getName())) {
            result.add(new IProblemOpenHandler(){

                public @NonNull String getOpenProblemLabel(@NonNull IBaseProblem openProblem) {
                    return UtilsText.safeString((String)com.nxp.swtools.validation.engine.Messages.get().IProblemOpenHandler_ShowProblemDetails_CommandLabel);
                }

                public void openProblem(@NonNull IBaseProblem openProblem) {
                    MessageDialog.openInformation(null, (String)com.nxp.swtools.validation.engine.Messages.get().IProblemOpenHandler_ProblemDetailsTitle, (String)Messages.get().ShowProblemDetails_ComponentMissingIntheToolchainProject);
                }

                public @Nullable String getTargetToolId() {
                    return null;
                }
            });
        }
        return result;
    }
}

