/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.sdkproject.internal;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.UtilsFile;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.lang.HardReferenceNonNull;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.runtime.DelayedActionExecutorAdapter;
import com.nxp.swtools.common.utils.runtime.DelayedExecution;
import com.nxp.swtools.common.utils.runtime.IDelayedActionExecutor;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.provider.SWToolsPlatform;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.provider.configuration.sources.ISourceFileGenerationStatus;
import com.nxp.swtools.provider.configuration.sources.ISourceFileProviderWrapper;
import com.nxp.swtools.provider.configuration.storage.GeneratedProjectFile;
import com.nxp.swtools.provider.configuration.storage.StorageTool;
import com.nxp.swtools.provider.toolchainproject.IGeneratedFilesStatusProvider;
import com.nxp.swtools.provider.toolchainproject.IToolchainProjectWithSdk;
import com.nxp.swtools.sdkproject.ToolSourceFileProvider;
import com.nxp.swtools.sdkproject.ToolchainProjectDestinationPathProvider;
import com.nxp.swtools.sdkproject.internal.FileChangesWatcher;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;

public class GeneratedFilesStatusProvider
implements IGeneratedFilesStatusProvider,
FileChangesWatcher.IFileChangeListener {
    @NonNull
    protected static final Logger LOGGER = LogManager.getLogger(GeneratedFilesStatusProvider.class);
    private static final int FIRST_TIME_UPDATE_DELAY_3S = 3000;
    private static final int UPDATE_DELAY_IF_DIRTY = 1500;
    private static final int DEFAULT_UPDATE_DELAY = 300;
    @NonNull
    IToolchainProjectWithSdk project;
    @NonNull
    String coreId;
    @NonNull
    @NonNull Map<@NonNull String, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull IGeneratedFilesStatusProvider.GeneratedFileStatus> genFilePrjStatuses = new HashMap<String, IGeneratedFilesStatusProvider.GeneratedFileStatus>();
    @NonNull
    final @NonNull Set<@NonNull Path> watchedPaths = new HashSet<Path>();
    final Collection<@NonNull ToolSourceFileProvider> toolSrcFileProviders;
    private Collection<// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull IGeneratedFilesStatusProvider.IGeneratedFilesStatusListener> listeners = new ArrayList<IGeneratedFilesStatusProvider.IGeneratedFilesStatusListener>();
    @Nullable
    private final IResourceChangeListener eclipseResrcListener;
    @Nullable
    private final IProject eclipseProject;
    boolean firstStatusUpdate = true;
    @NonNull
    final DelayedExecution updateGenFileStatusesDelayedExec = new DelayedExecution("Updating status of the generated files", 50, (IDelayedActionExecutor)new GeneratedFileStatusDelayedRefresh(), 300);

    public GeneratedFilesStatusProvider(@NonNull IToolchainProjectWithSdk project, @NonNull String coreId) {
        this.project = project;
        this.coreId = coreId;
        this.toolSrcFileProviders = ToolSourceFileProvider.getToolSourceFileProviders();
        this.requestUpdate();
        if (SWToolsPlatform.isRunningInEclipseIde()) {
            IProject eclPrj = project.getEclipseProject();
            assert (eclPrj != null);
            this.eclipseProject = eclPrj;
            this.eclipseResrcListener = this::resourceChanged;
            eclPrj.getWorkspace().addResourceChangeListener(this.eclipseResrcListener, 1);
        } else {
            this.eclipseProject = null;
            this.eclipseResrcListener = null;
        }
    }

    protected void resourceChanged(IResourceChangeEvent event) {
        try {
            IResourceDelta delta = event.getDelta();
            if (delta != null) {
                AtomicBoolean genFileChanged = new AtomicBoolean(false);
                delta.accept(d -> this.eclipseResourceDeltaChanged(d, genFileChanged));
                if (genFileChanged.get()) {
                    this.fileChanged(true);
                }
            }
        }
        catch (CoreException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    boolean eclipseResourceDeltaChanged(@Nullable IResourceDelta delta, @NonNull AtomicBoolean genFileChanged) {
        if (delta == null || genFileChanged.get()) {
            return false;
        }
        IResource resource = delta.getResource();
        IProject resrcPrj = resource.getProject();
        if (resrcPrj != null && resrcPrj != this.eclipseProject) {
            return false;
        }
        if (resource.getType() == 1 && (delta.getKind() == 1 || delta.getKind() == 2 || delta.getKind() == 4)) {
            String changedFileName = UtilsFile.getFileNameWithExtension((String)UtilsText.safeString((String)delta.getFullPath().toOSString()));
            Stream<@NonNull String> genFileNames = this.getGeneratedFiles(false).stream().map(UtilsFile::getFileNameWithExtension);
            if (CollectionsUtils.findAny(genFileNames, changedFileName::equals) != null) {
                genFileChanged.set(true);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Issues handling annotations - annotations may be inaccurate
     */
    void applyGenFileChangeWatchers() {
        if (SWToolsPlatform.isRunningInEclipseIde()) {
            return;
        }
        Set<Path> set = this.watchedPaths;
        synchronized (set) {
            if (this.updateGenFileStatusesDelayedExec.isLocked()) {
                return;
            }
            HashSet<@NonNull Path> newPaths = new HashSet<Path>();
            Path prjRoot = this.project.getProjectRoot();
            @NonNull List fileNames = prjRoot.toString().isEmpty() ? CollectionsUtils.emptyUnmodifiableList() : this.genFilePrjStatuses.keySet();
            Iterator iterator = fileNames.iterator();
            while (iterator.hasNext()) {
                ToolchainProjectDestinationPathProvider pathProvider = new ToolchainProjectDestinationPathProvider(this.project, "", null);
                String fileName = (String)iterator.next();
                Path relFilePath = pathProvider.getDestinationPath(fileName);
                Path path = this.project.findSourceFileRelPath(relFilePath);
                if (path == null) {
                    path = relFilePath;
                }
                path = prjRoot.resolve(path).normalize();
                newPaths.add(path);
                if (!this.watchedPaths.add(path) || FileChangesWatcher.addListener(path, this)) continue;
                this.watchedPaths.remove(path);
            }
            Iterator<@NonNull Path> iterator2 = this.watchedPaths.iterator();
            while (iterator2.hasNext()) {
                Path path = iterator2.next();
                if (newPaths.contains(path)) continue;
                FileChangesWatcher.removeListener(path, this);
                iterator2.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.updateGenFileStatusesDelayedExec.lock(0);
        this.listeners = CollectionsUtils.emptyUnmodifiableList();
        Set<Path> set = this.watchedPaths;
        synchronized (set) {
            this.watchedPaths.forEach(path -> FileChangesWatcher.removeListener(path, this));
            this.watchedPaths.clear();
        }
    }

    public @NonNull IToolchainProjectWithSdk getProject() {
        return this.project;
    }

    public @NonNull String getCoreId() {
        return this.coreId;
    }

    public boolean isNeededUpdateProjectCode(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull IGeneratedFilesStatusProvider.GeneratedFileStatus status) {
        switch (status.statusInfo) {
            case NOT_EXIST: 
            case MODIFIED: 
            case DELETE: {
                return true;
            }
            case UP_TO_DATE: 
            case USER_TEMPLATE: {
                return false;
            }
        }
        return false;
    }

    public Collection<@NonNull String> getGeneratedFiles(boolean waitForUpdate) {
        if (waitForUpdate) {
            this.updateGeneratedFilesIfNeeded(true);
        }
        Set<@NonNull String> result = this.genFilePrjStatuses.keySet();
        assert (result != null);
        return result;
    }

    public Stream<@NonNull String> getGeneratedRelFiles(boolean waitForUpdate, @NonNull String toolId) {
        if (waitForUpdate) {
            this.updateGeneratedFilesIfNeeded(true);
        }
        Stream<@NonNull String> result = this.genFilePrjStatuses.entrySet().stream().filter(e -> toolId.equals(((IGeneratedFilesStatusProvider.GeneratedFileStatus)e.getValue()).toolId)).map(Map.Entry::getKey);
        assert (result != null);
        return result;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public IGeneratedFilesStatusProvider.GeneratedFileStatus getGeneratedFileProjectStatus(@NonNull String filePath, boolean waitUntilInfoUpdated) {
        this.updateGeneratedFilesIfNeeded(waitUntilInfoUpdated);
        // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable IGeneratedFilesStatusProvider.GeneratedFileStatus result = this.genFilePrjStatuses.get(filePath);
        if (!Objects.isNull(result)) {
            return result;
        }
        String fileName = UtilsFile.getFileNameWithExtension((String)filePath);
        Set<Map.Entry<@NonNull String, // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull IGeneratedFilesStatusProvider.GeneratedFileStatus>> genPrjFilesEntries = this.genFilePrjStatuses.entrySet();
        assert (genPrjFilesEntries != null);
        @NonNull @NonNull Map.Entry fileEntry = (Map.Entry)CollectionsUtils.findAny(genPrjFilesEntries, e -> UtilsFile.getFileNameWithExtension((String)((String)e.getKey())).equals(fileName));
        if (fileEntry != null) {
            return (IGeneratedFilesStatusProvider.GeneratedFileStatus)fileEntry.getValue();
        }
        LOGGER.log(Level.WARNING, () -> MessageFormat.format("Requested file \"{0}\" given in file path \"{1}\" could not be found in list of generated files \"{2}\"", fileName, filePath, this.genFilePrjStatuses.keySet()));
        return null;
    }

    public final void requestUpdate() {
        ISharedConfiguration sharedConfig = SharedConfigurationFactory.getSharedConfigurationSingleton();
        int delayMS = this.firstStatusUpdate ? 3000 : (sharedConfig.isDirty() ? 1500 : 300);
        this.updateGenFileStatusesDelayedExec.setDelayTime(delayMS);
        this.updateGenFileStatusesDelayedExec.requestExecution();
    }

    public boolean isUpdated() {
        return !this.updateGenFileStatusesDelayedExec.isExecRequested();
    }

    public void clearGeneratedFiles() {
        this.genFilePrjStatuses = new HashMap<String, IGeneratedFilesStatusProvider.GeneratedFileStatus>();
        this.requestUpdate();
    }

    private boolean updateGeneratedFilesIfNeeded(boolean waitUntilInfoUpdated) {
        if ((waitUntilInfoUpdated || this.genFilePrjStatuses.isEmpty()) && !this.updateGenFileStatusesDelayedExec.waitUntilExecuted(40)) {
            LOGGER.severe("Timeout: updateGenFileStatusesDelayedExec was not finished in specified time");
            return false;
        }
        return true;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull IGeneratedFilesStatusProvider.GeneratedFileStatus getProjectFileStatus(@NonNull String toolId, @NonNull HardReferenceNonNull<Path> genFilePath, @NonNull String genFileContent) {
        boolean isInProject;
        String pathStr = ((Path)genFilePath.get()).toString();
        ToolchainProjectDestinationPathProvider pathProvider = new ToolchainProjectDestinationPathProvider(this.project, "board", SharedConfigurationFactory.getSharedConfigurationSingleton().getPreferences().getOutputPathOverrides());
        Path relFilePath = pathProvider.getDestPathProjectRelative(pathStr);
        Path relPath = this.project.findSourceFileRelPath(relFilePath);
        if (relPath == null) {
            isInProject = false;
            relPath = relFilePath;
        } else {
            isInProject = true;
        }
        genFilePath.set((Object)relPath);
        if (genFileContent.isEmpty()) {
            return new IGeneratedFilesStatusProvider.GeneratedFileStatus(IGeneratedFilesStatusProvider.GeneratedFileInfo.USER_TEMPLATE, isInProject, toolId);
        }
        String prjFileContent = this.project.getSourceFileAsCachedString(relPath);
        if (prjFileContent == null) {
            return new IGeneratedFilesStatusProvider.GeneratedFileStatus(IGeneratedFilesStatusProvider.GeneratedFileInfo.NOT_EXIST, isInProject, toolId);
        }
        String genFileContentWithLineEndings = GeneratedFilesStatusProvider.removeLastCrLf(UtilsText.convertLineEndings((String)genFileContent, (String)"\r\n"));
        if (GeneratedFilesStatusProvider.removeLastCrLf(prjFileContent).equals(genFileContentWithLineEndings)) {
            return new IGeneratedFilesStatusProvider.GeneratedFileStatus(IGeneratedFilesStatusProvider.GeneratedFileInfo.UP_TO_DATE, isInProject, toolId);
        }
        return new IGeneratedFilesStatusProvider.GeneratedFileStatus(IGeneratedFilesStatusProvider.GeneratedFileInfo.MODIFIED, isInProject, toolId);
    }

    private static String removeLastCrLf(String content) {
        while (content.endsWith("\r\n")) {
            content = content.substring(0, content.length() - "\r\n".length());
        }
        return content;
    }

    public void addListener(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull IGeneratedFilesStatusProvider.IGeneratedFilesStatusListener listener) {
        if (!this.listeners.contains(listener)) {
            ArrayList<// Could not load outer class - annotation placement on inner may be incorrect
            @NonNull IGeneratedFilesStatusProvider.IGeneratedFilesStatusListener> newListeners = new ArrayList<IGeneratedFilesStatusProvider.IGeneratedFilesStatusListener>(this.listeners);
            newListeners.add(listener);
            this.listeners = newListeners;
        }
    }

    public void removeListener(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull IGeneratedFilesStatusProvider.IGeneratedFilesStatusListener listener) {
        if (this.listeners.contains(listener)) {
            ArrayList<// Could not load outer class - annotation placement on inner may be incorrect
            @NonNull IGeneratedFilesStatusProvider.IGeneratedFilesStatusListener> newListeners = new ArrayList<IGeneratedFilesStatusProvider.IGeneratedFilesStatusListener>(this.listeners);
            newListeners.remove(listener);
            this.listeners = newListeners;
        }
    }

    void notifyListeners() {
        this.listeners.forEach(IGeneratedFilesStatusProvider.IGeneratedFilesStatusListener::generatedFilesStatusUpdated);
    }

    @Override
    public void fileChanged(boolean changedFileContent) {
        this.requestUpdate();
    }

    final class GeneratedFileStatusDelayedRefresh
    extends DelayedActionExecutorAdapter {
        @NonNull
        @NonNull Map<@NonNull String, // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull IGeneratedFilesStatusProvider.GeneratedFileStatus> newGenFilePrjStatuses = new HashMap<String, IGeneratedFilesStatusProvider.GeneratedFileStatus>();
        boolean updated = false;
        boolean canceled = false;

        GeneratedFileStatusDelayedRefresh() {
        }

        public void runAction() {
            this.newGenFilePrjStatuses = new HashMap<String, IGeneratedFilesStatusProvider.GeneratedFileStatus>();
            HashSet<@NonNull String> newGenFileNames = new HashSet<String>();
            this.updated = false;
            this.canceled = false;
            for (ToolSourceFileProvider provider : GeneratedFilesStatusProvider.this.toolSrcFileProviders) {
                if (this.canceled) break;
                this.refreshTool(provider, newGenFileNames);
            }
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        private void refreshTool(ToolSourceFileProvider provider, Set<@NonNull String> newGenFileNames) {
            Collection genFiles;
            ISourceFileProviderWrapper.ISourceGenerateResult genResult = provider.getSourceFileProvider().generate(GeneratedFilesStatusProvider.this.coreId, false);
            if (genResult.getStatus() == ISourceFileGenerationStatus.GenerationStatus.FATAL) {
                return;
            }
            ISharedConfiguration sharedConfig = SharedConfigurationFactory.getSharedConfigurationSingleton();
            @NonNull Collection generatedFiles = genResult.getAllGeneratedFiles();
            String toolId = provider.getToolId();
            generatedFiles.forEach(source -> {
                HardReferenceNonNull pathRef = new HardReferenceNonNull((Object)source.getRelFilePath());
                IGeneratedFilesStatusProvider.GeneratedFileStatus genFileSts = GeneratedFilesStatusProvider.this.getProjectFileStatus(toolId, (HardReferenceNonNull<Path>)pathRef, source.getAsString());
                this.newGenFilePrjStatuses.put(((Path)pathRef.get()).toString(), genFileSts);
                newGenFileNames.add(UtilsFile.getFileNameWithExtension((String)((Path)pathRef.get()).toString()));
            });
            StorageTool strgTool = sharedConfig.getTools().getTool(toolId);
            Collection collection = genFiles = strgTool != null ? strgTool.getGeneratedProjectFiles() : null;
            if (genFiles == null) {
                genFiles = CollectionsUtils.emptyUnmodifiableList();
            }
            for (GeneratedProjectFile genFile : genFiles) {
                String genFileName = genFile.getFileName();
                if (newGenFileNames.contains(genFileName) || genFile.isDerived()) continue;
                Path relPath = GeneratedFilesStatusProvider.this.project.findSourceFileRelPath(Paths.get(genFile.getPath(), new String[0]));
                if (relPath == null) {
                    relPath = Paths.get(genFile.getPath(), new String[0]);
                }
                if (GeneratedFilesStatusProvider.this.project.getSourceModificationStamp(relPath) <= 0L) continue;
                this.newGenFilePrjStatuses.put(relPath.toString(), new IGeneratedFilesStatusProvider.GeneratedFileStatus(IGeneratedFilesStatusProvider.GeneratedFileInfo.DELETE, true, toolId));
            }
        }

        public void executionDone_ApplyChanges() {
            GeneratedFilesStatusProvider.this.firstStatusUpdate = false;
            if (!GeneratedFilesStatusProvider.this.genFilePrjStatuses.equals(this.newGenFilePrjStatuses)) {
                GeneratedFilesStatusProvider.this.genFilePrjStatuses = this.newGenFilePrjStatuses;
                this.updated = true;
                GeneratedFilesStatusProvider.this.applyGenFileChangeWatchers();
            }
        }

        public void executionDone_NotifyListeners() {
            if (this.updated) {
                GeneratedFilesStatusProvider.this.notifyListeners();
            }
        }

        public void cancelAction() {
            this.canceled = true;
        }
    }
}

