/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.sdkproject.parsers;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.NonNullByDefault;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.UtilsDecryption;
import com.nxp.swtools.common.utils.files.YamlMapValueHelper;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.expert.processordb.sdkcomponents.CmsisComponentId;
import com.nxp.swtools.provider.toolchainproject.IToolchainProjectWithSdk;
import com.nxp.swtools.sdkproject.SdkComponentInProject;
import com.nxp.swtools.sdkproject.parsers.GenericPrjAdapterWithCmsisParser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.osgi.framework.Version;

@NonNullByDefault
public class CmsisCsolutionPrjAdapter
extends GenericPrjAdapterWithCmsisParser {
    static final String CBUILD_PRJ_FILE_EXT = ".cbuild.yml";
    private static final String FAIL_TO_LOAD_ELEMENT_MSG = "Fail to load element '{0}'";
    private List<String> supportedSourceFileCategory = Arrays.asList("sourceC", "sourceCpp", "header", "sourceAsm", "genSource", "genHeader");

    public CmsisCsolutionPrjAdapter(File prjFile, File prjDir, IToolchainProjectWithSdk existingProcessorDetector) {
        super(prjFile, prjDir, existingProcessorDetector);
    }

    @Override
    public @Nullable String getToolchainId() {
        return "cbuild.csolution";
    }

    @Override
    public @Nullable String getToolchainName() {
        return "Open-CMSIS csolution";
    }

    @Override
    public boolean parse(Collection<SdkComponentInProject> componentsInPrjFile, Set<Path> prjSources, List<Path> inclPaths, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return false;
        }
        String fullPath = this.prjFile.getAbsolutePath();
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (InputStream iStrm = UtilsDecryption.getFileInputStream((File)new File(fullPath));){
                String errorMsg;
                Map obj = YamlMapValueHelper.load((InputStream)iStrm);
                monitor.worked(5);
                String string = errorMsg = obj == null ? "Unable to load yaml format" : this.collectInfromationFromBuildYaml(obj, componentsInPrjFile, prjSources, inclPaths, monitor);
                if (errorMsg != null) {
                    LOGGER.severe(MessageFormat.format("Failed to load project: '{0}' due to: {1}", fullPath, errorMsg));
                }
                boolean bl = errorMsg == null;
                return bl;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Could not find YAML file: '" + fullPath + "'", e);
            return false;
        }
    }

    private @Nullable String collectInfromationFromBuildYaml(Map<String, Object> rootElement, Collection<SdkComponentInProject> componentsInPrjFile, Set<Path> prjSources, List<Path> inclPaths, IProgressMonitor monitor) {
        String msg = null;
        Map buildElement = YamlMapValueHelper.getMap((String)"build", rootElement);
        if (buildElement != null) {
            this.collectProjectName(buildElement);
            monitor.worked(5);
            msg = this.collectDeviceAndCore(buildElement);
            if (msg == null) {
                monitor.worked(10);
                msg = CmsisCsolutionPrjAdapter.collectIncludes(buildElement, inclPaths);
            }
            if (msg == null) {
                monitor.worked(10);
                msg = this.collectSources(buildElement, prjSources, inclPaths);
            }
            if (msg == null) {
                monitor.worked(20);
                msg = this.collectComponents(buildElement, componentsInPrjFile, new HashSet<Path>(), new ArrayList<Path>());
            }
            monitor.worked(30);
        } else {
            msg = MessageFormat.format(FAIL_TO_LOAD_ELEMENT_MSG, "build");
        }
        return msg;
    }

    private void collectProjectName(Map<String, Object> buildElement) {
        String context;
        this.detectedProjectName = context = YamlMapValueHelper.getStringValue((String)"context", buildElement);
    }

    private @Nullable String collectDeviceAndCore(Map<String, Object> buildElement) {
        String msg = null;
        String deviceWithCore = YamlMapValueHelper.getStringValue((String)"device", buildElement);
        if (deviceWithCore != null) {
            String convertedDevWithCore;
            int index = deviceWithCore.indexOf("::");
            if (index > 0) {
                deviceWithCore = deviceWithCore.substring(index + 2);
            }
            if (!this.setDetectedPartNumberFromSymbol(convertedDevWithCore = deviceWithCore.replace(':', '_'))) {
                msg = "Processor is not supported or not correctly detected from :" + deviceWithCore;
            }
        } else {
            msg = MessageFormat.format(FAIL_TO_LOAD_ELEMENT_MSG, "device");
        }
        return msg;
    }

    private static @Nullable String collectIncludes(Map<String, Object> buildElement, List<Path> inclPaths) {
        String msg = null;
        List paths = YamlMapValueHelper.getListValue((String)"add-path", buildElement);
        if (paths != null) {
            List pathList = paths.stream().map(string -> Paths.get(string, new String[0])).collect(Collectors.toList());
            inclPaths.addAll(pathList);
        } else {
            msg = MessageFormat.format(FAIL_TO_LOAD_ELEMENT_MSG, "add-path");
        }
        return msg;
    }

    private @Nullable String collectSources(Map<String, Object> buildElement, Set<Path> prjSources, List<Path> inclPaths) {
        String msg = null;
        List groups = YamlMapValueHelper.getListValue((String)"groups", buildElement);
        if (groups != null) {
            for (Map groupItem : groups) {
                this.collectFiles(groupItem, prjSources);
                CmsisCsolutionPrjAdapter.collectIncludes(groupItem, inclPaths);
                this.collectSources(groupItem, prjSources, inclPaths);
            }
        } else {
            msg = MessageFormat.format(FAIL_TO_LOAD_ELEMENT_MSG, "groups");
        }
        List constFiles = YamlMapValueHelper.getListValue((String)"constructed-files", buildElement);
        if (constFiles != null) {
            for (Map constFileItem : constFiles) {
                this.collectFile(constFileItem, prjSources);
            }
        }
        return msg;
    }

    private @Nullable String collectComponents(Map<String, Object> buildElement, Collection<SdkComponentInProject> componentsInPrjFile, Set<Path> prjSources, List<Path> inclPaths) {
        String msg = null;
        List components = YamlMapValueHelper.getListValue((String)"components", buildElement);
        if (components != null) {
            ArrayList<String> parseCompFail = new ArrayList<String>();
            for (Map componentItem : components) {
                String compName = YamlMapValueHelper.getStringValue((String)"component", (Map)componentItem);
                if (compName != null) {
                    CmsisComponentId component = this.getComponentFromComponentName(compName);
                    if (component != null) {
                        SdkComponentInProject comp = this.createSdkComponentInPrj(component);
                        if (comp != null) {
                            componentsInPrjFile.add(comp);
                        }
                    } else {
                        parseCompFail.add(compName);
                    }
                }
                CmsisCsolutionPrjAdapter.collectIncludes(componentItem, inclPaths);
                this.collectFiles(componentItem, prjSources);
            }
            if (!parseCompFail.isEmpty()) {
                msg = "Fail to get component(s):" + CollectionsUtils.formatList(parseCompFail, (String)", ", null);
            }
        } else {
            LOGGER.warning("Fail to load any 'components'");
        }
        return msg;
    }

    @Nullable CmsisComponentId getComponentFromComponentName(String componentName) {
        String cClass;
        @Nullable String cVendor = null;
        String cBundle = null;
        String cSub = null;
        String cVariant = null;
        Version version = null;
        StringBuilder processingName = new StringBuilder(componentName);
        int index = processingName.indexOf("::");
        if (index > 0) {
            cVendor = processingName.substring(0, index);
            processingName.delete(0, index + 2);
        }
        if ((index = processingName.indexOf(":")) < 0) {
            return null;
        }
        int indexAmpersand = processingName.indexOf("&");
        if (indexAmpersand > 0 && indexAmpersand < index) {
            cClass = processingName.substring(0, 1);
            cBundle = processingName.substring(indexAmpersand + 1, index);
        } else {
            cClass = processingName.substring(0, index);
        }
        processingName.delete(0, index + 1);
        int indexColon = processingName.indexOf(":");
        indexAmpersand = processingName.indexOf("&");
        int indexAtSign = processingName.lastIndexOf("@");
        if (indexAtSign > 0) {
            String versionString = processingName.substring(indexAtSign + 1);
            processingName.delete(indexAtSign, processingName.length());
            try {
                version = new Version(versionString);
            }
            catch (IllegalArgumentException e) {
                LOGGER.log(Level.SEVERE, "Fail to get component version:" + e.getMessage(), e);
            }
        }
        if (indexAmpersand > 0) {
            cVariant = processingName.substring(indexAmpersand + 1);
            processingName.delete(indexAmpersand, processingName.length());
        }
        if (indexColon > 0) {
            cSub = processingName.substring(indexColon + 1);
            processingName.delete(indexColon, processingName.length());
        }
        if (processingName.length() < 1) {
            return null;
        }
        @NonNull String cGroup = processingName.toString();
        return version == null || UtilsText.isEmpty((String)cClass) || UtilsText.isEmpty((String)cGroup) ? null : new CmsisComponentId(cBundle, cClass, cGroup, cSub, cVariant, cVendor, version);
    }

    private @Nullable String collectFiles(Map<String, Object> element, Set<Path> prjSources) {
        String msg = null;
        List files = YamlMapValueHelper.getListValue((String)"files", element);
        if (files != null) {
            for (Map fileItem : files) {
                this.collectFile(fileItem, prjSources);
            }
        }
        return msg;
    }

    private @Nullable String collectFile(Map<String, Object> fileItem, Set<Path> prjSources) {
        String msg = null;
        String category = YamlMapValueHelper.getStringValue((String)"category", fileItem);
        if (this.supportedSourceFileCategory.contains(category)) {
            String path = YamlMapValueHelper.getStringValue((String)"file", fileItem);
            prjSources.add(Paths.get(path, new String[0]));
        }
        return msg;
    }
}

