/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.sdkproject.parsers;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.provider.toolchainproject.IToolchainProjectWithSdk;
import com.nxp.swtools.sdkproject.SdkComponentInProject;
import com.nxp.swtools.sdkproject.parsers.GenericEclipsePrjAdapter;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.w3c.dom.Element;

public class CwMcuPrjAdapter
extends GenericEclipsePrjAdapter {
    public static final String REQUIRED_MACRO_SDK = "__CW__";
    public static final String REQUIRED_CW_TEXT_SIMPLE_DETECTION = "com.freescale.dsc.cdt.toolchain";

    CwMcuPrjAdapter(@NonNull File prjFile, @NonNull File prjDir, @NonNull IToolchainProjectWithSdk existingProcessorDetector) {
        super(prjFile, prjDir, existingProcessorDetector);
    }

    @Override
    protected boolean parseCProject(@NonNull Element root, @NonNull List<@NonNull Path> inclPaths, @NonNull Collection<@NonNull SdkComponentInProject> componentsInPrjFile, @NonNull IProgressMonitor monitor) {
        if (!this.isItCwMcuProject(root)) {
            return false;
        }
        monitor.worked(10);
        this.retrieveProcessorFromDefinedSymbols(root);
        monitor.worked(10);
        this.retrieveIncludePath(root, inclPaths);
        monitor.worked(10);
        return true;
    }

    private void retrieveProcessorFromDefinedSymbols(@NonNull Element root) {
        Collection<@NonNull String> symbols = this.getCProjectListOptionValues(root, "com.freescale.dsc.cdt.toolchain.compiler.macros.definedMacros");
        this.retrieveProcessorFromDefinedSymbols(symbols);
    }

    private void retrieveIncludePath(@NonNull Element root, @NonNull List<@NonNull Path> inclPaths) {
        Collection<@NonNull String> inclPathsLoc = this.getCProjectListOptionValues(root, "com.freescale.dsc.cdt.toolchain.compiler.input.include");
        for (String inclRelPath : inclPathsLoc) {
            if (inclRelPath.startsWith("\"") && inclRelPath.endsWith("\"") && inclRelPath.length() > 1) {
                inclRelPath = inclRelPath.substring(1, inclRelPath.length() - 1);
            }
            inclRelPath = CwMcuPrjAdapter.resolveVarible(inclRelPath, "ProjDirPath", this.prjPath.toString());
            inclPaths.add(Paths.get(inclRelPath, new String[0]));
        }
    }

    private static String resolveVarible(String textWithVars, String variable, String variableValue) {
        return textWithVars.replace("${" + variable + "}", variableValue);
    }

    private boolean isItCwMcuProject(@NonNull Element root) {
        return this.getCProjectListOptionValues(root, "com.freescale.dsc.cdt.toolchain.compiler.macros.definedMacros").contains(REQUIRED_MACRO_SDK);
    }

    @Override
    public @Nullable String getToolchainId() {
        return "cwmcu";
    }

    @Override
    public @Nullable String getToolchainName() {
        return "Code Warrior for MCUs";
    }
}

