/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.sdkproject.parsers;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.version.VersionUtils;
import com.nxp.swtools.expert.processordb.IProcessorMasterToolInfo;
import com.nxp.swtools.expert.processordb.SupportedDerivativesForSwTools;
import com.nxp.swtools.expert.processordb.sdkcomponents.CmsisComponentId;
import com.nxp.swtools.expert.processordb.sdkcomponents.SdkComponentsTable;
import com.nxp.swtools.expert.processordb.sdkcomponents.SupportedSdkComponent;
import com.nxp.swtools.provider.toolchainproject.IToolchainProjectWithSdk;
import com.nxp.swtools.sdkproject.SdkComponentInProject;
import com.nxp.swtools.sdkproject.parsers.GenericPrjAdapterWithParser;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import org.osgi.framework.Version;

abstract class GenericPrjAdapterWithCmsisParser
extends GenericPrjAdapterWithParser {
    GenericPrjAdapterWithCmsisParser(@NonNull File prjFile, @NonNull File prjDir, @NonNull IToolchainProjectWithSdk existingProcessorDetector) {
        super(prjFile, prjDir, existingProcessorDetector);
    }

    protected @Nullable SdkComponentInProject createSdkComponentInPrj(@NonNull CmsisComponentId cmsisCompId) {
        IProcessorMasterToolInfo processorInfo = this.getProcessorInfo();
        if (processorInfo == null) {
            return null;
        }
        SdkComponentsTable supportedComps = SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools().getSdkComponentsTable(processorInfo);
        if (supportedComps == null) {
            return null;
        }
        List suComps = supportedComps.findByCmsisId(cmsisCompId).collect(Collectors.toList());
        SupportedSdkComponent suppComp = null;
        Version cmsCompVersion = cmsisCompId.getVersion();
        for (SupportedSdkComponent sCom : suComps) {
            Version sVersion = sCom.getVersion();
            if (VersionUtils.perfect((Version)sVersion, (Version)cmsCompVersion)) {
                suppComp = sCom;
                break;
            }
            if (!VersionUtils.compatible((Version)cmsCompVersion, (Version)sVersion)) continue;
            suppComp = sCom;
        }
        if (suComps.size() > 0 && suppComp == null) {
            LOGGER.severe(String.format("[SDK/DATA] CMSIS component '%s' from the project not found in given version in SDK component xml: %s", cmsisCompId.toString(), CollectionsUtils.formatList(suComps, (String)"; ", c -> String.valueOf(c.toString()) + ":" + c.getVersionStr())));
        }
        if (suppComp != null) {
            return new SdkComponentInProject(suppComp.getId(), cmsisCompId.getVersionStr());
        }
        if ("NXP".equals(cmsisCompId.getCVendor()) && "SDK Drivers".equals(cmsisCompId.getCGroup())) {
            LOGGER.warning("[SDK] CMSIS component from project not found: " + cmsisCompId.toString());
        }
        return null;
    }
}

