/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cdt.core.errorParsers;

import com.freescale.s32ds.cdt.core.errorParsers.Messages;
import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.cdt.core.IErrorParser;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public abstract class CommonErrorParser
implements IErrorParser {
    public boolean parseStandardErrorOutput(String line, Message message) {
        int index = line.indexOf(91);
        if (index == -1) {
            return false;
        }
        String subString = line.substring(index + 1);
        if ((index = subString.indexOf(44)) == -1) {
            return false;
        }
        message.tool = subString.substring(0, index);
        message.tool = message.tool.trim();
        if ((index = (subString = subString.substring(index + 1)).indexOf(44)) == -1) {
            return false;
        }
        String severityStr = subString.substring(0, index);
        message.severity = Integer.parseInt(severityStr.trim());
        if ((index = (subString = subString.substring(index + 1)).indexOf(44)) == -1) {
            return false;
        }
        String errorStr = subString.substring(0, index);
        message.errorNumber = Integer.parseInt(errorStr.trim());
        if ((subString = subString.substring(index + 1)).startsWith("-1")) {
            message.lineNumber = -1;
            index = subString.indexOf(93);
            if (index == -1) {
                return false;
            }
        } else {
            index = subString.indexOf(44);
            if (index != -1) {
                String lineStr = subString.substring(0, index);
                message.lineNumber = Integer.parseInt(lineStr.trim());
                if ((index = (subString = subString.substring(index + 1)).indexOf(93)) == -1) {
                    return false;
                }
                message.filePath = subString.substring(0, index);
                message.filePath = message.filePath.trim();
            } else {
                index = subString.indexOf(93);
                if (index == -1) {
                    return false;
                }
            }
        }
        if ((index = (subString = subString.substring(index + 1)).indexOf(58)) == -1) {
            return false;
        }
        message.setDescription(subString.substring(index + 1).trim());
        return true;
    }

    public static class Message {
        public String tool;
        public int severity;
        public int errorNumber;
        public int lineNumber;
        public String filePath = "";
        private String description = "";
        private String alternateDescription = "";
        public int pendingAdditionalInput = 0;

        public boolean isEmpty() {
            return !(this.description != null && this.description.length() != 0 || this.alternateDescription != null && this.alternateDescription.length() != 0);
        }

        public String getDescription() {
            if (this.description == null || this.description.length() == 0) {
                return this.alternateDescription;
            }
            return this.description;
        }

        public int getMarkerSeverity() {
            switch (this.severity) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 1;
                }
            }
            return 2;
        }

        public IPath getExternalFile() {
            return new Path(this.filePath);
        }

        public IFile getFile(ErrorParserManager eoParser) {
            Path path;
            if (this.filePath.equals("")) {
                return null;
            }
            IFile file = eoParser.findFilePath(this.filePath);
            if (file == null) {
                file = eoParser.findFileName(this.filePath);
            }
            if (file == null && (path = new Path(this.filePath)).segmentCount() > 1) {
                String name = path.lastSegment();
                file = eoParser.findFileName(this.filePath);
                if (file != null && eoParser.isConflictingName(this.filePath)) {
                    this.description = Messages.getString("CommonErrorParser_0", new Object[]{name, this.description});
                    file = null;
                }
            }
            return file;
        }

        public boolean isComplete() {
            return this.description.length() > 0 && this.pendingAdditionalInput == 0;
        }

        public void setDescription(String description) {
            this.description = description;
            if (description.endsWith("from:")) {
                ++this.pendingAdditionalInput;
            }
        }

        public void appendDescription(String msg) {
            if (msg != null) {
                if (this.description.length() == 0) {
                    this.description = msg;
                } else {
                    if (!msg.startsWith(" ")) {
                        this.description = String.valueOf(this.description) + " ";
                    }
                    this.description = String.valueOf(this.description) + msg;
                }
            }
        }

        public void appendAlternateDescription(String msg) {
            if (msg != null) {
                if (this.alternateDescription.length() == 0) {
                    this.alternateDescription = msg;
                } else {
                    if (!msg.startsWith(" ")) {
                        this.alternateDescription = String.valueOf(this.alternateDescription) + " ";
                    }
                    this.alternateDescription = String.valueOf(this.alternateDescription) + msg;
                }
            }
        }
    }
}

