/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.hardware.internal.debugger.core;

import com.nxp.s32ds.cle.runtime.hardware.debugger.DebuggerCondition;
import com.nxp.s32ds.cle.runtime.hardware.debugger.HardwareDebuggerDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.debugger.core.DebuggerConditionContributor;
import com.nxp.s32ds.cle.runtime.hardware.internal.debugger.core.DebuggerConditionImpl;
import com.nxp.s32ds.cle.runtime.hardware.internal.debugger.core.HardwareDebuggerCoreActivator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

public class HardwareDebuggerDescriptorImpl
implements HardwareDebuggerDescriptor {
    private String device;
    private String family;
    private Map<String, List<DebuggerCondition>> debuggerConditions = new HashMap<String, List<DebuggerCondition>>();
    private Map<String, Integer> debuggerRanks = new HashMap<String, Integer>();
    public static final int DEFAULT_RANK_VALUE = 5;

    public HardwareDebuggerDescriptorImpl(IConfigurationElement configuarationElement) {
        this.device = configuarationElement.getAttribute("device");
        this.family = configuarationElement.getAttribute("family");
        IConfigurationElement[] iConfigurationElementArray = configuarationElement.getChildren("debugger");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement debuggerElements = iConfigurationElementArray[n2];
            String debugger = debuggerElements.getAttribute("id");
            this.debuggerRanks.put(debugger, this.getRank(debuggerElements));
            IConfigurationElement[] iConfigurationElementArray2 = debuggerElements.getChildren("conditions");
            int n3 = iConfigurationElementArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement conditionsElements = iConfigurationElementArray2[n4];
                String conditionByToolChain = HardwareDebuggerDescriptorImpl.getAttributeByElement(conditionsElements, "toolchainCondition", "toolchain");
                String conditionByHardware = HardwareDebuggerDescriptorImpl.getAttributeByElement(conditionsElements, "coreCondition", "core");
                String conditionByPlatform = HardwareDebuggerDescriptorImpl.getAttributeByElement(conditionsElements, "platformCondition", "platform");
                String conditionByRevision = HardwareDebuggerDescriptorImpl.getAttributeByElement(conditionsElements, "revisionCondition", "revision");
                String conditionByDeviceCore = HardwareDebuggerDescriptorImpl.getAttributeByElement(conditionsElements, "deviceCoreCondition", "deviceCore");
                String pluginIdCondition = HardwareDebuggerDescriptorImpl.getAttributeByElement(conditionsElements, "pluginCondition", "pluginId");
                DebuggerConditionContributor contributedCondition = null;
                try {
                    Object executableExtension = HardwareDebuggerDescriptorImpl.getExecutableByElement(conditionsElements, "conditionContributor", "contributor");
                    if (executableExtension instanceof DebuggerConditionContributor) {
                        contributedCondition = (DebuggerConditionContributor)executableExtension;
                    }
                }
                catch (CoreException e) {
                    HardwareDebuggerCoreActivator.getInstance().log(e.getStatus());
                }
                DebuggerConditionImpl condition = new DebuggerConditionImpl(conditionByHardware, conditionByToolChain, conditionByPlatform, conditionByRevision, conditionByDeviceCore, contributedCondition, pluginIdCondition);
                List<DebuggerCondition> conditions = this.debuggerConditions.get(debugger);
                if (conditions == null) {
                    conditions = new ArrayList<DebuggerCondition>();
                }
                conditions.add(condition);
                this.debuggerConditions.put(debugger, conditions);
                ++n4;
            }
            ++n2;
        }
    }

    private static String getAttributeByElement(IConfigurationElement configuration, String element, String attribute) {
        IConfigurationElement[] children = configuration.getChildren(element);
        if (children.length > 0) {
            return children[0].getAttribute(attribute);
        }
        return "";
    }

    private static Object getExecutableByElement(IConfigurationElement configuration, String element, String attribute) throws CoreException {
        IConfigurationElement[] children = configuration.getChildren(element);
        if (children.length > 0) {
            return children[0].createExecutableExtension(attribute);
        }
        return null;
    }

    public String getDevice() {
        return this.device != null ? this.device : "";
    }

    public String getFamily() {
        return this.family != null ? this.family : "";
    }

    public List<DebuggerCondition> getConditionsByDebugger(String debugger) {
        return this.debuggerConditions.get(debugger);
    }

    public Map<String, List<DebuggerCondition>> getDebuggersConditions() {
        return this.debuggerConditions;
    }

    public Map<String, Integer> getDebuggersRanks() {
        return this.debuggerRanks;
    }

    private int getRank(IConfigurationElement debuggerElements) {
        String rank = debuggerElements.getAttribute("rank");
        if (rank == null || rank.isEmpty()) {
            return 5;
        }
        try {
            return Integer.parseInt(rank);
        }
        catch (NumberFormatException numberFormatException) {
            return 5;
        }
    }
}

