/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.uct.ui.types;

import com.nxp.s32ds.cle.uct.ui.types.WrapperType;
import java.util.ArrayList;
import java.util.List;

public class Category {
    private String name;
    private List<Category> children = new ArrayList<Category>();
    private List<WrapperType> items = new ArrayList<WrapperType>();
    private Category parent;

    public String getName() {
        return this.name;
    }

    public List<Category> getChildren() {
        return this.children;
    }

    public Category getParent() {
        return this.parent;
    }

    public void setParent(Category parent) {
        this.parent = parent;
    }

    public void setName(String name) {
        this.name = name;
    }

    public synchronized List<WrapperType> getItems() {
        return this.items;
    }

    public boolean isExternal() {
        for (WrapperType item : this.items) {
            if (!item.isExternal()) continue;
            return true;
        }
        if (this.name != null && !this.name.isEmpty()) {
            for (Category child : this.children) {
                if (!child.isExternal()) continue;
                return true;
            }
        }
        return false;
    }

    public WrapperType getFirstElement() {
        if (this.items.isEmpty()) {
            for (Category category : this.children) {
                WrapperType first = category.getFirstElement();
                if (first == null) continue;
                return first;
            }
            return null;
        }
        return this.items.get(0);
    }

    public int hashCode() {
        if (this.name != null) {
            return this.name.hashCode();
        }
        return this.getChildren().hashCode() + this.getItems().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Category && ((Category)obj).getName() != null) {
            Category cat = (Category)obj;
            boolean equals = cat.getName().equals(this.name);
            return equals;
        }
        return super.equals(obj);
    }

    public String toString() {
        return this.name;
    }
}

