/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.svd.internal.registry;

import com.nxp.s32ds.cle.runtime.svd.internal.registry.SvdRegistryActivator;
import com.nxp.s32ds.cle.runtime.svd.registry.SvdDescriptor;
import com.nxp.s32ds.cle.runtime.svd.registry.SvdRegistry;
import com.nxp.s32ds.ext.rcp.registry.BaseRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class SvdRegistryImplementation
extends BaseRegistry
implements SvdRegistry {
    private static final String DUPLICATED_INSTANCE_ERROR = "The duplicated descriptor <%s> find with arguments: deviceId <%s>, coreId <%s>";
    private static final String HARDWARE_ATTRIBUTES_ERROR = "The descriptor <%s> does not contain required hardware attributes";
    private static final String BUNDLE_ID = "com.nxp.s32ds.cle.runtime.svd.registry";
    private final Map<String, SvdDescriptor> svdDescriptors = new HashMap<String, SvdDescriptor>();

    @Override
    public List<SvdDescriptor> getSvdDescriptors() {
        return new ArrayList<SvdDescriptor>(this.svdDescriptors.values());
    }

    @Override
    public void addSvdDescriptor(SvdDescriptor descriptor) {
        if (descriptor == null) {
            return;
        }
        IStatus status = this.validate(descriptor);
        if (status.isOK()) {
            this.addEntityDescriptor(descriptor, this.svdDescriptors, SvdDescriptor.class);
        } else {
            SvdRegistryActivator.getInstance().log(status);
        }
    }

    private IStatus validate(SvdDescriptor descriptor) {
        if ((descriptor.getDeviceId() == null || descriptor.getDeviceId().isEmpty()) && (descriptor.getCoreId() == null || descriptor.getCoreId().isEmpty())) {
            String msg = String.format(HARDWARE_ATTRIBUTES_ERROR, descriptor.getId());
            return new Status(4, BUNDLE_ID, msg);
        }
        for (SvdDescriptor entry : this.svdDescriptors.values()) {
            if (!entry.getDeviceId().equals(descriptor.getDeviceId()) || !entry.getCoreId().equals(descriptor.getCoreId())) continue;
            String msg = String.format(DUPLICATED_INSTANCE_ERROR, descriptor.getId(), descriptor.getDeviceId(), descriptor.getCoreId());
            return new Status(4, BUNDLE_ID, msg);
        }
        return Status.OK_STATUS;
    }

    @Override
    public void removeSvdDescriptor(SvdDescriptor descriptor) {
        this.removeEntityDescriptor(descriptor, this.svdDescriptors, SvdDescriptor.class);
    }

    @Override
    public SvdDescriptor getSvdDescriptor(String svdId) {
        return this.svdDescriptors.get(svdId);
    }
}

