/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.configuration.storage.gtm;

import com.nxp.swtools.common.utils.NonNullByDefault;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.provider.configuration.storage.gtm.StorageGtmSetting;
import java.util.ArrayList;
import java.util.Objects;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;

@NonNullByDefault
@Root(name="gtm_container", strict=false)
public class StorageGtmContainer {
    @Attribute(name="id")
    private String id;
    @ElementList(name="settings", entry="setting", empty=false, required=false)
    private ArrayList<StorageGtmSetting> settings = new ArrayList();
    @ElementList(name="child_containers", required=false)
    private ArrayList<StorageGtmContainer> childContainers = new ArrayList();

    public StorageGtmContainer() {
        this.id = "";
        this.settings = new ArrayList();
        this.childContainers = new ArrayList();
    }

    public StorageGtmContainer(String name, ArrayList<StorageGtmSetting> settings, ArrayList<StorageGtmContainer> childContainers) {
        this.id = name;
        this.settings = settings;
        this.childContainers = childContainers;
    }

    public String getId() {
        return this.id;
    }

    public ArrayList<StorageGtmSetting> getSettings() {
        return this.settings;
    }

    public ArrayList<StorageGtmContainer> getChildContainers() {
        return this.childContainers;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setSettings(ArrayList<StorageGtmSetting> settings) {
        this.settings = settings;
    }

    public void setChildContainers(ArrayList<StorageGtmContainer> childContainers) {
        this.childContainers = childContainers;
    }

    public @Nullable StorageGtmContainer getChildContainerById(String containerId) {
        for (StorageGtmContainer container : this.childContainers) {
            if (!container.getId().equals(containerId)) continue;
            return container;
        }
        return null;
    }

    public @Nullable StorageGtmSetting getSettingById(String settingId) {
        for (StorageGtmSetting setting : this.settings) {
            if (!setting.getId().equals(settingId)) continue;
            return setting;
        }
        return null;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.settings, this.childContainers);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StorageGtmContainer other = (StorageGtmContainer)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.settings, other.settings) && Objects.equals(this.childContainers, other.childContainers);
    }
}

