/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.configuration.storage.periphs;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.provider.configuration.storage.periphs.AStoragePeriphsComponent;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsConfigSet;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;

@Root(strict=false, name="instance")
public class StoragePeriphsComponentInstance
extends AStoragePeriphsComponent {
    @Attribute(name="type")
    @NonNull
    private @Attribute(name="type") @NonNull String type = "";
    @Attribute(name="type_id", required=false)
    @NonNull
    private @Attribute(name="type_id", required=false) @NonNull String type_id = "";
    @Attribute(name="mode")
    @NonNull
    private @Attribute(name="mode") @NonNull String mode = "";
    @Attribute(name="peripheral", required=false)
    @Nullable
    private @Attribute(name="peripheral", required=false) @Nullable String peripheral = null;
    @ElementList(name="config_sets", inline=true, required=false)
    @NonNull
    private @ElementList(name="config_sets", inline=true, required=false) @NonNull CopyOnWriteArrayList<@NonNull StoragePeriphsConfigSet> config_sets = new CopyOnWriteArrayList();
    @Attribute(name="enabled", required=false)
    private boolean enabled = true;
    @Attribute(name="comment", required=false)
    @NonNull
    private @Attribute(name="comment", required=false) @NonNull String comment = "";
    @Attribute(name="custom_name_enabled", required=false)
    private boolean customNameEnabled = true;
    @Attribute(name="editing_lock", required=false)
    private boolean editingLocked = false;
    @Attribute(name="from_use_case", required=false)
    @Nullable
    private @Attribute(name="from_use_case", required=false) @Nullable String fromUseCase;

    public StoragePeriphsComponentInstance() {
    }

    public StoragePeriphsComponentInstance(@NonNull StoragePeriphsComponentInstance original) {
        this.setEnabled(original.enabled);
        this.setMode(original.getMode());
        this.setName(original.getName());
        this.setUUID(original.getUUID());
        this.setCustomNameEnabled(original.isCustomName());
        this.setPeripheral(original.getPeripheral());
        this.setType(original.getType());
        this.setType_id(original.getType_id());
        this.setOriginalUseCase(original.getOriginalUseCase());
        CopyOnWriteArrayList<@NonNull StoragePeriphsConfigSet> configSets = new CopyOnWriteArrayList<StoragePeriphsConfigSet>();
        for (StoragePeriphsConfigSet configSet : original.getConfig_sets()) {
            StoragePeriphsConfigSet newConfigSet = new StoragePeriphsConfigSet(configSet);
            configSets.add(newConfigSet);
        }
        this.setConfig_sets(configSets);
    }

    public @NonNull String getMode() {
        return this.mode;
    }

    public void setMode(@NonNull String mode) {
        this.mode = mode;
    }

    public @Nullable String getPeripheral() {
        return this.peripheral;
    }

    public void setPeripheral(@Nullable String peripheral) {
        this.peripheral = peripheral;
    }

    public @NonNull CopyOnWriteArrayList<@NonNull StoragePeriphsConfigSet> getConfig_sets() {
        return this.config_sets;
    }

    public void setConfig_sets(@NonNull CopyOnWriteArrayList<@NonNull StoragePeriphsConfigSet> config_sets) {
        this.config_sets = config_sets;
    }

    public @NonNull String getType() {
        return this.type;
    }

    public void setType(@NonNull String type) {
        this.type = type;
    }

    public @NonNull String getComment() {
        return this.comment.replaceAll("\\\\n", "\n");
    }

    public void setComment(@NonNull String comment) {
        String escaped;
        this.comment = escaped = comment.replaceAll("\\r\\n|\\n", "\\\\n");
    }

    public boolean isCustomName() {
        return this.customNameEnabled;
    }

    public void setCustomNameEnabled(boolean isCustomName) {
        this.customNameEnabled = isCustomName;
    }

    public void setEditingLockState(boolean state) {
        this.editingLocked = state;
    }

    public boolean isEditingLocked() {
        return this.editingLocked;
    }

    public @NonNull String getType_id() {
        return this.type_id;
    }

    public void setType_id(@NonNull String type_id) {
        this.type_id = type_id;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public @Nullable String getOriginalUseCase() {
        return this.fromUseCase;
    }

    public void setOriginalUseCase(@Nullable String useCaseName) {
        this.fromUseCase = useCaseName;
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.type_id.hashCode();
        result = 31 * result + this.config_sets.hashCode();
        result = 31 * result + this.mode.hashCode();
        result = 31 * result + Objects.hashCode(this.fromUseCase);
        result = 31 * result + super.hashCode();
        result = 31 * result + Boolean.hashCode(this.enabled);
        result = 31 * result + Objects.hashCode(this.comment);
        result = 31 * result + Boolean.hashCode(this.customNameEnabled);
        result = 31 * result + Boolean.hashCode(this.editingLocked);
        result = 31 * result + (this.peripheral != null ? this.peripheral.hashCode() : 0);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StoragePeriphsComponentInstance other = (StoragePeriphsComponentInstance)obj;
        if (!this.type.equals(other.type)) {
            return false;
        }
        if (!this.type_id.equals(other.type_id)) {
            return false;
        }
        if (!this.config_sets.equals(other.config_sets)) {
            return false;
        }
        if (!this.mode.equals(other.mode)) {
            return false;
        }
        if (!Objects.equals(this.fromUseCase, other.fromUseCase)) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        if (this.enabled != other.enabled) {
            return false;
        }
        if (this.peripheral == null ? other.peripheral != null : !Objects.equals(this.peripheral, other.peripheral)) {
            return false;
        }
        if (!Objects.equals(other.comment, this.comment)) {
            return false;
        }
        if (other.editingLocked != this.editingLocked) {
            return false;
        }
        return other.customNameEnabled == this.customNameEnabled;
    }

    public @NonNull String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[" + "TypeId: " + this.type_id + ", Type: " + this.type + ", Mode: " + this.mode + ", Peripheral: " + this.peripheral + ", ConfigSets: " + this.config_sets + ", Enabled: " + this.enabled + ", Comment: " + this.comment + ", Custom: " + this.customNameEnabled + ", FromUseCase: " + (this.fromUseCase != null ? this.fromUseCase : "") + "]";
    }
}

