/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.configuration.storage.pins;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.NonNullByDefault;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.provider.configuration.storage.pins.StorageBoardCodeIdentifiers;
import com.nxp.swtools.provider.configuration.storage.pins.StorageBoardHeaderConnection;
import com.nxp.swtools.provider.configuration.storage.pins.StorageExpansionHeader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;

@NonNullByDefault
@Root(strict=false, name="expansion_board")
public class StorageExpansionBoard {
    @Attribute(name="id", required=true)
    protected String id;
    @Attribute(name="name", required=true)
    protected String name;
    @Attribute(name="compatibilityAdapter", required=false)
    @Nullable
    private @Attribute(name="compatibilityAdapter", required=false) @Nullable String compatibilityAdapter = null;
    @Element(name="header_connection", required=true)
    protected StorageBoardHeaderConnection headerConnection;
    @Element(name="code_identifiers", required=true)
    protected StorageBoardCodeIdentifiers codeIdentifiers;
    @ElementList(name="expansion_headers", entry="expansion_header", required=false)
    @Nullable
    protected @ElementList(name="expansion_headers", entry="expansion_header", required=false) @Nullable ArrayList<@NonNull StorageExpansionHeader> expansionHeaders = null;

    protected StorageExpansionBoard() {
        this("", "");
    }

    public StorageExpansionBoard(String id, String name) {
        this.id = id;
        this.name = name;
        this.headerConnection = new StorageBoardHeaderConnection();
        this.codeIdentifiers = new StorageBoardCodeIdentifiers();
    }

    public StorageExpansionBoard(String id, String name, StorageBoardHeaderConnection headerConnection, StorageBoardCodeIdentifiers codeIdentifiers, @Nullable ArrayList<@NonNull StorageExpansionHeader> expansionHeaders) {
        this.id = id;
        this.name = name;
        this.headerConnection = headerConnection;
        this.codeIdentifiers = codeIdentifiers;
        this.expansionHeaders = expansionHeaders;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isCompatibilityAdapter() {
        return "true".equalsIgnoreCase(this.compatibilityAdapter);
    }

    public StorageBoardHeaderConnection getHeaderConnection() {
        return this.headerConnection;
    }

    public void setHeaderConnection(StorageBoardHeaderConnection headerConnection) {
        this.headerConnection = headerConnection;
    }

    public StorageBoardCodeIdentifiers getCodeIdentifiers() {
        return this.codeIdentifiers;
    }

    public void setCodeIdentifiers(StorageBoardCodeIdentifiers codeIdentifiers) {
        this.codeIdentifiers = codeIdentifiers;
    }

    public List<@NonNull StorageExpansionHeader> getExpansionHeaders() {
        if (this.expansionHeaders == null) {
            return Collections.emptyList();
        }
        assert (this.expansionHeaders != null);
        return this.expansionHeaders;
    }

    public void setExpansionHeaders(@Nullable List<@NonNull StorageExpansionHeader> expansionHeadersList) {
        this.expansionHeaders = expansionHeadersList == null ? null : new ArrayList<StorageExpansionHeader>(expansionHeadersList);
    }

    public String toString() {
        return "StorageExpansionBoard [id=" + this.id + ", name=" + this.name + "]";
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StorageExpansionBoard other = (StorageExpansionBoard)obj;
        if (!this.id.equals(other.id)) {
            return false;
        }
        return this.name.equals(other.name);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.id.hashCode();
        result = 31 * result + this.name.hashCode();
        return result;
    }
}

