/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.configuration.storage.tee;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionMap;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.yaml.IYamlStorable;
import com.nxp.swtools.common.utils.yaml.YamlStorableHelper;
import com.nxp.swtools.common.utils.yaml.YamlStorableList;
import com.nxp.swtools.provider.configuration.storage.tee.AStorageTeeGenericRdcCheckerConfig;
import com.nxp.swtools.provider.configuration.storage.tee.ISlavesStorage;
import com.nxp.swtools.provider.configuration.storage.tee.StorageTeeCheckerMemorySlaveConfig;
import com.nxp.swtools.provider.configuration.storage.tee.StorageTeeCheckerSlaveConfig;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;

public abstract class AStorageTeeGenericRdcSectorsConfig<T extends StorageTeeCheckerMemorySlaveConfig>
extends AStorageTeeGenericRdcCheckerConfig
implements ISlavesStorage<T> {
    protected abstract T createSlaveStorage();

    public @Nullable T findSlave(@Nullable String id, @Nullable BigInteger regionStart, @Nullable BigInteger regionSize) {
        if (id != null) {
            List slaves = this.getSlaves();
            for (StorageTeeCheckerMemorySlaveConfig slave : slaves) {
                if (!Objects.equals(slave.getSlaveId(), id) || slave.getMemRegion() != null && (!Objects.equals(regionStart, slave.getMemRegionStart()) || !Objects.equals(regionSize, slave.getMemRegionSize()))) continue;
                return (T)slave;
            }
        }
        return null;
    }

    public CollectionMap<String, T> getSlaveStoragesBySlave() {
        CollectionMap result = new CollectionMap(HashMap.class, ArrayList.class);
        for (StorageTeeCheckerMemorySlaveConfig slaveConfig : this.getSlaves()) {
            String slaveId = slaveConfig.getSlaveId();
            if (slaveId == null) continue;
            result.add((Object)slaveId, (Object)slaveConfig);
        }
        return result;
    }

    @Override
    protected void addUnderlyingYaml(List<IYamlStorable> storable) {
        List slavesLoc = this.getSlaves();
        YamlStorableList slavesYaml = new YamlStorableList("slaves", Boolean.TRUE);
        slavesYaml.setForceSequence(true);
        slavesLoc.forEach(each -> each.fillYamlStorable((IYamlStorable)slavesYaml));
        storable.add((IYamlStorable)slavesYaml);
    }

    @Override
    protected boolean updatePropertyFromYaml(IYamlStorable yaml) {
        if (yaml.getYamlId().equals("slaves")) {
            ArrayList<T> slavesFromYaml = new ArrayList<T>();
            for (IYamlStorable slaveYaml : CollectionsUtils.safeCollection((Collection)yaml.getYamlChildren())) {
                T fromYaml;
                if (slaveYaml instanceof YamlStorableList) {
                    slaveYaml = YamlStorableHelper.skipMapLayer((YamlStorableList)((YamlStorableList)slaveYaml), (String)"slave");
                }
                if (!((StorageTeeCheckerSlaveConfig)(fromYaml = this.createSlaveStorage())).updateFromYamlStorable(slaveYaml)) continue;
                slavesFromYaml.add(fromYaml);
            }
            this.setSlaves(slavesFromYaml);
            return true;
        }
        return super.updatePropertyFromYaml(yaml);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.getSlaves().size();
        return result;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AStorageTeeGenericRdcSectorsConfig other = (AStorageTeeGenericRdcSectorsConfig)obj;
        return Objects.equals(this.getSlaves(), other.getSlaves());
    }

    @Override
    public String toString() {
        List slaves = this.getSlaves();
        return String.format("%s [%s, using_global_templates=%s, slaves=%s]", AStorageTeeGenericRdcSectorsConfig.class.getSimpleName(), super.toString(), this.usingGlobalTemplates, slaves.subList(0, Math.min(slaves.size(), 3)));
    }
}

