/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.configuration.storage.tee;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.provider.configuration.storage.tee.MaskedFlag;

public enum SecureFlag {
    SECURE("Secure"),
    NON_SECURE("Non-secure");

    private final String name;

    private SecureFlag(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static @Nullable SecureFlag byName(String name) {
        SecureFlag[] secureFlagArray = SecureFlag.values();
        int n = secureFlagArray.length;
        int n2 = 0;
        while (n2 < n) {
            SecureFlag secureFlag = secureFlagArray[n2];
            if (secureFlag.name.equals(name)) {
                return secureFlag;
            }
            ++n2;
        }
        return null;
    }

    public static SecureFlag byMasked(MaskedFlag maskedFlag) {
        switch (maskedFlag) {
            case MASKED: {
                return SECURE;
            }
            case NON_MASKED: {
                return NON_SECURE;
            }
        }
        throw new IllegalStateException("Unknown masked flag: " + maskedFlag.getName());
    }

    public MaskedFlag toMaskedFlag() {
        switch (this) {
            case SECURE: {
                return MaskedFlag.MASKED;
            }
            case NON_SECURE: {
                return MaskedFlag.NON_MASKED;
            }
        }
        throw new IllegalStateException("Unknown secure flag: " + this.getName());
    }
}

