/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.configuration.storage.tee;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.yaml.IYamlStorable;
import com.nxp.swtools.common.utils.yaml.YamlStorableValue;
import com.nxp.swtools.provider.configuration.storage.tee.StorageTeeLockableMemoryRegionConfig;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Root;

@Root(strict=false, name="region")
public class StorageTeeApuRegion
extends StorageTeeLockableMemoryRegionConfig {
    @Attribute(name="encrypt_enabled", required=true)
    private boolean encryptEnabled;

    public StorageTeeApuRegion() {
    }

    public StorageTeeApuRegion(BigInteger start, BigInteger size, int index, boolean locked, boolean encryptEnabled) {
        super(start, size, index, locked);
        this.encryptEnabled = encryptEnabled;
    }

    public boolean isEncryptEnabled() {
        return this.encryptEnabled;
    }

    public void setEncryptEnabled(boolean encryptEnabled) {
        this.encryptEnabled = encryptEnabled;
    }

    @Override
    protected List<IYamlStorable> createYamlStorable() {
        ArrayList<IYamlStorable> storable = new ArrayList<IYamlStorable>();
        storable.add((IYamlStorable)new YamlStorableValue("encrypt_enabled", Boolean.toString(this.isEncryptEnabled())));
        storable.addAll(super.createYamlStorable());
        return storable;
    }

    @Override
    protected boolean loadYamlConvertible(Collection<IYamlStorable> children) {
        if (!super.loadYamlConvertible(children)) {
            return false;
        }
        boolean encryptEnabledLoc = false;
        for (IYamlStorable childYaml : children) {
            if (!(childYaml instanceof YamlStorableValue) || !childYaml.getYamlId().equals("encrypt_enabled")) continue;
            encryptEnabledLoc = Boolean.parseBoolean(childYaml.getYamlValue());
        }
        this.setEncryptEnabled(encryptEnabledLoc);
        return true;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.encryptEnabled);
        return result;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        StorageTeeApuRegion other = Objects.requireNonNull((StorageTeeApuRegion)obj);
        return this.encryptEnabled == other.encryptEnabled;
    }
}

