/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.configuration.storage.tee;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.yaml.IYamlStorable;
import com.nxp.swtools.common.utils.yaml.YamlStorableValue;
import com.nxp.swtools.provider.configuration.storage.tee.StorageTeeMemoryRegionConfig;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Root;

@Root(strict=false, name="region")
public class StorageTeeDisableableMemoryRegionConfig
extends StorageTeeMemoryRegionConfig {
    protected static final String ENABLED_ID = "enabled";
    protected static final String CODE_REGION_ID = "code_region";
    protected static final String EAL_ID = "eal";
    @Attribute(name="enabled", required=true)
    private boolean enabled;
    @Attribute(name="code_region", required=false)
    @Nullable
    @Attribute(name="code_region", required=false) @Nullable Boolean codeRegionEnabled;
    @Attribute(name="eal", required=false)
    @Nullable
    @Attribute(name="eal", required=false) @Nullable String eal = null;
    @Attribute(name="index", required=true)
    private int index;
    static final String INDEX_ID = "index";

    public StorageTeeDisableableMemoryRegionConfig() {
    }

    @Override
    protected List<IYamlStorable> createYamlStorable() {
        String ealLoc;
        ArrayList<IYamlStorable> storable = new ArrayList<IYamlStorable>();
        storable.add((IYamlStorable)new YamlStorableValue(INDEX_ID, Integer.toString(this.getIndex())));
        storable.add((IYamlStorable)new YamlStorableValue(ENABLED_ID, Boolean.toString(this.isEnabled())));
        Boolean codeRegionLoc = this.codeRegionEnabled;
        if (codeRegionLoc != null) {
            storable.add((IYamlStorable)new YamlStorableValue(CODE_REGION_ID, codeRegionLoc.toString()));
        }
        if ((ealLoc = this.eal) != null) {
            storable.add((IYamlStorable)new YamlStorableValue(EAL_ID, ealLoc));
        }
        storable.addAll(super.createYamlStorable());
        return storable;
    }

    @Override
    protected boolean loadYamlConvertible(Collection<IYamlStorable> children) {
        if (!super.loadYamlConvertible(children)) {
            return false;
        }
        Boolean codeRegionLoc = null;
        String ealLoc = null;
        boolean enabledLoc = false;
        int indexLoc = 0;
        for (IYamlStorable childYaml : children) {
            if (!(childYaml instanceof YamlStorableValue)) continue;
            if (childYaml.getYamlId().equals(INDEX_ID)) {
                indexLoc = Integer.parseInt(childYaml.getYamlValue());
                continue;
            }
            if (childYaml.getYamlId().equals(ENABLED_ID)) {
                enabledLoc = Boolean.parseBoolean(childYaml.getYamlValue());
                continue;
            }
            if (childYaml.getYamlId().equals(CODE_REGION_ID)) {
                codeRegionLoc = Boolean.valueOf(childYaml.getYamlValue());
                continue;
            }
            if (!childYaml.getYamlId().equals(EAL_ID)) continue;
            ealLoc = childYaml.getYamlValue();
        }
        this.setIndex(indexLoc);
        this.setEnabled(enabledLoc);
        this.setCodeRegionEnabled(codeRegionLoc);
        this.setEal(ealLoc);
        return true;
    }

    public StorageTeeDisableableMemoryRegionConfig(BigInteger start, BigInteger size, String security, int index, boolean enabled) {
        this(start, size, security, null, index, enabled);
    }

    public StorageTeeDisableableMemoryRegionConfig(BigInteger start, BigInteger size, String security, @Nullable String template, int index, boolean enabled, @Nullable Boolean codeRegion) {
        this(start, size, security, template, index, enabled);
        this.codeRegionEnabled = codeRegion;
    }

    public StorageTeeDisableableMemoryRegionConfig(BigInteger start, BigInteger size, String security, @Nullable String template, int index, boolean enabled) {
        super(start, size, security, template);
        this.enabled = enabled;
        this.index = index;
    }

    public StorageTeeDisableableMemoryRegionConfig(BigInteger startAddr, BigInteger size, String security, @Nullable String template, int index, boolean enabled, @Nullable Boolean codeRegion, @Nullable String eal, @Nullable String domainTemplates) {
        this(startAddr, size, security, template, index, enabled);
        this.codeRegionEnabled = codeRegion;
        this.eal = eal;
        this.setDomainTemplates(domainTemplates);
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public @Nullable Boolean getCodeRegionEnabled() {
        return this.codeRegionEnabled;
    }

    public void setCodeRegionEnabled(@Nullable Boolean codeRegionEnabled) {
        this.codeRegionEnabled = codeRegionEnabled;
    }

    public @Nullable String getEal() {
        return this.eal;
    }

    public void setEal(@Nullable String eal) {
        this.eal = eal;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.codeRegionEnabled, this.enabled, this.index);
        return result;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        assert (obj != null);
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StorageTeeDisableableMemoryRegionConfig other = (StorageTeeDisableableMemoryRegionConfig)obj;
        return this.enabled == other.enabled && Objects.equals(this.codeRegionEnabled, other.codeRegionEnabled) && this.index == other.index && Objects.equals(this.eal, other.eal);
    }
}

