/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.configuration.storage.tee;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.yaml.IYamlStorable;
import com.nxp.swtools.common.utils.yaml.YamlStorableValue;
import com.nxp.swtools.provider.configuration.storage.tee.StorageTeeBaseMemoryRegionConfig;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.simpleframework.xml.Attribute;

public class StorageTeeLockableMemoryRegionConfig
extends StorageTeeBaseMemoryRegionConfig {
    @Attribute(name="locked", required=true)
    private boolean locked = false;
    @Attribute(name="index", required=true)
    private int index = 0;

    public StorageTeeLockableMemoryRegionConfig() {
    }

    public StorageTeeLockableMemoryRegionConfig(BigInteger start, BigInteger size, int index, boolean locked) {
        super(start, size);
        this.locked = locked;
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    @Override
    protected List<IYamlStorable> createYamlStorable() {
        ArrayList<IYamlStorable> storable = new ArrayList<IYamlStorable>();
        storable.add((IYamlStorable)new YamlStorableValue("index", Integer.toString(this.getIndex())));
        storable.add((IYamlStorable)new YamlStorableValue("locked", Boolean.toString(this.isLocked())));
        storable.addAll(super.createYamlStorable());
        return storable;
    }

    @Override
    protected boolean loadYamlConvertible(Collection<IYamlStorable> children) {
        if (!super.loadYamlConvertible(children)) {
            return false;
        }
        boolean lockedLoc = false;
        int indexLoc = 0;
        for (IYamlStorable childYaml : children) {
            if (!(childYaml instanceof YamlStorableValue)) continue;
            if (childYaml.getYamlId().equals("index")) {
                indexLoc = Integer.parseInt(childYaml.getYamlValue());
                continue;
            }
            if (!childYaml.getYamlId().equals("locked")) continue;
            lockedLoc = Boolean.parseBoolean(childYaml.getYamlValue());
        }
        this.setIndex(indexLoc);
        this.setLocked(lockedLoc);
        return true;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Boolean.hashCode(this.locked);
        result = 31 * result + Integer.hashCode(this.index);
        return result;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        StorageTeeLockableMemoryRegionConfig other = Objects.requireNonNull((StorageTeeLockableMemoryRegionConfig)obj);
        return this.index == other.index && this.locked == other.locked;
    }
}

