/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.configuration.storage.tee;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.common.utils.yaml.IYamlStorable;
import com.nxp.swtools.common.utils.yaml.YamlStorableHelper;
import com.nxp.swtools.common.utils.yaml.YamlStorableList;
import com.nxp.swtools.common.utils.yaml.YamlStorableValue;
import com.nxp.swtools.provider.configuration.storage.tee.StorageTeeDisableableConfig;
import com.nxp.swtools.provider.configuration.storage.tee.StorageTeeMpuMemoryAttrConfig;
import com.nxp.swtools.provider.configuration.storage.tee.StorageTeeMpuRegion;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;

@Root(strict=false, name="mpu")
public class StorageTeeMpuBank
extends StorageTeeDisableableConfig {
    private static final String ATTRIBUTES_ID = "attributes";
    public static final String MPU_ID = "mpu";
    public static final String DEFAULT_PRIV_ID = "priv_default_map";
    public static final String HANDLER_ENABLED_ID = "handler_enabled";
    public static final String GENERATE_CODE_FOR_DISABLED_REGIONS_ID = "generate_code_for_disabled_regions";
    @Attribute(name="priv_default_map", required=true)
    private boolean defaultPrivilegedAccessEnabled;
    @Attribute(name="handler_enabled", required=true)
    private boolean handlerOperationEnabled;
    @Attribute(name="id", required=false)
    @Nullable
    private @Attribute(name="id", required=false) @Nullable String id;
    @ElementList(inline=false, required=false, type=StorageTeeMpuMemoryAttrConfig.class, name="attributes")
    private ArrayList<StorageTeeMpuMemoryAttrConfig> storageMemoryAttributeConfigs = new ArrayList();
    @ElementList(inline=false, required=false, type=StorageTeeMpuRegion.class, name="regions")
    private ArrayList<StorageTeeMpuRegion> storageRegionConfigs = new ArrayList();
    @Attribute(name="generate_code_for_disabled_regions", required=true)
    private boolean generateCodeForDisabledRegions;
    @Nullable
    private Set<String> mastersIds = null;

    public @Nullable Set<String> getMastersIds() {
        return this.mastersIds;
    }

    public void setMastersIds(@Nullable Set<String> mastersIds) {
        this.mastersIds = mastersIds;
    }

    @Attribute(name="masters", required=false)
    public @Attribute(name="masters", required=false) @Nullable String getMastersIdsString() {
        return this.mastersIds != null ? UtilsText.join(this.mastersIds, (String)" ") : null;
    }

    @Attribute(name="masters", required=false)
    public void setMastersIdsString(@Nullable String mastersIdsString) {
        this.mastersIds = mastersIdsString != null ? new HashSet<String>(Arrays.asList(mastersIdsString.split(" "))) : null;
    }

    public boolean isDefaultPrivilegedAccessEnabled() {
        return this.defaultPrivilegedAccessEnabled;
    }

    public void setDefaultPrivilegedAccessEnabled(boolean defaultPrivilegedAccessEnabled) {
        this.defaultPrivilegedAccessEnabled = defaultPrivilegedAccessEnabled;
    }

    public boolean isHandlerOperationEnabled() {
        return this.handlerOperationEnabled;
    }

    public void setHandlerOperationEnabled(boolean handlerOperationEnabled) {
        this.handlerOperationEnabled = handlerOperationEnabled;
    }

    public boolean isGenerateCodeForDisabledRegions() {
        return this.generateCodeForDisabledRegions;
    }

    public void setGenerateCodeForDisabledRegions(boolean generateCodeForDisabledRegions) {
        this.generateCodeForDisabledRegions = generateCodeForDisabledRegions;
    }

    public List<StorageTeeMpuRegion> getStorageRegionConfigs() {
        return this.storageRegionConfigs;
    }

    public void setStorageRegionConfigs(List<StorageTeeMpuRegion> storageRegionConfigs) {
        this.storageRegionConfigs = new ArrayList<StorageTeeMpuRegion>(storageRegionConfigs);
    }

    public String getId() {
        return UtilsText.safeString((String)this.id);
    }

    public void setId(@Nullable String id) {
        this.id = id;
    }

    public void setStorageMemoryAttributeConfigs(List<StorageTeeMpuMemoryAttrConfig> storageMemoryAttributeConfigs) {
        this.storageMemoryAttributeConfigs = new ArrayList<StorageTeeMpuMemoryAttrConfig>(storageMemoryAttributeConfigs);
    }

    public List<StorageTeeMpuMemoryAttrConfig> getStorageMemoryAttributeConfigs() {
        return this.storageMemoryAttributeConfigs;
    }

    @Override
    protected String getYamlId() {
        return MPU_ID;
    }

    @Override
    protected List<IYamlStorable> createYamlStorable() {
        String mastersIdsString;
        List<IYamlStorable> storable = super.createYamlStorable();
        if (this.id != null) {
            storable.add((IYamlStorable)new YamlStorableValue("id", this.getId()));
        }
        if ((mastersIdsString = this.getMastersIdsString()) != null) {
            storable.add((IYamlStorable)new YamlStorableValue("masters", mastersIdsString));
        }
        storable.add((IYamlStorable)new YamlStorableValue(DEFAULT_PRIV_ID, Boolean.toString(this.isDefaultPrivilegedAccessEnabled())));
        storable.add((IYamlStorable)new YamlStorableValue(HANDLER_ENABLED_ID, Boolean.toString(this.isHandlerOperationEnabled())));
        storable.add((IYamlStorable)new YamlStorableValue(GENERATE_CODE_FOR_DISABLED_REGIONS_ID, Boolean.toString(this.isGenerateCodeForDisabledRegions())));
        YamlStorableList storageMemoryAttributeConfigsYaml = new YamlStorableList(ATTRIBUTES_ID, Boolean.TRUE);
        storageMemoryAttributeConfigsYaml.setForceSequence(true);
        this.storageMemoryAttributeConfigs.forEach(each -> each.fillYamlStorable((IYamlStorable)storageMemoryAttributeConfigsYaml));
        storable.add((IYamlStorable)storageMemoryAttributeConfigsYaml);
        YamlStorableList storageRegionConfigsYaml = new YamlStorableList("regions", Boolean.TRUE);
        storageRegionConfigsYaml.setForceSequence(true);
        this.storageRegionConfigs.forEach(each -> each.fillYamlStorable((IYamlStorable)storageRegionConfigsYaml));
        storable.add((IYamlStorable)storageRegionConfigsYaml);
        return storable;
    }

    @Override
    protected boolean loadYamlConvertible(Collection<IYamlStorable> children) {
        if (!super.loadYamlConvertible(children)) {
            return false;
        }
        boolean defaultPrivilegedAccessEnabledLoc = false;
        boolean handlerOperationEnabledLoc = false;
        String idLoc = "";
        ArrayList<StorageTeeMpuMemoryAttrConfig> storageMemoryAttributeConfigsLoc = new ArrayList<StorageTeeMpuMemoryAttrConfig>();
        ArrayList<StorageTeeMpuRegion> storageRegionConfigsLoc = new ArrayList<StorageTeeMpuRegion>();
        boolean generateCodeForDisabledRegionsLoc = false;
        String mastersIds = null;
        for (IYamlStorable childYaml : children) {
            if (childYaml instanceof YamlStorableValue) {
                if (childYaml.getYamlId().equals("id")) {
                    idLoc = childYaml.getYamlValue();
                } else if (childYaml.getYamlId().equals("masters")) {
                    mastersIds = childYaml.getYamlValue();
                } else if (childYaml.getYamlId().equals(DEFAULT_PRIV_ID)) {
                    defaultPrivilegedAccessEnabledLoc = Boolean.parseBoolean(childYaml.getYamlValue());
                } else if (childYaml.getYamlId().equals(HANDLER_ENABLED_ID)) {
                    handlerOperationEnabledLoc = Boolean.parseBoolean(childYaml.getYamlValue());
                } else if (childYaml.getYamlId().equals(GENERATE_CODE_FOR_DISABLED_REGIONS_ID)) {
                    generateCodeForDisabledRegionsLoc = Boolean.parseBoolean(childYaml.getYamlValue());
                }
            }
            if (!(childYaml instanceof YamlStorableList)) continue;
            if (childYaml.getYamlId().equals(ATTRIBUTES_ID)) {
                for (IYamlStorable regionYaml : CollectionsUtils.safeCollection((Collection)childYaml.getYamlChildren())) {
                    StorageTeeMpuMemoryAttrConfig config;
                    if (regionYaml instanceof YamlStorableList) {
                        regionYaml = YamlStorableHelper.skipMapLayer((YamlStorableList)((YamlStorableList)regionYaml), (String)"group");
                    }
                    if (!(config = new StorageTeeMpuMemoryAttrConfig()).updateFromYamlStorable(regionYaml)) continue;
                    storageMemoryAttributeConfigsLoc.add(config);
                }
                continue;
            }
            if (!childYaml.getYamlId().equals("regions")) continue;
            for (IYamlStorable regionYaml : CollectionsUtils.safeCollection((Collection)childYaml.getYamlChildren())) {
                StorageTeeMpuRegion region;
                if (regionYaml instanceof YamlStorableList) {
                    regionYaml = YamlStorableHelper.skipMapLayer((YamlStorableList)((YamlStorableList)regionYaml), (String)"region");
                }
                if (!(region = new StorageTeeMpuRegion()).updateFromYamlStorable(regionYaml)) continue;
                storageRegionConfigsLoc.add(region);
            }
        }
        this.setId(idLoc);
        this.setMastersIdsString(mastersIds);
        this.setDefaultPrivilegedAccessEnabled(defaultPrivilegedAccessEnabledLoc);
        this.setHandlerOperationEnabled(handlerOperationEnabledLoc);
        this.setGenerateCodeForDisabledRegions(generateCodeForDisabledRegionsLoc);
        this.setStorageMemoryAttributeConfigs(storageMemoryAttributeConfigsLoc);
        this.setStorageRegionConfigs(storageRegionConfigsLoc);
        return true;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + Objects.hash(this.defaultPrivilegedAccessEnabled, this.handlerOperationEnabled, this.id, this.storageRegionConfigs.size(), this.storageMemoryAttributeConfigs.size());
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        StorageTeeMpuBank other = Objects.requireNonNull((StorageTeeMpuBank)obj);
        return this.defaultPrivilegedAccessEnabled == other.defaultPrivilegedAccessEnabled && this.generateCodeForDisabledRegions == other.generateCodeForDisabledRegions && this.handlerOperationEnabled == other.handlerOperationEnabled && this.enabled == other.enabled && Objects.equals(this.id, other.id) && Objects.equals(this.storageMemoryAttributeConfigs, other.storageMemoryAttributeConfigs) && Objects.equals(this.storageRegionConfigs, other.storageRegionConfigs);
    }
}

