/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.configuration.storage.tee;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.common.utils.yaml.IYamlStorable;
import com.nxp.swtools.common.utils.yaml.YamlStorableValue;
import com.nxp.swtools.provider.configuration.storage.tee.StorageTeeCheckerMemorySlaveConfig;
import java.util.List;
import java.util.Objects;
import org.simpleframework.xml.Attribute;

public class StorageTeeRdcCheckerSlaveConfig
extends StorageTeeCheckerMemorySlaveConfig {
    @Attribute(name="enabled", required=false)
    @Nullable
    private @Attribute(name="enabled", required=false) @Nullable Boolean enabled;
    @Attribute(name="locked", required=true)
    private String locked = "";
    @Attribute(name="semaphore_required", required=false)
    @Nullable
    private @Attribute(name="semaphore_required", required=false) @Nullable String semaphoreRequired;

    @Override
    protected void addUnderlyingYaml(List<IYamlStorable> storable) {
        super.addUnderlyingYaml(storable);
        if (this.enabled != null) {
            storable.add((IYamlStorable)new YamlStorableValue("enabled", this.enabled.toString()));
        }
        storable.add((IYamlStorable)new YamlStorableValue("locked", this.locked));
        if (this.semaphoreRequired != null) {
            storable.add((IYamlStorable)new YamlStorableValue("semaphore_required", this.semaphoreRequired));
        }
    }

    @Override
    protected boolean updatePropertyFromYaml(IYamlStorable yaml) {
        boolean updated = super.updatePropertyFromYaml(yaml);
        if (!updated) {
            String yamlId = yaml.getYamlId();
            if (yaml instanceof YamlStorableValue) {
                if (yamlId.equals("enabled")) {
                    this.setEnabled(Boolean.parseBoolean(yaml.getYamlValue()));
                    updated = true;
                } else if (yamlId.equals("locked")) {
                    this.setLocked(yaml.getYamlValue());
                    updated = true;
                } else if (yamlId.equals("semaphore_required")) {
                    this.setSemaphoreRequired(yaml.getYamlValue());
                    updated = true;
                }
            }
        }
        return updated;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean getEnabled() {
        return this.enabled != null ? this.enabled : true;
    }

    public void setLocked(String locked) {
        this.locked = locked;
    }

    public String getLocked() {
        return this.locked;
    }

    public void setSemaphoreRequired(@Nullable String semaphoreRequired) {
        this.semaphoreRequired = semaphoreRequired;
    }

    public String getSemaphoreRequired() {
        return UtilsText.safeString((String)this.semaphoreRequired);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + Objects.hash(this.enabled, this.locked, this.semaphoreRequired);
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        assert (obj != null);
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StorageTeeRdcCheckerSlaveConfig other = (StorageTeeRdcCheckerSlaveConfig)obj;
        return Objects.equals(this.enabled, other.enabled) && Objects.equals(this.locked, other.locked) && Objects.equals(this.semaphoreRequired, other.semaphoreRequired);
    }

    @Override
    public String toString() {
        return String.format("%s [%s, enabled=%s, locked=%s, semaphoreRequired=%s]", StorageTeeRdcCheckerSlaveConfig.class.getSimpleName(), super.toString(), this.enabled, this.locked, this.semaphoreRequired);
    }
}

