/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.configuration.storage.tee;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.yaml.IYamlStorable;
import com.nxp.swtools.common.utils.yaml.YamlStorableValue;
import com.nxp.swtools.provider.configuration.storage.tee.StorageTeeMemoryRegionConfig;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Root;

@Root(strict=false, name="relative_region")
public class StorageTeeRelativeMemoryRegionConfig
extends StorageTeeMemoryRegionConfig {
    public static final String RELATIVE_REGION_ID = "relative_region";
    private static final String MEMORY_AREA_ID = "memory";
    @Attribute(name="memory")
    private String memoryAreaId = "";

    public StorageTeeRelativeMemoryRegionConfig(String memory, BigInteger start, BigInteger size, String security) {
        super(start, size, security);
        this.memoryAreaId = memory;
    }

    public StorageTeeRelativeMemoryRegionConfig() {
    }

    public String getMemAreaId() {
        return this.memoryAreaId;
    }

    public void setMemory(String memory) {
        this.memoryAreaId = memory;
    }

    @Override
    protected String getYamlId() {
        return RELATIVE_REGION_ID;
    }

    @Override
    protected List<IYamlStorable> createYamlStorable() {
        ArrayList<IYamlStorable> storable = new ArrayList<IYamlStorable>();
        storable.add((IYamlStorable)new YamlStorableValue(MEMORY_AREA_ID, this.getMemAreaId()));
        storable.addAll(super.createYamlStorable());
        return storable;
    }

    @Override
    protected boolean loadYamlConvertible(Collection<IYamlStorable> children) {
        if (!super.loadYamlConvertible(children)) {
            return false;
        }
        String memoryAreaIdLoc = "";
        for (IYamlStorable childYaml : children) {
            if (!(childYaml instanceof YamlStorableValue) || !childYaml.getYamlId().equals(MEMORY_AREA_ID)) continue;
            memoryAreaIdLoc = childYaml.getYamlValue();
        }
        this.setMemory(memoryAreaIdLoc);
        return true;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.memoryAreaId.hashCode();
        return result;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        assert (obj != null);
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StorageTeeRelativeMemoryRegionConfig other = (StorageTeeRelativeMemoryRegionConfig)obj;
        return this.memoryAreaId.equals(other.memoryAreaId);
    }
}

